/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.qt.core.qmljs;

import org.eclipse.cdt.qt.core.qmljs.IJSExpression;
import org.eclipse.cdt.qt.core.qmljs.IJSLiteral;
import org.eclipse.cdt.qt.core.qmljs.IJSUnaryExpression;

public final class QMLExpressionEvaluator {
    private QMLExpressionEvaluator() {
    }

    public static Object evaluateConstExpr(IJSExpression expr) throws InvalidExpressionException {
        if (expr instanceof IJSLiteral) {
            return ((IJSLiteral)expr).getValue();
        }
        if (expr instanceof IJSUnaryExpression) {
            IJSUnaryExpression unary = (IJSUnaryExpression)expr;
            Object arg = QMLExpressionEvaluator.evaluateConstExpr(unary.getArgument());
            switch (unary.getOperator()) {
                case Plus: {
                    return QMLExpressionEvaluator.unaryPlus(arg, unary.getArgument());
                }
                case Negation: {
                    return QMLExpressionEvaluator.unaryNegate(arg, unary.getArgument());
                }
                case BitwiseNot: {
                    return QMLExpressionEvaluator.unaryBitwiseNot(arg, unary.getArgument());
                }
                case Not: {
                    return QMLExpressionEvaluator.unaryNot(arg, unary.getArgument());
                }
            }
        }
        throw new InvalidExpressionException("Cannot reduce '" + expr + "' to a constant", expr);
    }

    private static Object unaryPlus(Object object, IJSExpression expr) throws InvalidExpressionException {
        if (object instanceof Byte) {
            return (int)((Byte)object).byteValue();
        }
        if (object instanceof Short) {
            return (int)((Short)object).shortValue();
        }
        if (object instanceof Integer) {
            return (int)((Integer)object);
        }
        if (object instanceof Long) {
            return (long)((Long)object);
        }
        if (object instanceof Float) {
            return Float.valueOf(((Float)object).floatValue());
        }
        if (object instanceof Double) {
            return (double)((Double)object);
        }
        throw new InvalidExpressionException("Cannot perform unary plus operation on a non-number", expr);
    }

    private static Object unaryNegate(Object object, IJSExpression expr) throws InvalidExpressionException {
        if (object instanceof Byte) {
            return (int)(-((Byte)object).byteValue());
        }
        if (object instanceof Short) {
            return (int)(-((Short)object).shortValue());
        }
        if (object instanceof Integer) {
            return -((Integer)object).intValue();
        }
        if (object instanceof Long) {
            return -((Long)object).longValue();
        }
        if (object instanceof Float) {
            return Float.valueOf(-((Float)object).floatValue());
        }
        if (object instanceof Double) {
            return -((Double)object).doubleValue();
        }
        throw new InvalidExpressionException("Cannot perform unary negation operation on a non-number", expr);
    }

    private static Object unaryBitwiseNot(Object object, IJSExpression expr) throws InvalidExpressionException {
        if (object instanceof Byte) {
            return (int)(~((Byte)object).byteValue());
        }
        if (object instanceof Short) {
            return (int)(~((Short)object).shortValue());
        }
        if (object instanceof Integer) {
            return ~((Integer)object).intValue();
        }
        if (object instanceof Long) {
            return (Long)object ^ 0xFFFFFFFFFFFFFFFFL;
        }
        if (object instanceof Float || object instanceof Double) {
            return ((Number)object).longValue() ^ 0xFFFFFFFFFFFFFFFFL;
        }
        throw new InvalidExpressionException("Cannot perform binary not operation on a non-number", expr);
    }

    private static Object unaryNot(Object object, IJSExpression expr) throws InvalidExpressionException {
        if (object instanceof Boolean) {
            return (Boolean)object == false;
        }
        throw new InvalidExpressionException("Cannot perform unary not operation on a non-boolean", expr);
    }

    public static class InvalidExpressionException
    extends Exception {
        private static final long serialVersionUID = 4803923632666457229L;
        private IJSExpression offendingExpression;

        public InvalidExpressionException(String msg, IJSExpression expr) {
            super(msg);
            this.offendingExpression = expr;
        }

        public IJSExpression getOffendingExpression() {
            return this.offendingExpression;
        }
    }
}

