/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.core.model;

import com.ibm.icu.util.ULocale;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.report.designer.core.CorePlugin;
import org.eclipse.birt.report.designer.core.mediator.IMediator;
import org.eclipse.birt.report.designer.core.mediator.IMediatorRequest;
import org.eclipse.birt.report.designer.core.mediator.IMediatorState;
import org.eclipse.birt.report.designer.core.mediator.IMediatorStateConverter;
import org.eclipse.birt.report.designer.core.mediator.MediatorManager;
import org.eclipse.birt.report.designer.core.util.mediator.ModuleMediatorTarget;
import org.eclipse.birt.report.designer.core.util.mediator.request.ReportRequest;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.DesignConfig;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.MasterPageHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ModuleOption;
import org.eclipse.birt.report.model.api.SessionHandle;
import org.eclipse.birt.report.model.api.SimpleMasterPageHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.ContentException;
import org.eclipse.birt.report.model.api.command.NameException;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class SessionHandleAdapter
implements IMediatorStateConverter {
    private ThreadLocal threadSession = new ThreadLocal();
    public static final int UNKNOWFILE = -1;
    public static final int DESIGNEFILE = 0;
    public static final int LIBRARYFILE = 1;
    public static final int TEMPLATEFILE = 2;
    private int type = 0;
    private IWindowListener pageListener = new IWindowListener(){

        public void windowActivated(IWorkbenchWindow window) {
        }

        public void windowClosed(IWorkbenchWindow window) {
            SessionHandleAdapter.this.moduleHandleMap.remove(window);
        }

        public void windowDeactivated(IWorkbenchWindow window) {
        }

        public void windowOpened(IWorkbenchWindow window) {
        }
    };
    private Map<IWorkbenchWindow, ModuleHandle> moduleHandleMap = new HashMap<IWorkbenchWindow, ModuleHandle>();
    private static SessionHandleAdapter sessionAdapter;
    private SessionHandle sessionHandle;
    private ModuleHandle model;

    private SessionHandleAdapter() {
    }

    public int getFileType() {
        return this.type;
    }

    public static synchronized SessionHandleAdapter getInstance() {
        if (sessionAdapter == null) {
            sessionAdapter = new SessionHandleAdapter();
        }
        return sessionAdapter;
    }

    public SessionHandle getSessionHandle(boolean useThreadLocal) {
        if (useThreadLocal) {
            return this.getThreadLocalSessionHandle();
        }
        return this.getSessionHandle();
    }

    public SessionHandle getSessionHandle() {
        if (this.sessionHandle == null) {
            this.sessionHandle = new DesignEngine(new DesignConfig()).newSessionHandle(ULocale.getDefault());
            try {
                if (!CorePlugin.isUseNormalTheme()) {
                    this.sessionHandle.setDefaultValue("color", (Object)DEUtil.getRGBInt(CorePlugin.ReportForeground.getRGB()));
                }
            }
            catch (PropertyValueException propertyValueException) {}
        }
        return this.sessionHandle;
    }

    public SessionHandle getThreadLocalSessionHandle() {
        SessionHandle s = (SessionHandle)this.threadSession.get();
        if (s == null) {
            s = new DesignEngine(new DesignConfig()).newSessionHandle(ULocale.getDefault());
            try {
                if (!CorePlugin.isUseNormalTheme()) {
                    s.setDefaultValue("color", (Object)DEUtil.getRGBInt(CorePlugin.ReportForeground.getRGB()));
                }
            }
            catch (PropertyValueException propertyValueException) {}
            this.threadSession.set(s);
        }
        return s;
    }

    public ModuleHandle init(String fileName, InputStream input, Map properties) throws DesignFileException {
        return this.init(fileName, input, properties, false);
    }

    public ModuleHandle init(String fileName, InputStream input, Map properties, boolean useThreadLocal) throws DesignFileException {
        ModuleHandle handle = null;
        handle = properties == null ? this.getSessionHandle(useThreadLocal).openModule(fileName, input) : this.getSessionHandle(useThreadLocal).openModule(fileName, input, new ModuleOption(properties));
        this.postInit(handle, properties);
        handle.getCommandStack().flush();
        return handle;
    }

    public ModuleHandle init(String fileName, InputStream input) throws DesignFileException {
        return this.init(fileName, input, null);
    }

    private void postInit(ModuleHandle handle, Map properties) {
        String createInfo;
        if (!(properties == null || properties.isEmpty() || (createInfo = handle.getCreatedBy()) != null && createInfo.length() != 0)) {
            try {
                handle.initializeModule(properties);
            }
            catch (SemanticException semanticException) {}
        }
        SimpleMasterPageHandle masterPage = null;
        if (handle.getMasterPages() != null && handle.getMasterPages().getCount() == 0) {
            masterPage = handle.getElementFactory().newSimpleMasterPage(null);
            try {
                handle.getMasterPages().add((DesignElementHandle)masterPage);
            }
            catch (ContentException contentException) {
            }
            catch (NameException nameException) {}
        }
    }

    public ModuleHandle creatReportDesign() {
        return this.getSessionHandle().createDesign();
    }

    public ModuleHandle getReportDesignHandle() {
        return this.getModule();
    }

    public ModuleHandle getModule() {
        if (this.model == null) {
            IWorkbenchWindow activeWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            this.model = this.moduleHandleMap.get(activeWindow);
        }
        return this.model;
    }

    public void setReportDesignHandle(ModuleHandle handle) {
        this.setModule(handle);
    }

    public void setModule(ModuleHandle handle) {
        PlatformUI.getWorkbench().removeWindowListener(this.pageListener);
        IWorkbenchWindow activeWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (handle == null) {
            this.moduleHandleMap.remove(activeWindow);
        } else {
            PlatformUI.getWorkbench().addWindowListener(this.pageListener);
        }
        if (activeWindow != null) {
            this.moduleHandleMap.put(activeWindow, handle);
        }
        this.model = handle;
    }

    public CommandStack getCommandStack() {
        if (this.getReportDesignHandle() != null) {
            return this.getReportDesignHandle().getCommandStack();
        }
        return null;
    }

    public CommandStack getCommandStack(ModuleHandle handle) {
        if (handle != null) {
            return handle.getCommandStack();
        }
        return null;
    }

    public MasterPageHandle getMasterPageHandle() {
        return this.getFirstMasterPageHandle(this.getReportDesignHandle());
    }

    public MasterPageHandle getMasterPageHandle(ModuleHandle handle) {
        return this.getFirstMasterPageHandle(handle);
    }

    public MasterPageHandle getFirstMasterPageHandle(ModuleHandle handle) {
        if (handle == null) {
            return null;
        }
        SlotHandle slotHandle = handle.getMasterPages();
        if (slotHandle != null && slotHandle.getCount() > 0) {
            return (MasterPageHandle)slotHandle.getContents().get(0);
        }
        return null;
    }

    public IMediator getMediator(ModuleHandle handle) {
        return this.getMediator(handle, true);
    }

    public IMediator getMediator(ModuleHandle handle, boolean force) {
        IMediator mt = MediatorManager.getInstance().getMediator(new ModuleMediatorTarget(handle), force);
        if (mt != null) {
            mt.setStateConverter(this);
        }
        return mt;
    }

    public IMediator getMediator() {
        return this.getMediator(this.getReportDesignHandle());
    }

    public void resetReportDesign(ModuleHandle oldObj, ModuleHandle newObj) {
        this.resetModule(oldObj, newObj);
    }

    public void resetModule(ModuleHandle oldObj, ModuleHandle newObj) {
        MediatorManager.getInstance().resetTarget(new ModuleMediatorTarget(oldObj), new ModuleMediatorTarget(newObj));
    }

    public void clear(ModuleHandle handle) {
        MediatorManager.getInstance().removeMediator(new ModuleMediatorTarget(handle));
        if (handle == this.getReportDesignHandle()) {
            this.setReportDesignHandle(null);
            this.getSessionHandle().setResourceFolder(null);
        }
    }

    @Override
    public IMediatorRequest convertStateToRequest(IMediatorState state) {
        ReportRequest request = new ReportRequest(state.getSource(), state.getType());
        if (state.getData() instanceof List) {
            request.setSelectionObject((List)state.getData());
        } else if (state.getData() != null) {
            ArrayList<Object> lst = new ArrayList<Object>();
            lst.add(state.getData());
            request.setSelectionObject(lst);
        }
        return request;
    }
}

