/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.blind.html.util;

import org.eclipse.actf.visualization.engines.voicebrowser.IPacket;
import org.w3c.dom.Node;

public class VisualizationNodeInfo {
    private int orgTotalWords;
    private int orgTotalLines;
    private int orgTime = 0;
    private int totalWords;
    private int totalLines;
    private int words;
    private int lines;
    private int id;
    private int packetId;
    private IPacket packet = null;
    private Node node = null;
    private boolean isHeading = false;
    private boolean isLandmark = false;
    private boolean isCaption = false;
    private boolean tableHeader = false;
    private boolean isLabel = false;
    private boolean isIdRequiredInput = false;
    private boolean isSequence = false;
    private boolean isBlockElement = false;
    private boolean isInvisible = false;
    private int time = 0;
    private String comment = "";

    VisualizationNodeInfo() {
        this.totalWords = 0;
        this.totalLines = 0;
        this.words = 0;
        this.lines = 0;
        this.id = 0;
        this.packetId = 0;
        this.packet = null;
        this.node = null;
    }

    VisualizationNodeInfo(VisualizationNodeInfo visualizationNodeInfo) {
        if (visualizationNodeInfo != null) {
            this.totalWords = visualizationNodeInfo.getTotalWords();
            this.totalLines = visualizationNodeInfo.getTotalLines();
            this.words = visualizationNodeInfo.getWords();
            this.lines = visualizationNodeInfo.getLines();
            this.packet = visualizationNodeInfo.getPacket();
            this.packetId = visualizationNodeInfo.getPacketId();
            if (this.packet == null) {
                this.node = visualizationNodeInfo.getNode();
            }
            this.comment = "";
            this.id = 0;
            if (this.packet == null) {
                // empty if block
            }
        } else {
            this.totalWords = 0;
            this.totalLines = 0;
            this.words = 0;
            this.lines = 0;
            this.id = 0;
            this.packetId = 0;
            this.packet = null;
            this.node = null;
            this.comment = "";
        }
    }

    public Node getNode() {
        if (this.packet != null) {
            return this.packet.getNode();
        }
        return this.node;
    }

    public int getTotalWords() {
        return this.totalWords;
    }

    public void setNode(Node node) {
        this.packet = null;
        this.node = node;
    }

    public void setTotalWords(int n) {
        this.totalWords = n;
    }

    public int getLines() {
        return this.lines;
    }

    public int getTotalLines() {
        return this.totalLines;
    }

    public int getWords() {
        return this.words;
    }

    public void setLines(int n) {
        this.lines = n;
    }

    public void setTotalLines(int n) {
        this.totalLines = n;
    }

    public void setWords(int n) {
        this.words = n;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int n) {
        this.id = n;
    }

    public int getPacketId() {
        return this.packetId;
    }

    public void setPacketId(int n) {
        this.packetId = n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" Info=");
        stringBuffer.append(String.valueOf(this.getTime()) + " : ");
        stringBuffer.append(this.getTotalWords());
        stringBuffer.append(",");
        stringBuffer.append(this.getWords());
        stringBuffer.append(",");
        stringBuffer.append(this.getTotalLines());
        stringBuffer.append(",");
        stringBuffer.append(this.getLines());
        stringBuffer.append(",");
        stringBuffer.append(this.getNode());
        return stringBuffer.toString();
    }

    public IPacket getPacket() {
        return this.packet;
    }

    public void setPacket(IPacket iPacket) {
        this.packet = iPacket;
    }

    public boolean isHeading() {
        return this.isHeading;
    }

    public void setHeading(boolean bl) {
        this.isHeading = bl;
    }

    public boolean isLandmark() {
        return this.isLandmark;
    }

    public boolean isCaption() {
        return this.isCaption;
    }

    public void setCaption(boolean bl) {
        this.isCaption = bl;
    }

    public void setLandmark(boolean bl) {
        this.isLandmark = bl;
    }

    public int getTime() {
        return this.time;
    }

    public void setTime(int n) {
        this.time = n;
    }

    public String getComment() {
        return this.comment;
    }

    public void appendComment(String string) {
        this.comment = this.comment.length() != 0 ? String.valueOf(this.comment) + " " + string : string;
    }

    public boolean isTableHeader() {
        return this.tableHeader;
    }

    public void setTableHeader(boolean bl) {
        this.tableHeader = bl;
    }

    public boolean isLabel() {
        return this.isLabel;
    }

    public void setLabel(boolean bl) {
        this.isLabel = bl;
    }

    public boolean isIdRequiredInput() {
        return this.isIdRequiredInput;
    }

    public void setIdRequiredInput(boolean bl) {
        this.isIdRequiredInput = bl;
    }

    public void setAccesskey(boolean bl) {
    }

    public boolean isSequence() {
        return this.isSequence;
    }

    public void setSequence(boolean bl) {
        this.isSequence = bl;
    }

    public boolean isBlockElement() {
        return this.isBlockElement;
    }

    public void setBlockElement(boolean bl) {
        this.isBlockElement = bl;
    }

    public boolean isInvisible() {
        return this.isInvisible;
    }

    public void setInvisible(boolean bl) {
        this.isInvisible = bl;
    }

    public int getOrgTime() {
        return this.orgTime;
    }

    public int getOrgTotalLines() {
        return this.orgTotalLines;
    }

    public int getOrgTotalWords() {
        return this.orgTotalWords;
    }

    public void setOrgTime(int n) {
        this.orgTime = n;
    }

    public void setOrgTotalLines(int n) {
        this.orgTotalLines = n;
    }

    public void setOrgTotalWords(int n) {
        this.orgTotalWords = n;
    }
}

