/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable.sort;

import net.sourceforge.nattable.layer.AbstractLayerTransform;
import net.sourceforge.nattable.layer.ILayer;
import net.sourceforge.nattable.layer.LabelStack;
import net.sourceforge.nattable.persistence.IPersistable;
import net.sourceforge.nattable.sort.ISortModel;
import net.sourceforge.nattable.sort.SortDirectionEnum;
import net.sourceforge.nattable.sort.SortStatePersistor;
import net.sourceforge.nattable.sort.command.SortCommandHandler;
import net.sourceforge.nattable.sort.config.DefaultSortConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortHeaderLayer<T>
extends AbstractLayerTransform
implements IPersistable {
    private final ISortModel sortModel;

    public SortHeaderLayer(ILayer underlyingLayer, ISortModel sortModel) {
        this(underlyingLayer, sortModel, true);
    }

    public SortHeaderLayer(ILayer underlyingLayer, ISortModel sortModel, boolean useDefaultConfiguration) {
        super(underlyingLayer);
        this.sortModel = sortModel;
        this.registerPersistable(new SortStatePersistor(this));
        this.registerCommandHandler(new SortCommandHandler(sortModel, this));
        if (useDefaultConfiguration) {
            this.addConfiguration(new DefaultSortConfiguration());
        }
    }

    @Override
    public LabelStack getConfigLabelsByPosition(int columnPosition, int rowPosition) {
        int columnIndex;
        LabelStack configLabels = super.getConfigLabelsByPosition(columnPosition, rowPosition);
        if (this.sortModel != null && this.sortModel.isColumnIndexSorted(columnIndex = this.getColumnIndexByPosition(columnPosition))) {
            SortDirectionEnum sortDirection = this.sortModel.getSortDirection(columnIndex);
            switch (sortDirection) {
                case ASC: {
                    configLabels.addLabel("SORT_UP");
                    break;
                }
                case DESC: {
                    configLabels.addLabel("SORT_DOWN");
                }
            }
            String sortConfig = "SORT_SEQ_" + this.sortModel.getSortOrder(columnIndex);
            configLabels.addLabel(sortConfig);
        }
        return configLabels;
    }

    protected ISortModel getSortModel() {
        return this.sortModel;
    }
}

