/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable.painter.cell;

import java.util.Map;
import java.util.WeakHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.nattable.config.CellConfigAttributes;
import net.sourceforge.nattable.config.IConfigRegistry;
import net.sourceforge.nattable.data.convert.IDisplayConverter;
import net.sourceforge.nattable.layer.cell.LayerCell;
import net.sourceforge.nattable.painter.cell.BackgroundPainter;
import net.sourceforge.nattable.style.CellStyleAttributes;
import net.sourceforge.nattable.style.CellStyleUtil;
import net.sourceforge.nattable.style.IStyle;
import net.sourceforge.nattable.util.GUIHelper;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

public class TextPainter
extends BackgroundPainter {
    private static final Pattern endOfPreviousWordPattern = Pattern.compile("\\S\\s+\\S+\\s*$");
    public static final String EMPTY = "";
    public static final String DOT = "...";
    private static Map<String, Integer> temporaryMap = new WeakHashMap<String, Integer>();
    private static Map<Font, FontData[]> fontDataCache = new WeakHashMap<Font, FontData[]>();
    private final boolean wrapText;
    private final boolean paintBg;

    public TextPainter() {
        this(false, true);
    }

    public TextPainter(boolean wrapText, boolean paintBg) {
        this.wrapText = wrapText;
        this.paintBg = paintBg;
    }

    public int getPreferredWidth(LayerCell cell, GC gc, IConfigRegistry configRegistry) {
        this.setupGCFromConfig(gc, CellStyleUtil.getCellStyle(cell, configRegistry));
        return this.getWidthFromCache(gc, this.convertDataType(cell, configRegistry));
    }

    public int getPreferredHeight(LayerCell cell, GC gc, IConfigRegistry configRegistry) {
        this.setupGCFromConfig(gc, CellStyleUtil.getCellStyle(cell, configRegistry));
        return gc.textExtent((String)this.convertDataType((LayerCell)cell, (IConfigRegistry)configRegistry)).y;
    }

    protected String convertDataType(LayerCell cell, IConfigRegistry configRegistry) {
        IDisplayConverter displayConverter = configRegistry.getConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, cell.getDisplayMode(), cell.getConfigLabels().getLabels());
        String text = displayConverter != null ? (String)displayConverter.canonicalToDisplayValue(cell.getDataValue()) : null;
        text = text == null ? EMPTY : text;
        return text;
    }

    public void setupGCFromConfig(GC gc, IStyle cellStyle) {
        Color fg = cellStyle.getAttributeValue(CellStyleAttributes.FOREGROUND_COLOR);
        Color bg = cellStyle.getAttributeValue(CellStyleAttributes.BACKGROUND_COLOR);
        Font font = cellStyle.getAttributeValue(CellStyleAttributes.FONT);
        gc.setAntialias(-1);
        gc.setTextAntialias(-1);
        gc.setFont(font);
        gc.setForeground(fg != null ? fg : GUIHelper.COLOR_LIST_FOREGROUND);
        gc.setBackground(bg != null ? bg : GUIHelper.COLOR_LIST_BACKGROUND);
    }

    public void paintCell(LayerCell cell, GC gc, Rectangle rectangle, IConfigRegistry configRegistry) {
        String text;
        if (this.paintBg) {
            super.paintCell(cell, gc, rectangle, configRegistry);
        }
        Rectangle originalClipping = gc.getClipping();
        gc.setClipping(rectangle.intersection(originalClipping));
        IStyle cellStyle = CellStyleUtil.getCellStyle(cell, configRegistry);
        this.setupGCFromConfig(gc, cellStyle);
        String originalText = text = this.convertDataType(cell, configRegistry);
        int originalTextWidth = this.getWidthFromCache(gc, originalText);
        text = this.getAvailableTextToDisplay(gc, rectangle, text);
        int contentWidth = Math.min(originalTextWidth, rectangle.width);
        int fontHeight = gc.getFontMetrics().getHeight();
        int contentHeight = fontHeight * this.getNumberOfNewLines(text);
        gc.drawText(text, rectangle.x + CellStyleUtil.getHorizontalAlignmentPadding(cellStyle, rectangle, contentWidth), rectangle.y + CellStyleUtil.getVerticalAlignmentPadding(cellStyle, rectangle, contentHeight), true);
        gc.setClipping(originalClipping);
    }

    private int getNumberOfNewLines(String text) {
        char[] charArray = text.toCharArray();
        int lineCount = 1;
        char[] cArray = charArray;
        int n = charArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c == '\n') {
                ++lineCount;
            }
            ++n2;
        }
        return lineCount;
    }

    private int getWidthFromCache(GC gc, String text) {
        Integer width;
        String originalString = text;
        StringBuilder buffer = new StringBuilder();
        buffer.append(text);
        if (gc.getFont() != null) {
            FontData[] datas = fontDataCache.get(gc.getFont());
            if (datas == null) {
                datas = gc.getFont().getFontData();
                fontDataCache.put(gc.getFont(), datas);
            }
            if (datas != null && datas.length > 0) {
                buffer.append(datas[0].getName());
                buffer.append(",");
                buffer.append(datas[0].getHeight());
                buffer.append(",");
                buffer.append(datas[0].getStyle());
            }
        }
        if ((width = temporaryMap.get(text = buffer.toString())) == null) {
            width = gc.textExtent((String)originalString).x;
            temporaryMap.put(text, width);
        }
        return width;
    }

    private String getAvailableTextToDisplay(GC gc, Rectangle bounds, String text) {
        StringBuilder output = new StringBuilder();
        text = text.trim();
        while (text.length() > 0) {
            String line;
            int nextLineBreakIndex;
            int indexOfNewline = text.indexOf(10);
            if (indexOfNewline > 0) {
                nextLineBreakIndex = indexOfNewline;
                line = text.substring(0, nextLineBreakIndex);
            } else {
                nextLineBreakIndex = -1;
                line = text;
            }
            int textWidth = this.getWidthFromCache(gc, line);
            if (this.wrapText) {
                while (textWidth > bounds.width + 1) {
                    Matcher matcher = endOfPreviousWordPattern.matcher(line);
                    if (matcher.find()) {
                        nextLineBreakIndex = matcher.start() + 1;
                        line = line.substring(0, nextLineBreakIndex);
                        textWidth = this.getWidthFromCache(gc, line);
                        continue;
                    }
                    nextLineBreakIndex = -1;
                    break;
                }
            }
            if (textWidth > bounds.width + 1) {
                int textLen = line.length();
                int i = textLen - 1;
                while (i >= 0) {
                    String temp = String.valueOf(line.substring(0, i)) + DOT;
                    textWidth = this.getWidthFromCache(gc, temp);
                    if (textWidth < bounds.width) {
                        line = temp;
                        break;
                    }
                    if (i == 0) {
                        line = EMPTY;
                    }
                    --i;
                }
            }
            output.append(line);
            if (nextLineBreakIndex <= 0) break;
            if ((text = text.substring(nextLineBreakIndex).trim()).length() <= 0) continue;
            output.append("\n");
        }
        return output.toString();
    }
}

