/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable.edit.editor;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.nattable.edit.editor.AbstractCellEditor;
import net.sourceforge.nattable.edit.editor.IComboBoxDataProvider;
import net.sourceforge.nattable.selection.SelectionLayer;
import net.sourceforge.nattable.util.ArrayUtil;
import net.sourceforge.nattable.widget.NatCombo;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComboBoxCellEditor
extends AbstractCellEditor {
    private NatCombo combo;
    private int maxVisibleItems = 10;
    private Object originalCanonicalValue;
    private final List<?> canonicalValues;

    public ComboBoxCellEditor(List<?> canonicalValues) {
        this(canonicalValues, 5);
    }

    public ComboBoxCellEditor(IComboBoxDataProvider dataProvider) {
        this(dataProvider.getValues(), 5);
    }

    public ComboBoxCellEditor(List<?> canonicalValues, int maxVisibleItems) {
        this.canonicalValues = canonicalValues;
        this.maxVisibleItems = maxVisibleItems;
    }

    @Override
    protected Control activateCell(Composite parent, Object originalCanonicalValue, Character initialEditValue) {
        this.originalCanonicalValue = originalCanonicalValue;
        this.combo = new NatCombo(parent, this.getCellStyle(), this.maxVisibleItems);
        this.combo.setItems(this.getDisplayValues());
        if (originalCanonicalValue != null) {
            this.combo.setSelection(new String[]{this.getDisplayValue()});
        }
        this.combo.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.keyCode == 13 && event.stateMask == 0 || event.keyCode == 0x1000050 && event.stateMask == 0) {
                    ComboBoxCellEditor.this.commit(SelectionLayer.MoveDirectionEnum.NONE);
                } else if (event.keyCode == 27 && event.stateMask == 0) {
                    ComboBoxCellEditor.this.close();
                }
            }
        });
        this.combo.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent event) {
                if (event.keyCode == 9 && event.stateMask == 131072) {
                    ComboBoxCellEditor.this.commit(SelectionLayer.MoveDirectionEnum.LEFT);
                } else if (event.keyCode == 9 && event.stateMask == 0) {
                    ComboBoxCellEditor.this.commit(SelectionLayer.MoveDirectionEnum.RIGHT);
                }
            }
        });
        this.combo.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                ComboBoxCellEditor.this.commit(SelectionLayer.MoveDirectionEnum.NONE);
            }
        });
        return this.combo;
    }

    @Override
    public Object getCanonicalValue() {
        int selectionIndex = this.combo.getSelectionIndex();
        if (selectionIndex >= 0) {
            return this.canonicalValues.get(selectionIndex);
        }
        return this.originalCanonicalValue;
    }

    public void select(int index) {
        this.combo.select(index);
    }

    @Override
    public void setCanonicalValue(Object value) {
    }

    @Override
    public void close() {
        super.close();
        if (this.combo != null && !this.combo.isDisposed()) {
            this.combo.dispose();
        }
    }

    private String getDisplayValue() {
        return (String)this.getDataTypeConverter().canonicalToDisplayValue(this.originalCanonicalValue);
    }

    private String[] getDisplayValues() {
        ArrayList<String> displayValues = new ArrayList<String>();
        for (Object canonicalValue : this.canonicalValues) {
            displayValues.add((String)this.getDataTypeConverter().canonicalToDisplayValue(canonicalValue));
        }
        return displayValues.toArray(ArrayUtil.STRING_TYPE_ARRAY);
    }
}

