/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable.data;

import java.util.List;
import net.sourceforge.nattable.data.IColumnAccessor;
import net.sourceforge.nattable.data.IRowDataProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListDataProvider<T>
implements IRowDataProvider<T> {
    protected List<T> list;
    protected IColumnAccessor<T> columnAccessor;

    public ListDataProvider(List<T> list, IColumnAccessor<T> columnAccessor) {
        this.list = list;
        this.columnAccessor = columnAccessor;
    }

    @Override
    public int getColumnCount() {
        return this.columnAccessor.getColumnCount();
    }

    @Override
    public int getRowCount() {
        return this.list.size();
    }

    @Override
    public Object getDataValue(int columnIndex, int rowIndex) {
        T rowObj = this.list.get(rowIndex);
        return this.columnAccessor.getDataValue(rowObj, columnIndex);
    }

    @Override
    public void setDataValue(int columnIndex, int rowIndex, Object newValue) {
        T rowObj = this.list.get(rowIndex);
        this.columnAccessor.setDataValue(rowObj, columnIndex, newValue);
    }

    @Override
    public T getRowObject(int rowIndex) {
        return this.list.get(rowIndex);
    }

    @Override
    public int indexOfRowObject(T rowObject) {
        return this.list.indexOf(rowObject);
    }

    public List<T> getList() {
        return this.list;
    }
}

