/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwtorm.schema.java;

import com.google.gwtorm.client.OrmException;
import com.google.gwtorm.client.Relation;
import com.google.gwtorm.client.Schema;
import com.google.gwtorm.client.Sequence;
import com.google.gwtorm.schema.SchemaModel;
import com.google.gwtorm.schema.SequenceModel;
import com.google.gwtorm.schema.java.JavaRelationModel;
import java.lang.reflect.Method;

public class JavaSchemaModel
extends SchemaModel {
    private final Class<?> schema;

    public JavaSchemaModel(Class<?> schemaInterface) throws OrmException {
        this.schema = schemaInterface;
        if (!this.schema.isInterface()) {
            throw new OrmException("Schema " + this.schema.getName() + " must be an interface");
        }
        if (this.schema.getInterfaces().length != 1 || this.schema.getInterfaces()[0] != Schema.class) {
            throw new OrmException("Schema " + this.schema.getName() + " must only extend " + Schema.class.getName());
        }
        for (Method m : this.schema.getDeclaredMethods()) {
            if (m.getAnnotation(Relation.class) != null) {
                this.add(new JavaRelationModel(m));
                continue;
            }
            Sequence seq = m.getAnnotation(Sequence.class);
            if (seq == null) continue;
            this.add(new SequenceModel(m.getName(), seq, m.getReturnType()));
        }
    }

    @Override
    public String getSchemaClassName() {
        return this.schema.getName();
    }
}

