/*
 * Decompiled with CFR 0.152.
 */
package no.hasmac.jsonld.api;

import jakarta.json.JsonArray;
import jakarta.json.JsonStructure;
import java.net.URI;
import no.hasmac.jsonld.JsonLdError;
import no.hasmac.jsonld.JsonLdOptions;
import no.hasmac.jsonld.JsonLdVersion;
import no.hasmac.jsonld.api.CommonApi;
import no.hasmac.jsonld.api.ContextApi;
import no.hasmac.jsonld.api.LoaderApi;
import no.hasmac.jsonld.document.Document;
import no.hasmac.jsonld.document.JsonDocument;
import no.hasmac.jsonld.loader.DocumentLoader;
import no.hasmac.jsonld.processor.ExpansionProcessor;
import no.hasmac.jsonld.uri.UriUtils;

public final class ExpansionApi
implements CommonApi<ExpansionApi>,
LoaderApi<ExpansionApi>,
ContextApi<ExpansionApi> {
    private final URI documentUri;
    private final Document document;
    private JsonLdOptions options;

    public ExpansionApi(URI documentUri) {
        this.document = null;
        this.documentUri = documentUri;
        this.options = new JsonLdOptions();
    }

    public ExpansionApi(Document document) {
        this.document = document;
        this.documentUri = null;
        this.options = new JsonLdOptions();
    }

    @Override
    public ExpansionApi options(JsonLdOptions options) {
        if (options == null) {
            throw new IllegalArgumentException("Parameter 'options' is null.");
        }
        this.options = options;
        return this;
    }

    @Override
    public ExpansionApi context(URI contextUri) {
        this.options.setExpandContext(contextUri);
        return this;
    }

    @Override
    public ExpansionApi context(String contextLocation) {
        URI contextUri = null;
        if (contextLocation != null && (contextUri = UriUtils.create(contextLocation)) == null) {
            throw new IllegalArgumentException("Context location must be valid URI or null but is [" + contextLocation + ".");
        }
        return this.context(contextUri);
    }

    @Override
    public ExpansionApi context(JsonStructure context) {
        this.options.setExpandContext(context != null ? JsonDocument.of(context) : null);
        return this;
    }

    @Override
    public ExpansionApi context(Document context) {
        this.options.setExpandContext(context);
        return this;
    }

    @Override
    public ExpansionApi mode(JsonLdVersion processingMode) {
        this.options.setProcessingMode(processingMode);
        return this;
    }

    @Override
    public ExpansionApi base(URI baseUri) {
        this.options.setBase(baseUri);
        return this;
    }

    @Override
    public ExpansionApi loader(DocumentLoader loader) {
        this.options.setDocumentLoader(loader);
        return this;
    }

    @Override
    public ExpansionApi ordered(boolean enable) {
        this.options.setOrdered(enable);
        return this;
    }

    public JsonArray get() throws JsonLdError {
        if (this.document != null) {
            return ExpansionProcessor.expand(this.document, this.options, false);
        }
        if (this.documentUri != null) {
            return ExpansionProcessor.expand(this.documentUri, this.options);
        }
        throw new IllegalStateException();
    }

    public ExpansionApi numericId() {
        this.options.setNumericId(true);
        return this;
    }

    public ExpansionApi rdfStar() {
        this.options.setRdfStar(true);
        return this;
    }
}

