/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xslf.usermodel;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import javax.imageio.ImageIO;
import org.apache.poi.POIXMLException;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.apache.poi.xslf.usermodel.RenderableShape;
import org.apache.poi.xslf.usermodel.XSLFImageRenderer;
import org.apache.poi.xslf.usermodel.XSLFPictureData;
import org.apache.poi.xslf.usermodel.XSLFRenderingHint;
import org.apache.poi.xslf.usermodel.XSLFShape;
import org.apache.poi.xslf.usermodel.XSLFSheet;
import org.apache.poi.xslf.usermodel.XSLFSimpleShape;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.drawingml.x2006.main.CTBlip;
import org.openxmlformats.schemas.drawingml.x2006.main.CTBlipFillProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTNonVisualDrawingProps;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPresetGeometry2D;
import org.openxmlformats.schemas.drawingml.x2006.main.CTShapeProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.STShapeType;
import org.openxmlformats.schemas.presentationml.x2006.main.CTApplicationNonVisualDrawingProps;
import org.openxmlformats.schemas.presentationml.x2006.main.CTPicture;
import org.openxmlformats.schemas.presentationml.x2006.main.CTPictureNonVisual;

public class XSLFPictureShape
extends XSLFSimpleShape {
    private XSLFPictureData _data;

    XSLFPictureShape(CTPicture shape, XSLFSheet sheet) {
        super((XmlObject)shape, sheet);
    }

    static CTPicture prototype(int shapeId, String rel) {
        CTPicture ct = CTPicture.Factory.newInstance();
        CTPictureNonVisual nvSpPr = ct.addNewNvPicPr();
        CTNonVisualDrawingProps cnv = nvSpPr.addNewCNvPr();
        cnv.setName("Picture " + shapeId);
        cnv.setId((long)(shapeId + 1));
        nvSpPr.addNewCNvPicPr().addNewPicLocks().setNoChangeAspect(true);
        nvSpPr.addNewNvPr();
        CTBlipFillProperties blipFill = ct.addNewBlipFill();
        CTBlip blip = blipFill.addNewBlip();
        blip.setEmbed(rel);
        blipFill.addNewStretch().addNewFillRect();
        CTShapeProperties spPr = ct.addNewSpPr();
        CTPresetGeometry2D prst = spPr.addNewPrstGeom();
        prst.setPrst(STShapeType.RECT);
        prst.addNewAvLst();
        return ct;
    }

    public void resize() {
        XSLFPictureData pict = this.getPictureData();
        try {
            BufferedImage img = ImageIO.read(new ByteArrayInputStream(pict.getData()));
            this.setAnchor(new Rectangle2D.Double(0.0, 0.0, img.getWidth(), img.getHeight()));
        }
        catch (Exception e) {
            this.setAnchor(new Rectangle(50, 50, 200, 200));
        }
    }

    public XSLFPictureData getPictureData() {
        if (this._data == null) {
            String blipId = this.getBlipId();
            PackagePart p = this.getSheet().getPackagePart();
            PackageRelationship rel = p.getRelationship(blipId);
            if (rel != null) {
                try {
                    PackagePart imgPart = p.getRelatedPart(rel);
                    this._data = new XSLFPictureData(imgPart, rel);
                }
                catch (Exception e) {
                    throw new POIXMLException(e);
                }
            }
        }
        return this._data;
    }

    private String getBlipId() {
        CTPicture ct = (CTPicture)this.getXmlObject();
        return ct.getBlipFill().getBlip().getEmbed();
    }

    public void drawContent(Graphics2D graphics) {
        XSLFPictureData data = this.getPictureData();
        if (data == null) {
            return;
        }
        XSLFImageRenderer renderer = (XSLFImageRenderer)graphics.getRenderingHint(XSLFRenderingHint.IMAGE_RENDERER);
        if (renderer == null) {
            renderer = new XSLFImageRenderer();
        }
        RenderableShape rShape = new RenderableShape(this);
        Rectangle2D anchor = rShape.getAnchor(graphics);
        renderer.drawImage(graphics, data, anchor);
    }

    void copy(XSLFShape sh) {
        super.copy(sh);
        XSLFPictureShape p = (XSLFPictureShape)sh;
        String blipId = p.getBlipId();
        String relId = this.getSheet().importBlip(blipId, p.getSheet().getPackagePart());
        CTPicture ct = (CTPicture)this.getXmlObject();
        CTBlip blip = ct.getBlipFill().getBlip();
        blip.setEmbed(relId);
        CTApplicationNonVisualDrawingProps nvPr = ct.getNvPicPr().getNvPr();
        if (nvPr.isSetCustDataLst()) {
            nvPr.unsetCustDataLst();
        }
    }
}

