/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jsch.internal.core;

import com.jcraft.jsch.IdentityRepository;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Hashtable;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.jsch.core.AbstractIdentityRepositoryFactory;
import org.eclipse.jsch.core.IJSchService;
import org.eclipse.jsch.internal.core.JSchProvider;
import org.eclipse.jsch.internal.core.PreferenceInitializer;
import org.eclipse.jsch.internal.core.Utils;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;

public class JSchCorePlugin
extends Plugin {
    public static String ID = "org.eclipse.jsch.core";
    public static final int DEFAULT_TIMEOUT = 60;
    private int communicationsTimeout = 60;
    private boolean needToLoadKnownHosts = true;
    private boolean needToLoadKeys = true;
    private JSch jsch;
    private String current_pkeys = "";
    public static final String PT_AUTHENTICATOR = "authenticator";
    public static final String PT_IDENTITYREPOSITORY = "identityrepository";
    private static JSchCorePlugin plugin;
    private ServiceTracker tracker;
    private ServiceRegistration jschService;

    public JSchCorePlugin() {
        plugin = this;
    }

    public static JSchCorePlugin getPlugin() {
        return plugin;
    }

    public static void log(CoreException e) {
        JSchCorePlugin.log(e.getStatus().getSeverity(), e.getMessage(), e);
    }

    public static void log(IStatus status) {
        JSchCorePlugin.getPlugin().getLog().log(status);
    }

    public static void log(int severity, String message, Throwable e) {
        JSchCorePlugin.log((IStatus)new Status(severity, ID, 0, message, e));
    }

    public int getTimeout() {
        return this.communicationsTimeout;
    }

    public void setTimeout(int timeout) {
        this.communicationsTimeout = Math.max(0, timeout);
    }

    public synchronized JSch getJSch() {
        if (this.jsch == null) {
            this.jsch = new JSch();
            this.setIdentityRepository();
        }
        return this.jsch;
    }

    public synchronized void setIdentityRepository() {
        IdentityRepository[] repositories = this.getPluggedInIdentityRepositries();
        String[] selected = Utils.getSelectedSSHAgent().split(",");
        IdentityRepository irepo = null;
        int i = 0;
        while (i < selected.length) {
            int j = 0;
            while (j < repositories.length) {
                IdentityRepository _irepo = repositories[j];
                if (selected[i].equals(_irepo.getName()) && _irepo.getStatus() == 2) {
                    irepo = _irepo;
                    break;
                }
                ++j;
            }
            if (irepo != null) break;
            ++i;
        }
        if (irepo != null) {
            this.jsch.setIdentityRepository(irepo);
        } else {
            this.jsch.setIdentityRepository(null);
        }
    }

    public IdentityRepository[] getPluggedInIdentityRepositries() {
        IExtension[] extensions = Platform.getExtensionRegistry().getExtensionPoint(ID, PT_IDENTITYREPOSITORY).getExtensions();
        if (extensions.length == 0) {
            return new IdentityRepository[0];
        }
        ArrayList<IdentityRepository> tmp = new ArrayList<IdentityRepository>();
        int i = 0;
        while (i < extensions.length) {
            IExtension extension = extensions[i];
            IConfigurationElement[] configs = extension.getConfigurationElements();
            if (configs.length == 0) {
                JSchCorePlugin.log(4, NLS.bind((String)"IdentityRepository {0} is missing required fields", (Object[])new Object[]{extension.getUniqueIdentifier()}), null);
            } else {
                try {
                    IConfigurationElement config = configs[0];
                    AbstractIdentityRepositoryFactory iirf = (AbstractIdentityRepositoryFactory)config.createExecutableExtension("run");
                    tmp.add(iirf.create());
                }
                catch (CoreException ex) {
                    JSchCorePlugin.log(4, NLS.bind((String)"Unable to instantiate identity repository {0}", (Object[])new Object[]{extension.getUniqueIdentifier()}), ex);
                }
            }
            ++i;
        }
        IdentityRepository[] repositories = new IdentityRepository[tmp.size()];
        int i2 = 0;
        while (i2 < tmp.size()) {
            repositories[i2] = (IdentityRepository)tmp.get(i2);
            ++i2;
        }
        return repositories;
    }

    public void loadKnownHosts() {
        block3: {
            Preferences preferences = JSchCorePlugin.getPlugin().getPluginPreferences();
            String ssh_home = preferences.getString("SSH2HOME");
            if (ssh_home.length() == 0) {
                ssh_home = PreferenceInitializer.SSH_HOME_DEFAULT;
            }
            File file = new File(ssh_home, "known_hosts");
            try {
                this.getJSch().setKnownHosts(file.getPath());
            }
            catch (JSchException e) {
                if (e.getCause() instanceof FileNotFoundException) break block3;
                JSchCorePlugin.log(4, NLS.bind((String)"An error occurred while loading the know hosts file {0}", (Object)file.getAbsolutePath()), e);
            }
        }
        this.needToLoadKnownHosts = false;
    }

    public boolean isNeedToLoadKnownHosts() {
        return this.needToLoadKnownHosts;
    }

    public void setNeedToLoadKnownHosts(boolean needToLoadKnownHosts) {
        this.needToLoadKnownHosts = needToLoadKnownHosts;
    }

    public boolean isNeedToLoadKeys() {
        return this.needToLoadKeys;
    }

    public void setNeedToLoadKeys(boolean needToLoadKeys) {
        this.needToLoadKeys = needToLoadKeys;
    }

    public void loadPrivateKeys() {
        this.current_pkeys = Utils.loadPrivateKeys(this.getJSch(), this.current_pkeys);
        this.setNeedToLoadKeys(false);
    }

    public IProxyService getProxyService() {
        return (IProxyService)this.tracker.getService();
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.tracker = new ServiceTracker(this.getBundle().getBundleContext(), IProxyService.class.getName(), null);
        this.tracker.open();
        this.jschService = this.getBundle().getBundleContext().registerService(IJSchService.class.getName(), (Object)JSchProvider.getInstance(), new Hashtable());
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        this.tracker.close();
        this.jschService.unregister();
    }
}

