/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.internal.installer;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.ui.EclipseUIPlugin;
import org.eclipse.emf.common.ui.ImageURIRegistry;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.equinox.internal.security.storage.CallbacksProvider;
import org.eclipse.equinox.internal.security.storage.PasswordProviderModuleExt;
import org.eclipse.equinox.internal.security.storage.PasswordProviderSelector;
import org.eclipse.equinox.internal.security.ui.storage.DefaultPasswordProvider;
import org.eclipse.equinox.security.storage.provider.PasswordProvider;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.oomph.setup.internal.core.util.ECFURIHandlerImpl;
import org.eclipse.oomph.setup.internal.core.util.SetupCoreUtil;
import org.eclipse.oomph.setup.internal.installer.InstallerUIPrompt;
import org.eclipse.oomph.setup.internal.installer.UICallbackProvider;
import org.eclipse.oomph.setup.ui.SetupUIPlugin;
import org.eclipse.oomph.setup.util.SetupUtil;
import org.eclipse.oomph.ui.OomphUIPlugin;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.oomph.util.IORuntimeException;
import org.eclipse.oomph.util.PropertiesUtil;
import org.eclipse.oomph.util.ReflectUtil;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.testing.ITestHarness;
import org.eclipse.ui.testing.TestableObject;
import org.osgi.framework.BundleContext;

public final class SetupInstallerPlugin
extends OomphUIPlugin {
    public static final SetupInstallerPlugin INSTANCE = new SetupInstallerPlugin();
    public static final String FONT_OPEN_SANS = "font-open-sans";
    public static final String FONT_LABEL_DEFAULT = "font-open-sans.label-default";
    private static Implementation plugin;

    public SetupInstallerPlugin() {
        super(new ResourceLocator[]{SetupUIPlugin.INSTANCE});
    }

    public ResourceLocator getPluginResourceLocator() {
        return plugin;
    }

    public static void runTests() {
        try {
            ITestHarness testHarness;
            TestableObject testableObject = PlatformUI.getTestableObject();
            if (testableObject != null && (testHarness = testableObject.getTestHarness()) != null) {
                new Job("Test Harness"){

                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            testHarness.runTests();
                        }
                        catch (Exception ex) {
                            INSTANCE.log(ex, 2);
                        }
                        return Status.OK_STATUS;
                    }
                }.schedule();
            }
        }
        catch (Throwable ex) {
            INSTANCE.log(ex);
        }
    }

    public static class Implementation
    extends EclipseUIPlugin {
        public Implementation() {
            plugin = this;
        }

        public void start(BundleContext context) throws Exception {
            super.start(context);
            if (!PropertiesUtil.isProperty((String)"headless.startup") && !SetupUtil.SETUP_ARCHIVER_APPLICATION) {
                Display.setAppName((String)PropertiesUtil.getProductName());
            }
            this.adjustDefaultPasswordProvider();
            if (PropertiesUtil.isProperty((String)"oomph.setup.user.home.redirect")) {
                System.setProperty("user.home", new File(PropertiesUtil.getUserHome()).getCanonicalPath());
            }
            if (!PropertiesUtil.isProperty((String)"headless.startup") && !SetupUtil.SETUP_ARCHIVER_APPLICATION) {
                UIUtil.syncExec((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        this.initializeFonts();
                    }
                });
                File temporaryIconsFolder = new File(System.getProperty("java.io.tmpdir"), String.valueOf(System.currentTimeMillis()) + ".oomph.icons");
                temporaryIconsFolder.mkdir();
                temporaryIconsFolder.deleteOnExit();
                ReflectUtil.setValue((String)"imageDirectory", (Object)ImageURIRegistry.INSTANCE, (Object)temporaryIconsFolder);
                try {
                    Field field = ReflectUtil.getField(EMFPlugin.class, (String)"IS_RESOURCES_BUNDLE_AVAILABLE");
                    ReflectUtil.setValue((Field)field, null, (Object)false, (boolean)true);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            ReflectUtil.setValue((String)"callback", (Object)CallbacksProvider.getDefault(), (Object)new UICallbackProvider());
            try {
                CommonPlugin.loadClass((String)"org.eclipse.core.net", (String)"org.eclipse.core.net.proxy.IProxyService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            Authenticator.setDefault(new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    URI uri = URI.createURI((String)(String.valueOf(this.getRequestingScheme()) + "://" + this.getRequestingHost()));
                    ECFURIHandlerImpl.AuthorizationHandler.Authorization authorization = SetupCoreUtil.AUTHORIZATION_HANDLER.authorize(uri);
                    if (!authorization.isAuthorized()) {
                        authorization = SetupCoreUtil.AUTHORIZATION_HANDLER.reauthorize(uri, authorization);
                    }
                    return authorization.isAuthorized() ? new PasswordAuthentication(authorization.getUser(), authorization.getPassword().toCharArray()) : null;
                }
            });
        }

        private void adjustDefaultPasswordProvider() {
            PasswordProviderSelector passwordProviderSelector = PasswordProviderSelector.getInstance();
            try {
                PasswordProvider passwordProvider;
                PasswordProviderModuleExt defaultProvider = passwordProviderSelector.findStorageModule("org.eclipse.equinox.security.ui.DefaultPasswordProvider");
                if (defaultProvider != null && DefaultPasswordProvider.class.equals((passwordProvider = (PasswordProvider)ReflectUtil.getValue((String)"providerModule", (Object)defaultProvider)).getClass())) {
                    InstallerUIPrompt installerUIPrompt = new InstallerUIPrompt();
                    ReflectUtil.setValue((String)"providerModule", (Object)defaultProvider, (Object)((Object)installerUIPrompt));
                }
            }
            catch (Exception ex) {
                INSTANCE.log(ex);
            }
        }

        private void initializeFonts() {
            FontData[] fontData = JFaceResources.getDefaultFont().getFontData();
            int height = fontData == null || fontData.length == 0 ? 9 : (int)fontData[0].height;
            this.loadFont("/fonts/OpenSans-Regular.ttf");
            JFaceResources.getFontRegistry().put(SetupInstallerPlugin.FONT_LABEL_DEFAULT, new FontData[]{new FontData("Open Sans", height, 1)});
        }

        private boolean loadFont(String path) {
            try {
                URL url = new URL("platform:/plugin/" + INSTANCE.getSymbolicName() + path);
                URL fileURL = FileLocator.toFileURL((URL)url);
                String filePath = fileURL.getPath();
                File file = new File(filePath);
                return UIUtil.getDisplay().loadFont(file.toString());
            }
            catch (IOException ex) {
                throw new IORuntimeException((Throwable)ex);
            }
        }
    }
}

