/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.commands;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractParameterValueConverter;
import org.eclipse.core.commands.Category;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.CommandManager;
import org.eclipse.core.commands.IParameter;
import org.eclipse.core.commands.ParameterType;
import org.eclipse.core.commands.State;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.core.commands.internal.HandlerServiceImpl;
import org.eclipse.e4.ui.internal.workbench.Parameter;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.commands.CommandService;
import org.eclipse.ui.internal.commands.CommandStateProxy;
import org.eclipse.ui.internal.commands.ParameterValueConverterProxy;
import org.eclipse.ui.internal.services.RegistryPersistence;
import org.eclipse.ui.internal.util.PrefUtil;

public final class CommandPersistence
extends RegistryPersistence {
    private static final int INDEX_CATEGORY_DEFINITIONS = 0;
    private static final int INDEX_COMMAND_DEFINITIONS = 1;
    private static final int INDEX_PARAMETER_TYPE_DEFINITIONS = 2;
    private final CommandManager commandManager;

    private static void readCategoriesFromRegistry(IConfigurationElement[] configurationElements, int configurationElementCount, CommandManager commandManager) {
        Category undefCat = commandManager.getCategory(null);
        if (!undefCat.isDefined()) {
            commandManager.defineUncategorizedCategory(WorkbenchMessages.CommandService_AutogeneratedCategoryName, WorkbenchMessages.CommandService_AutogeneratedCategoryDescription);
        }
        ArrayList<IStatus> warningsToLog = new ArrayList<IStatus>(1);
        int i = 0;
        while (i < configurationElementCount) {
            String name;
            IConfigurationElement configurationElement = configurationElements[i];
            String categoryId = CommandPersistence.readRequired(configurationElement, "id", warningsToLog, "Categories need an id");
            if (categoryId != null && (name = CommandPersistence.readRequired(configurationElement, "name", warningsToLog, "Categories need a name", categoryId)) != null) {
                String description = CommandPersistence.readOptional(configurationElement, "description");
                Category category = commandManager.getCategory(categoryId);
                if (!category.isDefined()) {
                    category.define(name, description);
                }
            }
            ++i;
        }
        CommandPersistence.logWarnings(warningsToLog, "Warnings while parsing the commands from the 'org.eclipse.ui.commands' and 'org.eclipse.ui.actionDefinitions' extension points.");
    }

    private static void readCommandsFromRegistry(IConfigurationElement[] configurationElements, int configurationElementCount, CommandManager commandManager) {
        ArrayList<IStatus> warningsToLog = new ArrayList<IStatus>(1);
        int i = 0;
        while (i < configurationElementCount) {
            String name;
            IConfigurationElement configurationElement = configurationElements[i];
            String commandId = CommandPersistence.readRequired(configurationElement, "id", warningsToLog, "Commands need an id");
            if (commandId != null && (name = CommandPersistence.readRequired(configurationElement, "name", warningsToLog, "Commands need a name")) != null) {
                String description = CommandPersistence.readOptional(configurationElement, "description");
                String categoryId = configurationElement.getAttribute("categoryId");
                if ((categoryId == null || categoryId.length() == 0) && (categoryId = configurationElement.getAttribute("category")) != null && categoryId.length() == 0) {
                    categoryId = null;
                }
                Parameter[] parameters = CommandPersistence.readParameters(configurationElement, warningsToLog, commandManager);
                String returnTypeId = CommandPersistence.readOptional(configurationElement, "returnTypeId");
                String helpContextId = CommandPersistence.readOptional(configurationElement, "helpContextId");
                Command command = commandManager.getCommand(commandId);
                Category category = commandManager.getCategory(categoryId);
                if (!category.isDefined()) {
                    CommandPersistence.addWarning(warningsToLog, "Commands should really have a category", configurationElement, commandId, "categoryId", categoryId);
                }
                ParameterType returnType = returnTypeId == null ? null : commandManager.getParameterType(returnTypeId);
                if (parameters != null && parameters.length > 0) {
                    command.undefine();
                }
                if (!command.isDefined()) {
                    command.define(name, description, category, (IParameter[])parameters, returnType, helpContextId);
                    command.setHandler(HandlerServiceImpl.getHandler((String)commandId));
                }
                CommandPersistence.readState(configurationElement, warningsToLog, command);
            }
            ++i;
        }
        CommandPersistence.logWarnings(warningsToLog, "Warnings while parsing the commands from the 'org.eclipse.ui.commands' and 'org.eclipse.ui.actionDefinitions' extension points.");
    }

    private static Parameter[] readParameters(IConfigurationElement configurationElement, List<IStatus> warningsToLog, CommandManager commandManager) {
        IConfigurationElement[] parameterElements = configurationElement.getChildren("commandParameter");
        if (parameterElements == null || parameterElements.length == 0) {
            return null;
        }
        int insertionIndex = 0;
        Parameter[] parameters = new Parameter[parameterElements.length];
        IConfigurationElement[] iConfigurationElementArray = parameterElements;
        int n = parameterElements.length;
        int n2 = 0;
        while (n2 < n) {
            String name;
            IConfigurationElement parameterElement = iConfigurationElementArray[n2];
            String id = CommandPersistence.readRequired(parameterElement, "id", warningsToLog, "Parameters need an id");
            if (id != null && (name = CommandPersistence.readRequired(parameterElement, "name", warningsToLog, "Parameters need a name")) != null) {
                String typeId = CommandPersistence.readOptional(parameterElement, "typeId");
                boolean optional = CommandPersistence.readBoolean(parameterElement, "optional", true);
                ParameterType type = typeId == null ? null : commandManager.getParameterType(typeId);
                Parameter parameter = new Parameter(id, name, parameterElement, type, optional);
                parameters[insertionIndex++] = parameter;
            }
            ++n2;
        }
        if (insertionIndex != parameters.length) {
            Parameter[] compactedParameters = new Parameter[insertionIndex];
            System.arraycopy(parameters, 0, compactedParameters, 0, insertionIndex);
            parameters = compactedParameters;
        }
        return parameters;
    }

    private static void readParameterTypesFromRegistry(IConfigurationElement[] configurationElements, int configurationElementCount, CommandManager commandManager) {
        ArrayList<IStatus> warningsToLog = new ArrayList<IStatus>(1);
        int i = 0;
        while (i < configurationElementCount) {
            IConfigurationElement configurationElement = configurationElements[i];
            String parameterTypeId = CommandPersistence.readRequired(configurationElement, "id", warningsToLog, "Command parameter types need an id");
            if (parameterTypeId != null) {
                String type = CommandPersistence.readOptional(configurationElement, "type");
                String converter = CommandPersistence.readOptional(configurationElement, "converter");
                ParameterValueConverterProxy parameterValueConverter = converter == null ? null : new ParameterValueConverterProxy(configurationElement);
                ParameterType parameterType = commandManager.getParameterType(parameterTypeId);
                if (!parameterType.isDefined()) {
                    parameterType.define(type, (AbstractParameterValueConverter)parameterValueConverter);
                }
            }
            ++i;
        }
        CommandPersistence.logWarnings(warningsToLog, "Warnings while parsing the commandParameterTypes from the 'org.eclipse.ui.commands' extension point.");
    }

    private static void readState(IConfigurationElement configurationElement, List<IStatus> warningsToLog, Command command) {
        IConfigurationElement[] stateElements = configurationElement.getChildren("state");
        if (stateElements == null || stateElements.length == 0) {
            return;
        }
        IConfigurationElement[] iConfigurationElementArray = stateElements;
        int n = stateElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement stateElement = iConfigurationElementArray[n2];
            String id = CommandPersistence.readRequired(stateElement, "id", warningsToLog, "State needs an id");
            if (id != null && CommandPersistence.checkClass(stateElement, warningsToLog, "State must have an associated class", id) && command.getState(id) == null) {
                CommandStateProxy state = new CommandStateProxy(stateElement, "class", PrefUtil.getInternalPreferenceStore(), CommandService.createPreferenceKey(command, id));
                command.addState(id, (State)state);
            }
            ++n2;
        }
    }

    public CommandPersistence(CommandManager commandService) {
        if (commandService == null) {
            throw new NullPointerException("The command service cannot be null");
        }
        this.commandManager = commandService;
    }

    @Override
    protected boolean isChangeImportant(IRegistryChangeEvent event) {
        return false;
    }

    public boolean commandsNeedUpdating(IRegistryChangeEvent event) {
        IExtensionDelta[] actionDefinitionDeltas;
        IExtensionDelta[] commandDeltas = event.getExtensionDeltas("org.eclipse.ui", "commands");
        return commandDeltas.length != 0 || (actionDefinitionDeltas = event.getExtensionDeltas("org.eclipse.ui", "actionDefinitions")).length != 0;
    }

    @Override
    protected void read() {
        super.read();
        this.reRead();
    }

    public void reRead() {
        IConfigurationElement[] actionDefinitionsExtensionPoint;
        IConfigurationElement[] commandsExtensionPoint;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        int commandDefinitionCount = 0;
        int categoryDefinitionCount = 0;
        int parameterTypeDefinitionCount = 0;
        IConfigurationElement[][] indexedConfigurationElements = new IConfigurationElement[3][];
        IConfigurationElement[] iConfigurationElementArray = commandsExtensionPoint = registry.getConfigurationElementsFor("org.eclipse.ui.commands");
        int n = commandsExtensionPoint.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configurationElement = iConfigurationElementArray[n2];
            String name = configurationElement.getName();
            if ("command".equals(name)) {
                CommandPersistence.addElementToIndexedArray(configurationElement, indexedConfigurationElements, 1, commandDefinitionCount++);
            } else if ("category".equals(name)) {
                CommandPersistence.addElementToIndexedArray(configurationElement, indexedConfigurationElements, 0, categoryDefinitionCount++);
            } else if ("commandParameterType".equals(name)) {
                CommandPersistence.addElementToIndexedArray(configurationElement, indexedConfigurationElements, 2, parameterTypeDefinitionCount++);
            }
            ++n2;
        }
        IConfigurationElement[] iConfigurationElementArray2 = actionDefinitionsExtensionPoint = registry.getConfigurationElementsFor("org.eclipse.ui.actionDefinitions");
        int n3 = actionDefinitionsExtensionPoint.length;
        n = 0;
        while (n < n3) {
            IConfigurationElement configurationElement = iConfigurationElementArray2[n];
            String name = configurationElement.getName();
            if ("actionDefinition".equals(name)) {
                CommandPersistence.addElementToIndexedArray(configurationElement, indexedConfigurationElements, 1, commandDefinitionCount++);
            }
            ++n;
        }
        CommandPersistence.readCategoriesFromRegistry(indexedConfigurationElements[0], categoryDefinitionCount, this.commandManager);
        CommandPersistence.readCommandsFromRegistry(indexedConfigurationElements[1], commandDefinitionCount, this.commandManager);
        CommandPersistence.readParameterTypesFromRegistry(indexedConfigurationElements[2], parameterTypeDefinitionCount, this.commandManager);
    }
}

