/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.core;

import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SolverStats
implements Serializable {
    private static final long serialVersionUID = 1L;
    public int starts;
    public long decisions;
    public long propagations;
    public long inspects;
    public long conflicts;
    public long learnedliterals;
    public long learnedbinaryclauses;
    public long learnedternaryclauses;
    public long learnedclauses;
    public long ignoredclauses;
    public long rootSimplifications;
    public long reducedliterals;
    public long changedreason;
    public int reduceddb;
    public int shortcuts;
    public long updateLBD;
    public int importedUnits;

    public void reset() {
        this.starts = 0;
        this.decisions = 0L;
        this.propagations = 0L;
        this.inspects = 0L;
        this.shortcuts = 0;
        this.conflicts = 0L;
        this.learnedliterals = 0L;
        this.learnedclauses = 0L;
        this.ignoredclauses = 0L;
        this.learnedbinaryclauses = 0L;
        this.learnedternaryclauses = 0L;
        this.rootSimplifications = 0L;
        this.reducedliterals = 0L;
        this.changedreason = 0L;
        this.reduceddb = 0;
        this.updateLBD = 0L;
        this.importedUnits = 0;
    }

    public void printStat(PrintWriter out, String prefix) {
        out.println(String.valueOf(prefix) + "starts\t\t: " + this.starts);
        out.println(String.valueOf(prefix) + "conflicts\t\t: " + this.conflicts);
        out.println(String.valueOf(prefix) + "decisions\t\t: " + this.decisions);
        out.println(String.valueOf(prefix) + "propagations\t\t: " + this.propagations);
        out.println(String.valueOf(prefix) + "inspects\t\t: " + this.inspects);
        out.println(String.valueOf(prefix) + "shortcuts\t\t: " + this.shortcuts);
        out.println(String.valueOf(prefix) + "learnt literals\t: " + this.learnedliterals);
        out.println(String.valueOf(prefix) + "learnt binary clauses\t: " + this.learnedbinaryclauses);
        out.println(String.valueOf(prefix) + "learnt ternary clauses\t: " + this.learnedternaryclauses);
        out.println(String.valueOf(prefix) + "learnt constraints\t: " + this.learnedclauses);
        out.println(String.valueOf(prefix) + "ignored constraints\t: " + this.ignoredclauses);
        out.println(String.valueOf(prefix) + "root simplifications\t: " + this.rootSimplifications);
        out.println(String.valueOf(prefix) + "removed literals (reason simplification)\t: " + this.reducedliterals);
        out.println(String.valueOf(prefix) + "reason swapping (by a shorter reason)\t: " + this.changedreason);
        out.println(String.valueOf(prefix) + "Calls to reduceDB\t: " + this.reduceddb);
        out.println(String.valueOf(prefix) + "Number of update (reduction) of LBD\t: " + this.updateLBD);
        out.println(String.valueOf(prefix) + "Imported unit clauses\t: " + this.importedUnits);
    }

    public Map<String, Number> toMap() {
        HashMap<String, Number> map = new HashMap<String, Number>();
        Field[] fieldArray = this.getClass().getFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field f = fieldArray[n2];
            try {
                map.put(f.getName(), (Number)f.get(this));
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {}
            ++n2;
        }
        return map;
    }
}

