/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import org.eclipse.collections.api.DoubleIterable;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.LazyDoubleIterable;
import org.eclipse.collections.api.LazyIntIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.ImmutableBag;
import org.eclipse.collections.api.bag.primitive.ImmutableDoubleBag;
import org.eclipse.collections.api.bag.primitive.MutableDoubleBag;
import org.eclipse.collections.api.block.function.primitive.DoubleToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectDoubleToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.DoublePredicate;
import org.eclipse.collections.api.block.predicate.primitive.IntDoublePredicate;
import org.eclipse.collections.api.block.procedure.primitive.DoubleProcedure;
import org.eclipse.collections.api.block.procedure.primitive.IntDoubleProcedure;
import org.eclipse.collections.api.block.procedure.primitive.IntProcedure;
import org.eclipse.collections.api.collection.primitive.MutableDoubleCollection;
import org.eclipse.collections.api.iterator.DoubleIterator;
import org.eclipse.collections.api.list.primitive.MutableDoubleList;
import org.eclipse.collections.api.map.primitive.ImmutableDoubleIntMap;
import org.eclipse.collections.api.map.primitive.ImmutableIntDoubleMap;
import org.eclipse.collections.api.map.primitive.IntDoubleMap;
import org.eclipse.collections.api.set.primitive.MutableDoubleSet;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.api.tuple.primitive.IntDoublePair;
import org.eclipse.collections.impl.bag.mutable.primitive.DoubleHashBag;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableDoubleCollection;
import org.eclipse.collections.impl.factory.Bags;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.primitive.DoubleBags;
import org.eclipse.collections.impl.factory.primitive.DoubleIntMaps;
import org.eclipse.collections.impl.factory.primitive.IntDoubleMaps;
import org.eclipse.collections.impl.factory.primitive.IntLists;
import org.eclipse.collections.impl.iterator.UnmodifiableDoubleIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyDoubleIterableAdapter;
import org.eclipse.collections.impl.list.mutable.primitive.DoubleArrayList;
import org.eclipse.collections.impl.map.mutable.primitive.IntDoubleHashMap;
import org.eclipse.collections.impl.set.mutable.primitive.DoubleHashSet;
import org.eclipse.collections.impl.set.mutable.primitive.IntHashSet;
import org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableIntSet;
import org.eclipse.collections.impl.tuple.primitive.PrimitiveTuples;

final class ImmutableIntDoubleSingletonMap
implements ImmutableIntDoubleMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final double EMPTY_VALUE = 0.0;
    private final int key1;
    private final double value1;

    ImmutableIntDoubleSingletonMap(int key1, double value1) {
        this.key1 = key1;
        this.value1 = value1;
    }

    public double get(int key) {
        return this.getIfAbsent(key, 0.0);
    }

    public double getIfAbsent(int key, double ifAbsent) {
        return this.key1 == key ? this.value1 : ifAbsent;
    }

    public double getOrThrow(int key) {
        if (this.key1 == key) {
            return this.value1;
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    public boolean containsKey(int key) {
        return this.key1 == key;
    }

    public boolean containsValue(double value) {
        return Double.compare(this.value1, value) == 0;
    }

    public void forEachValue(DoubleProcedure procedure) {
        procedure.value(this.value1);
    }

    public void forEachKey(IntProcedure procedure) {
        procedure.value(this.key1);
    }

    public void forEachKeyValue(IntDoubleProcedure procedure) {
        procedure.value(this.key1, this.value1);
    }

    public boolean allSatisfyKeyValue(IntDoublePredicate predicate) {
        return predicate.accept(this.key1, this.value1);
    }

    public LazyIntIterable keysView() {
        return IntLists.immutable.of(this.key1).asLazy();
    }

    public RichIterable<IntDoublePair> keyValuesView() {
        return Lists.immutable.of((Object)PrimitiveTuples.pair(this.key1, this.value1)).asLazy();
    }

    public ImmutableDoubleIntMap flipUniqueValues() {
        return DoubleIntMaps.immutable.with(this.value1, this.key1);
    }

    public ImmutableIntDoubleMap select(IntDoublePredicate predicate) {
        return predicate.accept(this.key1, this.value1) ? IntDoubleHashMap.newWithKeysValues(this.key1, this.value1).toImmutable() : new IntDoubleHashMap().toImmutable();
    }

    public ImmutableIntDoubleMap reject(IntDoublePredicate predicate) {
        return predicate.accept(this.key1, this.value1) ? new IntDoubleHashMap().toImmutable() : IntDoubleHashMap.newWithKeysValues(this.key1, this.value1).toImmutable();
    }

    public <T> T injectInto(T injectedValue, ObjectDoubleToObjectFunction<? super T, ? extends T> function) {
        return (T)function.valueOf(injectedValue, this.value1);
    }

    public RichIterable<DoubleIterable> chunk(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        return Lists.mutable.with((Object[])new DoubleIterable[]{DoubleBags.immutable.with(this.value1)});
    }

    public ImmutableIntDoubleMap toImmutable() {
        return this;
    }

    public DoubleIterator doubleIterator() {
        return new UnmodifiableDoubleIterator((DoubleIterator)IntDoubleHashMap.newWithKeysValues(this.key1, this.value1).doubleIterator());
    }

    public void each(DoubleProcedure procedure) {
        procedure.value(this.value1);
    }

    public int count(DoublePredicate predicate) {
        return predicate.accept(this.value1) ? 1 : 0;
    }

    public double sum() {
        return this.value1;
    }

    public double min() {
        return this.value1;
    }

    public double max() {
        return this.value1;
    }

    public double maxIfEmpty(double defaultValue) {
        return this.value1;
    }

    public double minIfEmpty(double defaultValue) {
        return this.value1;
    }

    public double average() {
        return this.value1;
    }

    public double median() {
        return this.value1;
    }

    public double[] toSortedArray() {
        return new double[]{this.value1};
    }

    public MutableDoubleList toSortedList() {
        return DoubleArrayList.newListWith(this.value1);
    }

    public boolean anySatisfy(DoublePredicate predicate) {
        return predicate.accept(this.value1);
    }

    public boolean allSatisfy(DoublePredicate predicate) {
        return predicate.accept(this.value1);
    }

    public boolean noneSatisfy(DoublePredicate predicate) {
        return !predicate.accept(this.value1);
    }

    public ImmutableDoubleBag select(DoublePredicate predicate) {
        return predicate.accept(this.value1) ? DoubleHashBag.newBagWith(this.value1).toImmutable() : DoubleBags.immutable.empty();
    }

    public ImmutableDoubleBag reject(DoublePredicate predicate) {
        return predicate.accept(this.value1) ? DoubleBags.immutable.empty() : DoubleHashBag.newBagWith(this.value1).toImmutable();
    }

    public <V> ImmutableBag<V> collect(DoubleToObjectFunction<? extends V> function) {
        return Bags.immutable.of(function.valueOf(this.value1));
    }

    public double detectIfNone(DoublePredicate predicate, double ifNone) {
        return predicate.accept(this.value1) ? this.value1 : ifNone;
    }

    public double[] toArray() {
        return new double[]{this.value1};
    }

    public double[] toArray(double[] target) {
        if (target.length < 1) {
            target = new double[]{this.value1};
        } else {
            target[0] = this.value1;
        }
        return target;
    }

    public boolean contains(double value) {
        return Double.compare(this.value1, value) == 0;
    }

    public boolean containsAll(double ... source) {
        for (double value : source) {
            if (Double.compare(this.value1, value) == 0) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(DoubleIterable source) {
        DoubleIterator iterator = source.doubleIterator();
        while (iterator.hasNext()) {
            if (Double.compare(this.value1, iterator.next()) == 0) continue;
            return false;
        }
        return true;
    }

    public MutableDoubleList toList() {
        return DoubleArrayList.newListWith(this.value1);
    }

    public MutableDoubleSet toSet() {
        return DoubleHashSet.newSetWith(this.value1);
    }

    public MutableDoubleBag toBag() {
        return DoubleHashBag.newBagWith(this.value1);
    }

    public LazyDoubleIterable asLazy() {
        return new LazyDoubleIterableAdapter((DoubleIterable)this);
    }

    public ImmutableIntDoubleMap newWithKeyValue(int key, double value) {
        return IntDoubleMaps.immutable.withAll((IntDoubleMap)IntDoubleHashMap.newWithKeysValues(this.key1, this.value1, key, value));
    }

    public ImmutableIntDoubleMap newWithoutKey(int key) {
        return this.key1 == key ? IntDoubleMaps.immutable.with() : this;
    }

    public ImmutableIntDoubleMap newWithoutAllKeys(IntIterable keys) {
        return keys.contains(this.key1) ? IntDoubleMaps.immutable.with() : this;
    }

    public int size() {
        return 1;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean notEmpty() {
        return true;
    }

    public MutableIntSet keySet() {
        return UnmodifiableIntSet.of(IntHashSet.newSetWith(this.key1));
    }

    public MutableDoubleCollection values() {
        return UnmodifiableDoubleCollection.of((MutableDoubleCollection)DoubleArrayList.newListWith(this.value1));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof IntDoubleMap)) {
            return false;
        }
        IntDoubleMap map = (IntDoubleMap)obj;
        if (map.size() != 1) {
            return false;
        }
        return map.containsKey(this.key1) && Double.compare(this.value1, map.getOrThrow(this.key1)) == 0;
    }

    public int hashCode() {
        return this.key1 ^ (int)(Double.doubleToLongBits(this.value1) ^ Double.doubleToLongBits(this.value1) >>> 32);
    }

    public String toString() {
        return "{" + this.key1 + "=" + this.value1 + "}";
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(String.valueOf(this.value1));
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

