/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.data.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.nebula.widgets.nattable.command.AbstractContextFreeCommand;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;

public class RowInsertCommand<T>
extends AbstractContextFreeCommand {
    private final int rowIndex;
    private final List<T> objects;

    @SafeVarargs
    public RowInsertCommand(ILayer layer, int rowPosition, T ... objects) {
        this.rowIndex = layer.getRowIndexByPosition(rowPosition);
        this.objects = Arrays.asList(objects);
    }

    public RowInsertCommand(ILayer layer, int rowPosition, List<T> objects) {
        this.rowIndex = layer.getRowIndexByPosition(rowPosition);
        this.objects = objects;
    }

    public RowInsertCommand(int rowIndex, T object) {
        this.rowIndex = rowIndex;
        this.objects = new ArrayList<T>(1);
        this.objects.add(object);
    }

    public RowInsertCommand(int rowIndex, List<T> objects) {
        this.rowIndex = rowIndex;
        this.objects = objects;
    }

    public RowInsertCommand(T object) {
        this.rowIndex = -1;
        this.objects = new ArrayList<T>(1);
        this.objects.add(object);
    }

    public RowInsertCommand(List<T> objects) {
        this.rowIndex = -1;
        this.objects = objects;
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public List<T> getObjects() {
        return this.objects;
    }
}

