/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.trace;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.builder.trace.AbstractTrace;
import org.eclipse.xtext.builder.trace.IStorageAwareTraceContribution;
import org.eclipse.xtext.ui.shared.contribution.ISharedStateContributionRegistry;
import org.eclipse.xtext.util.Pair;

public class StorageAwareTrace
extends AbstractTrace {
    private IStorage localStorage;
    private String projectName;
    private ImmutableList<? extends IStorageAwareTraceContribution> contributions = ImmutableList.of();

    @Inject
    private void initializeContributions(ISharedStateContributionRegistry registry) {
        this.contributions = registry.getContributedInstances(IStorageAwareTraceContribution.class);
    }

    public IStorage getLocalStorage() {
        return this.localStorage;
    }

    @Override
    public URI getLocalURI() {
        IStorage localStorage = this.getLocalStorage();
        return this.getURIForStorage(localStorage);
    }

    @Override
    public IProject getLocalProject() {
        return this.findProject(this.projectName);
    }

    @Override
    protected URI resolvePath(URI path) {
        IProject project;
        if (!path.isRelative()) {
            return path;
        }
        int i = 0;
        int size = this.contributions.size();
        while (i < size) {
            URI result = ((IStorageAwareTraceContribution)this.contributions.get(i)).tryResolvePath(this.localStorage, path);
            if (result != null) {
                return result;
            }
            ++i;
        }
        if (this.localStorage instanceof IFile && (project = ((IFile)this.localStorage).getProject()) != null) {
            return this.resolvePath(project, path);
        }
        return path;
    }

    protected URI resolvePath(IProject project, URI path) {
        String decodedPath = URI.decode((String)path.toString());
        IResource candidate = project.findMember(decodedPath);
        if (candidate != null && candidate.exists()) {
            return URI.createPlatformResourceURI((String)(project.getFullPath() + "/" + decodedPath), (boolean)true);
        }
        return path;
    }

    protected void setLocalStorage(IStorage derivedResource) {
        this.localStorage = derivedResource;
        if (derivedResource instanceof IResource) {
            this.projectName = ((IResource)derivedResource).getProject().getName();
        }
    }

    @Override
    protected IStorage findStorage(URI uri, IProject project) {
        URI resolvePath = this.resolvePath(uri);
        Iterable allStorages = this.getStorage2uriMapper().getStorages(resolvePath);
        for (Pair storage : allStorages) {
            if (!project.equals(storage.getSecond())) continue;
            return (IStorage)storage.getFirst();
        }
        return null;
    }

    @Override
    protected InputStream getContents(URI uri, IProject project) throws CoreException {
        IStorage storage = this.findStorage(uri, project);
        if (storage == null) {
            return null;
        }
        return storage.getContents();
    }
}

