/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.editor;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.xtend.ide.editor.TypedRegionMerger;
import org.eclipse.xtext.ui.editor.toggleComments.ToggleSLCommentAction;

public class RichStringAwareToggleCommentAction
extends ToggleSLCommentAction {
    private static Logger log = Logger.getLogger(RichStringAwareToggleCommentAction.class);
    private TypedRegionMerger merger;

    public RichStringAwareToggleCommentAction(ResourceBundle bundle, String prefix, ITextEditor editor) {
        super(bundle, prefix, editor);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean isSelectionCommented(ISelection selection) {
        if (!(selection instanceof ITextSelection)) {
            return false;
        }
        ITextSelection textSelection = (ITextSelection)selection;
        if (textSelection.getStartLine() < 0 || textSelection.getEndLine() < 0) {
            return false;
        }
        IDocument document = this.getTextEditor().getDocumentProvider().getDocument((Object)this.getTextEditor().getEditorInput());
        try {
            IRegion block = this.getTextBlockFromSelection(textSelection, document);
            ITypedRegion[] regions = TextUtilities.computePartitioning((IDocument)document, (String)this.getDocumentPartitioning(), (int)block.getOffset(), (int)block.getLength(), (boolean)false);
            regions = this.merger.merge(regions);
            int[] lines = new int[regions.length * 2];
            int i = 0;
            int j = 0;
            while (i < regions.length) {
                lines[j] = this.getFirstCompleteLineOfRegion((IRegion)regions[i], document);
                int length = regions[i].getLength();
                int offset = regions[i].getOffset() + length;
                if (length > 0) {
                    --offset;
                }
                lines[j + 1] = lines[j] == -1 ? -1 : document.getLineOfOffset(offset);
                ++i;
                j += 2;
            }
            i = 0;
            j = 0;
            while (i < regions.length) {
                String[] prefixes = (String[])this.getPrefixesMap().get(regions[i].getType());
                if (prefixes != null && prefixes.length > 0 && lines[j] >= 0 && lines[j + 1] >= 0 && !this.isBlockCommented(lines[j], lines[j + 1], prefixes, document)) {
                    return false;
                }
                ++i;
                j += 2;
            }
            return true;
        }
        catch (BadLocationException x) {
            log.error((Object)x.getMessage(), (Throwable)x);
            return false;
        }
    }

    @Singleton
    public static class Factory
    extends ToggleSLCommentAction.Factory {
        @Inject
        private TypedRegionMerger merger;

        public ToggleSLCommentAction create(ResourceBundle bundle, String prefix, ITextEditor editor) {
            RichStringAwareToggleCommentAction result = new RichStringAwareToggleCommentAction(bundle, prefix, editor);
            result.merger = this.merger;
            return result;
        }
    }
}

