/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.resource;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend.lib.macro.file.FileLocations;
import org.eclipse.xtend.lib.macro.file.Path;
import org.eclipse.xtext.resource.persistence.ResourceStorageFacade;
import org.eclipse.xtext.resource.persistence.ResourceStorageLoadable;
import org.eclipse.xtext.resource.persistence.ResourceStorageWritable;
import org.eclipse.xtext.resource.persistence.StorageAwareResource;
import org.eclipse.xtext.xbase.file.AbstractFileSystemSupport;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.resource.BatchLinkableResourceStorageLoadable;
import org.eclipse.xtext.xbase.resource.BatchLinkableResourceStorageWritable;

public class BatchLinkableResourceStorageFacade
extends ResourceStorageFacade {
    @Inject
    private AbstractFileSystemSupport fileSystemSupport;
    @Inject
    @Extension
    private FileLocations fileLocations;

    public ResourceStorageLoadable createResourceStorageLoadable(InputStream in) {
        boolean _isStoreNodeModel = this.isStoreNodeModel();
        return new BatchLinkableResourceStorageLoadable(in, _isStoreNodeModel);
    }

    public ResourceStorageWritable createResourceStorageWritable(OutputStream out) {
        boolean _isStoreNodeModel = this.isStoreNodeModel();
        return new BatchLinkableResourceStorageWritable(out, _isStoreNodeModel);
    }

    protected URI getSourceContainerURI(StorageAwareResource resource) {
        boolean _notEquals;
        Path path = this.fileSystemSupport.getPath((Resource)resource);
        Path sourceFolder = this.fileLocations.getSourceFolder(path);
        boolean bl = _notEquals = !Objects.equal((Object)sourceFolder, null);
        if (_notEquals) {
            URI _uRI = resource.getURI();
            Path _relativize = sourceFolder.relativize(path);
            List _segments = _relativize.getSegments();
            int _size = _segments.size();
            URI _trimSegments = _uRI.trimSegments(_size);
            return _trimSegments.appendSegment("");
        }
        return super.getSourceContainerURI(resource);
    }
}

