/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.launching;

import com.google.inject.Inject;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.util.jdt.IJavaElementFinder;
import org.eclipse.xtext.generator.IDerivedResourceMarkers;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.parsetree.reconstr.impl.NodeIterator;
import org.eclipse.xtext.resource.FileExtensionProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.eclipse.xtext.xbase.jvmmodel.IJvmModelAssociations;

public class JavaElementDelegate
implements IAdaptable {
    private static final Logger log = Logger.getLogger(JavaElementDelegate.class);
    private IEditorPart editor;
    private IResource resource;
    @Inject
    private IDerivedResourceMarkers derivedResourceMarkers;
    @Inject
    private FileExtensionProvider fileExtensionProvider;
    @Inject
    private IJvmModelAssociations associations;
    @Inject
    private IJavaElementFinder elementFinder;
    @Inject
    private IWorkbench workbench;

    public void initializeWith(IEditorPart editorInput) {
        this.editor = editorInput;
    }

    public void initializeWith(IFileEditorInput editorInput) {
        this.resource = editorInput.getFile();
        IWorkbenchWindow activeWorkbenchWindow = this.workbench.getActiveWorkbenchWindow();
        if (activeWorkbenchWindow != null) {
            IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
            this.editor = activePage != null ? activePage.findEditor((IEditorInput)editorInput) : null;
        }
    }

    public void initializeWith(IResource resource) {
        this.resource = resource;
    }

    public Object getAdapter(Class adapter) {
        if (IJavaElement.class.equals((Object)adapter)) {
            IJavaElement javaMethod;
            if (this.editor != null && (javaMethod = this.getJavaElementForXtextEditor(this.editor)) != null) {
                return javaMethod;
            }
            if (this.resource != null && this.fileExtensionProvider.isValid(this.resource.getFileExtension())) {
                return this.getJavaElementForResource(this.resource);
            }
        }
        return null;
    }

    protected IJavaElement findJavaElement(XtextResource resource, int offset) {
        IParseResult parseResult = resource.getParseResult();
        if (parseResult == null) {
            return null;
        }
        ICompositeNode root = parseResult.getRootNode();
        ILeafNode node = NodeModelUtils.findLeafNodeAtOffset((INode)root, (int)offset);
        if (node == null) {
            return null;
        }
        INode previousSementic = null;
        INode nextSemantic = null;
        NodeIterator backwards = new NodeIterator((INode)node);
        while (backwards.hasPrevious()) {
            INode n = backwards.previous();
            if (!(n instanceof ILeafNode) || ((ILeafNode)n).isHidden()) continue;
            previousSementic = n;
            break;
        }
        NodeIterator forward = new NodeIterator((INode)node);
        while (forward.hasNext()) {
            INode n = forward.next();
            if (!(n instanceof ILeafNode) || ((ILeafNode)n).isHidden()) continue;
            nextSemantic = n;
            break;
        }
        if (previousSementic == null || nextSemantic == null) {
            return null;
        }
        EObject prevObj = NodeModelUtils.findActualSemanticObjectFor((INode)previousSementic);
        EObject nextObj = NodeModelUtils.findActualSemanticObjectFor(nextSemantic);
        if (prevObj == null || nextObj == null) {
            return null;
        }
        EObject element = this.findCommonContainer(prevObj, nextObj);
        JvmIdentifiableElement jvmElement = this.findAssociatedJvmElement(element);
        if (jvmElement == null) {
            return null;
        }
        IJavaElement javaElement = this.elementFinder.findElementFor(jvmElement);
        return javaElement;
    }

    protected JvmIdentifiableElement findAssociatedJvmElement(EObject element) {
        if (element == null) {
            return null;
        }
        Set elements = this.associations.getJvmElements(element);
        if (elements.isEmpty()) {
            return this.findAssociatedJvmElement(element.eContainer());
        }
        EObject next = (EObject)elements.iterator().next();
        if (next instanceof JvmIdentifiableElement) {
            return (JvmIdentifiableElement)next;
        }
        return (JvmIdentifiableElement)EcoreUtil2.getContainerOfType((EObject)next, JvmIdentifiableElement.class);
    }

    protected EObject findCommonContainer(EObject prevObj, EObject nextObj) {
        if (prevObj == null) {
            return nextObj;
        }
        if (nextObj == null) {
            return null;
        }
        if (prevObj == nextObj) {
            return prevObj;
        }
        if (EcoreUtil.isAncestor((EObject)prevObj, (EObject)nextObj)) {
            return prevObj;
        }
        if (EcoreUtil.isAncestor((EObject)nextObj, (EObject)prevObj)) {
            return nextObj;
        }
        return this.findCommonContainer(prevObj.eContainer(), nextObj.eContainer());
    }

    protected IJavaElement getJavaElementForXtextEditor(IEditorPart editor) {
        if (!(editor instanceof XtextEditor)) {
            return null;
        }
        IJavaProject jp = null;
        if (editor.getEditorInput() instanceof IFileEditorInput) {
            IFile file = ((IFileEditorInput)editor.getEditorInput()).getFile();
            if (!this.fileExtensionProvider.isValid(file.getFileExtension())) {
                return null;
            }
            jp = JavaCore.create((IProject)file.getProject());
            if (jp == null || !jp.exists() || !jp.isOpen()) {
                return null;
            }
        } else {
            return null;
        }
        XtextEditor xtextEditor = (XtextEditor)editor;
        ISelection selection = xtextEditor.getSelectionProvider().getSelection();
        if (!(selection instanceof ITextSelection)) {
            return null;
        }
        final int offset = ((ITextSelection)selection).getOffset();
        IJavaElement func = (IJavaElement)xtextEditor.getDocument().readOnly((IUnitOfWork)new IUnitOfWork<IJavaElement, XtextResource>(){

            public IJavaElement exec(XtextResource state) throws Exception {
                return JavaElementDelegate.this.findJavaElement(state, offset);
            }
        });
        return func;
    }

    protected IJavaElement getJavaElementForEditor(IEditorPart editor) {
        IFile file;
        if (editor.getEditorInput() instanceof IFileEditorInput && this.fileExtensionProvider.isValid((file = ((IFileEditorInput)editor.getEditorInput()).getFile()).getFileExtension())) {
            return this.getJavaElementForResource((IResource)file);
        }
        return null;
    }

    protected IJavaElement getJavaElementForResource(IResource resource) {
        block3: {
            try {
                String getSourcePath = URI.createPlatformResourceURI((String)resource.getFullPath().toString(), (boolean)true).toString();
                List resources = this.derivedResourceMarkers.findDerivedResources((IContainer)resource.getProject(), getSourcePath);
                for (IFile file : resources) {
                    if (!this.containsElementsSearchedFor(file)) continue;
                    return JavaCore.create((IFile)file);
                }
            }
            catch (CoreException e) {
                if (!log.isDebugEnabled()) break block3;
                log.debug((Object)e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    protected boolean containsElementsSearchedFor(IFile file) {
        return false;
    }
}

