/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.junit;

import com.google.common.collect.Lists;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.TestCase;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtend.XtendFacade;
import org.eclipse.xtend.expression.ExecutionContext;
import org.eclipse.xtend.expression.ExecutionContextImpl;
import org.eclipse.xtend.type.impl.java.JavaBeansMetaModel;
import org.eclipse.xtend.typesystem.MetaModel;
import org.eclipse.xtext.IGrammarAccess;
import org.eclipse.xtext.ISetup;
import org.eclipse.xtext.conversion.IValueConverterService;
import org.eclipse.xtext.diagnostics.ExceptionDiagnostic;
import org.eclipse.xtext.formatting.INodeModelFormatter;
import org.eclipse.xtext.junit.GlobalRegistries;
import org.eclipse.xtext.junit.serializer.SerializerTester;
import org.eclipse.xtext.junit.util.ResourceLoadHelper;
import org.eclipse.xtext.linking.ILinkingService;
import org.eclipse.xtext.linking.lazy.LazyLinkingResource;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.parser.IAstFactory;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.parser.IParser;
import org.eclipse.xtext.parsetree.reconstr.IParseTreeConstructor;
import org.eclipse.xtext.resource.IResourceFactory;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.serializer.ISerializer;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.StringInputStream;

@Deprecated
public abstract class AbstractXtextTests
extends TestCase
implements ResourceLoadHelper {
    private Injector injector;
    private boolean canCreateInjector;
    private List<String> testGrammarPaths;
    private GlobalRegistries.GlobalStateMemento globalStateMemento;
    public static final int EXPECT_ERRORS = -2;
    public static final int UNKNOWN_EXPECTATION = Integer.MIN_VALUE;
    private static JavaBeansMetaModel mm;

    static {
        GlobalRegistries.initializeDefaults();
        mm = new JavaBeansMetaModel();
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.canCreateInjector = true;
        this.globalStateMemento = GlobalRegistries.makeCopyOfGlobalState();
    }

    protected void tearDown() throws Exception {
        this.injector = null;
        this.globalStateMemento.restoreGlobalState();
        super.tearDown();
    }

    public String serialize(EObject obj) {
        return this.getSerializer().serialize(obj);
    }

    protected void with(Module ... modules) throws Exception {
        AbstractXtextTests.assertTrue((String)"super.setUp() has to be called before any injector is instantiated", (boolean)this.canCreateInjector);
        this.setInjector(Guice.createInjector((Module[])modules));
    }

    protected void with(Class<? extends ISetup> setupClazz) throws Exception {
        AbstractXtextTests.assertTrue((String)"super.setUp() has to be called before any injector is instantiated", (boolean)this.canCreateInjector);
        ISetup instance = setupClazz.newInstance();
        this.setInjector(instance.createInjectorAndDoEMFRegistration());
    }

    public void with(ISetup setup) throws Exception {
        AbstractXtextTests.assertTrue((String)"super.setUp() has to be called before any injector is instantiated", (boolean)this.canCreateInjector);
        this.setInjector(setup.createInjectorAndDoEMFRegistration());
    }

    protected void setInjector(Injector injector) {
        this.injector = injector;
    }

    public final Injector getInjector() {
        if (this.injector == null) {
            throw new IllegalStateException("No injector set. Did you forget to call something like 'with(new YourStadaloneSetup())'?");
        }
        return this.injector;
    }

    public <T> T get(Class<T> clazz) {
        if (this.injector == null) {
            this.injector = Guice.createInjector((Module[])new Module[0]);
        }
        return (T)this.injector.getInstance(clazz);
    }

    public <T> T get(Key<T> key) {
        if (this.injector == null) {
            this.injector = Guice.createInjector((Module[])new Module[0]);
        }
        return (T)this.injector.getInstance(key);
    }

    public void injectMembers(Object object) {
        if (this.injector == null) {
            this.injector = Guice.createInjector((Module[])new Module[0]);
        }
        this.injector.injectMembers(object);
    }

    protected IParser getParser() {
        return (IParser)this.getInjector().getInstance(IParser.class);
    }

    protected ILinkingService getLinkingService() {
        return (ILinkingService)this.getInjector().getInstance(ILinkingService.class);
    }

    protected IAstFactory getASTFactory() {
        return (IAstFactory)this.getInjector().getInstance(IAstFactory.class);
    }

    protected IGrammarAccess getGrammarAccess() {
        return (IGrammarAccess)this.getInjector().getInstance(IGrammarAccess.class);
    }

    protected IParseTreeConstructor getParseTreeConstructor() {
        return (IParseTreeConstructor)this.getInjector().getInstance(IParseTreeConstructor.class);
    }

    protected IResourceFactory getResourceFactory() {
        return (IResourceFactory)this.getInjector().getInstance(IResourceFactory.class);
    }

    protected IValueConverterService getValueConverterService() {
        return (IValueConverterService)this.getInjector().getInstance(IValueConverterService.class);
    }

    protected ISerializer getSerializer() {
        return (ISerializer)this.getInjector().getInstance(ISerializer.class);
    }

    protected INodeModelFormatter getNodeModelFormatter() {
        return (INodeModelFormatter)this.getInjector().getInstance(INodeModelFormatter.class);
    }

    protected IScopeProvider getScopeProvider() {
        return (IScopeProvider)this.getInjector().getInstance(IScopeProvider.class);
    }

    protected InputStream getAsStream(String model) {
        return new StringInputStream(model);
    }

    public EObject getModel(String model) throws Exception {
        return this.getModel(this.getAsStream(model));
    }

    public final EObject getModel(InputStream model) throws Exception {
        XtextResource resource = this.getResource(model);
        return this.getModel(resource);
    }

    public final EObject getModelAndExpect(String model, int errors) throws Exception {
        return this.getModelAndExpect(this.getAsStream(model), errors);
    }

    public final EObject getModelAndExpect(InputStream model, int errors) throws Exception {
        XtextResource resource = this.getResourceAndExpect(model, errors);
        return this.getModel(resource);
    }

    protected EObject getModel(XtextResource resource) {
        return resource.getParseResult().getRootASTElement();
    }

    protected final XtextResource getResourceFromString(String model) throws Exception {
        return this.getResource(this.getAsStream(model));
    }

    protected final XtextResource getResourceFromStringAndExpect(String model, int errors) throws Exception {
        return this.getResourceAndExpect(this.getAsStream(model), errors);
    }

    public final XtextResource getResource(InputStream in) throws Exception {
        return this.getResource(in, URI.createURI((String)("mytestmodel." + this.getCurrentFileExtension())));
    }

    protected String getCurrentFileExtension() {
        String instance = (String)this.getInjector().getInstance(Key.get(String.class, (Annotation)Names.named((String)"file.extensions")));
        if (instance.indexOf(44) == -1) {
            return instance;
        }
        return instance.split(",")[0];
    }

    @Override
    public final XtextResource getResourceFor(InputStream stream) {
        try {
            return this.getResourceAndExpect(stream, Integer.MIN_VALUE);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public final XtextResource getResourceAndExpect(InputStream in, int errors) throws Exception {
        return this.getResourceAndExpect(in, URI.createURI((String)("mytestmodel." + this.getCurrentFileExtension())), errors);
    }

    public final XtextResource getResource(InputStream in, URI uri) throws Exception {
        return this.getResourceAndExpect(in, uri, 0);
    }

    public final XtextResource getResource(String contents, String uri) throws Exception {
        return this.getResource(this.getAsStream(contents), URI.createURI((String)uri));
    }

    public final XtextResource getResourceAndExpect(InputStream in, URI uri, int expectedErrors) throws Exception {
        XtextResource resource = this.doGetResource(in, uri);
        if (expectedErrors != Integer.MIN_VALUE) {
            if (expectedErrors == -2) {
                AbstractXtextTests.assertFalse((String)resource.getErrors().toString(), (boolean)resource.getErrors().isEmpty());
            } else {
                AbstractXtextTests.assertEquals((String)resource.getErrors().toString(), (int)expectedErrors, (int)resource.getErrors().size());
            }
        }
        for (Resource.Diagnostic d : resource.getErrors()) {
            if (!(d instanceof ExceptionDiagnostic)) continue;
            AbstractXtextTests.fail((String)d.getMessage());
        }
        for (Resource.Diagnostic d : resource.getWarnings()) {
            System.out.println("Resource Warning: " + d);
        }
        if (expectedErrors == 0 && resource.getContents().size() > 0 && this.shouldTestSerializer(resource)) {
            SerializerTester tester = this.get(SerializerTester.class);
            EObject obj = (EObject)resource.getContents().get(0);
            tester.assertSerializeWithNodeModel(obj);
            tester.assertSerializeWithoutNodeModel(obj);
        }
        return resource;
    }

    protected boolean shouldTestSerializer(XtextResource resource) {
        return !"org.eclipse.xtext.Xtext".equals(resource.getLanguageName()) && !"org.eclipse.xtext.ui.tests.refactoring.RefactoringTestLanguage".equals(resource.getLanguageName());
    }

    protected XtextResource doGetResource(InputStream in, URI uri) throws Exception {
        XtextResourceSet rs = this.get(XtextResourceSet.class);
        rs.setClasspathURIContext(this.getClass());
        XtextResource resource = (XtextResource)this.getResourceFactory().createResource(uri);
        rs.getResources().add((Object)resource);
        resource.load(in, null);
        if (resource instanceof LazyLinkingResource) {
            ((LazyLinkingResource)resource).resolveLazyCrossReferences(CancelIndicator.NullImpl);
        } else {
            EcoreUtil.resolveAll((Resource)resource);
        }
        return resource;
    }

    protected final ICompositeNode getRootNode(InputStream model) throws Exception {
        XtextResource resource = this.getResource(model);
        return this.getRootNode(resource);
    }

    protected final ICompositeNode getRootNodeAndExpect(InputStream model, int errors) throws Exception {
        XtextResource resource = this.getResourceAndExpect(model, errors);
        return this.getRootNode(resource);
    }

    protected final ICompositeNode getRootNode(XtextResource resource) {
        return resource.getParseResult().getRootNode();
    }

    protected final IParseResult getParseResult(String model) throws Exception {
        return this.getResourceFromString(model).getParseResult();
    }

    protected final IParseResult getParseResultAndExpect(String model, int errors) throws Exception {
        return this.getResourceFromStringAndExpect(model, errors).getParseResult();
    }

    protected final ICompositeNode getRootNode(String model) throws Exception {
        return this.getRootNode(this.getAsStream(model));
    }

    protected final ICompositeNode getRootNodeAndExpect(String model, int errors) throws Exception {
        return this.getRootNodeAndExpect(this.getAsStream(model), errors);
    }

    protected void assertWithXtend(String left, String right, Object _this) {
        this.assertWithXtend(String.valueOf(left) + " != " + right, left, right, _this);
    }

    protected Object invokeWithXtend(String expression, Object _this) {
        XtendFacade f = this.getXtendFacade();
        f = f.cloneWithExtensions(this.getImportDeclarations() + "invoke(Object this) : " + expression + ";");
        return f.call("invoke", new Object[]{_this});
    }

    protected String[] importedExtensions() {
        return new String[0];
    }

    protected void assertWithXtend(String message, String left, String right, Object _this) {
        XtendFacade f = this.getXtendFacade();
        StringBuffer code = this.getImportDeclarations();
        code.append("__compare(Object this) : __left(this) == __right(this);__left(Object this) : " + left + "; __right(Object this) :" + right + ";");
        f = f.cloneWithExtensions(code.toString());
        Boolean result = (Boolean)f.call("__compare", new Object[]{_this});
        if (!result.booleanValue()) {
            Object leftResult = f.call("__left", new Object[]{_this});
            Object rightResult = f.call("__right", new Object[]{_this});
            AbstractXtextTests.fail((String)(String.valueOf(message) + " was : " + leftResult + "(" + (leftResult != null ? leftResult.getClass().getSimpleName() : "") + ") != " + rightResult + "(" + (leftResult != null ? leftResult.getClass().getSimpleName() : "") + ")"));
        }
    }

    private StringBuffer getImportDeclarations() {
        StringBuffer code = new StringBuffer();
        String[] stringArray = this.importedExtensions();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String _import = stringArray[n2];
            code.append("extension ").append(_import).append(";");
            ++n2;
        }
        return code;
    }

    protected XtendFacade getXtendFacade() {
        ExecutionContextImpl ctx = new ExecutionContextImpl();
        ctx.registerMetaModel((MetaModel)mm);
        return XtendFacade.create((ExecutionContext)ctx, (String[])new String[0]);
    }

    protected String readFileIntoString(String filePath) throws IOException {
        block9: {
            ClassLoader classLoader = this.getClass().getClassLoader();
            URL url = classLoader.getResource(filePath);
            if (url == null) {
                AbstractXtextTests.fail((String)("Could not read resource: '" + filePath + "'. Is your file system case sensitive?"));
            } else {
                if (!new File(url.getPath()).getCanonicalPath().endsWith(filePath)) {
                    throw new RuntimeException(String.valueOf(filePath) + ":\n" + "The file does not exist exactly as it was named.\n" + "The test is likely to cause trouble on the build server.\n" + "Is your filesystem case insensitive? Please verify the spelling.");
                }
                InputStream resourceAsStream = classLoader.getResourceAsStream(filePath);
                try {
                    String model;
                    if (resourceAsStream == null) {
                        AbstractXtextTests.fail((String)("Could not read resource: '" + filePath + "'. Is your file system case sensitive?"));
                        break block9;
                    }
                    byte[] buffer = new byte[2048];
                    int bytesRead = 0;
                    StringBuffer b = new StringBuffer();
                    do {
                        if ((bytesRead = resourceAsStream.read(buffer)) == -1) continue;
                        b.append(new String(buffer, 0, bytesRead));
                    } while (bytesRead != -1);
                    String string = model = b.toString();
                    return string;
                }
                finally {
                    if (resourceAsStream != null) {
                        resourceAsStream.close();
                    }
                }
            }
        }
        throw new IllegalStateException("May not happen, but helps to suppress false positives in eclipse' control flow analysis.");
    }

    protected List<String> getAllTestGrammarPaths(boolean firstOnly) {
        if (this.testGrammarPaths == null) {
            this.testGrammarPaths = Lists.newArrayList();
            try {
                String mweFile = this.readFileIntoString("org/eclipse/xtext/GenerateAllTestLanguages.mwe2");
                Pattern pattern = Pattern.compile("uri\\s*=\\s*\"([^\"]*)\"");
                Matcher matcher = pattern.matcher(mweFile);
                while (matcher.find()) {
                    String grammarURI = matcher.group(1);
                    String grammarPath = grammarURI.replaceFirst("classpath:/", "");
                    this.testGrammarPaths.add(grammarPath);
                    if (!firstOnly) {
                        continue;
                    }
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.testGrammarPaths;
    }

    public static final class Keys {
        private static final TypeLiteral<Provider<XtextResourceSet>> resourceSetLiteral = new TypeLiteral<Provider<XtextResourceSet>>(){};
        public static final Key<Provider<XtextResourceSet>> RESOURCE_SET_KEY = Key.get(resourceSetLiteral);
    }
}

