/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.preferences;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.xtext.builder.EclipseOutputConfigurationProvider;
import org.eclipse.xtext.builder.internal.Activator;
import org.eclipse.xtext.builder.preferences.BuilderPreferenceAccess;
import org.eclipse.xtext.builder.preferences.Messages;
import org.eclipse.xtext.generator.OutputConfiguration;
import org.eclipse.xtext.ui.editor.preferences.IPreferenceStoreAccess;
import org.eclipse.xtext.ui.preferences.OptionsConfigurationBlock;
import org.eclipse.xtext.ui.preferences.ScrolledPageContent;

public class BuilderConfigurationBlock
extends OptionsConfigurationBlock {
    protected static final String[] BOOLEAN_VALUES = new String[]{"true", "false"};
    protected static final int INDENT_AMOUNT = 32;
    public static final String SETTINGS_SECTION_NAME = "BuilderConfigurationBlock";
    public static final String PROPERTY_PREFIX = "BuilderConfiguration";
    @Inject
    private EclipseOutputConfigurationProvider configurationProvider;
    @Inject
    private IPreferenceStoreAccess preferenceStoreAccess;
    private final List<TableItem> tableItems = Lists.newArrayList();

    public void setProject(IProject project) {
        super.setProject(project);
        this.setPreferenceStore(this.preferenceStoreAccess.getWritablePreferenceStore((Object)project));
    }

    protected Control doCreateContents(Composite parent) {
        PixelConverter pixelConverter = new PixelConverter((Control)parent);
        this.setShell(parent.getShell());
        Composite mainComp = new Composite(parent, 0);
        mainComp.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        mainComp.setLayout((Layout)layout);
        Composite othersComposite = this.createBuildPathTabContent(mainComp);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = pixelConverter.convertHeightInCharsToPixels(20);
        othersComposite.setLayoutData((Object)gridData);
        this.validateSettings(null, null, null);
        return mainComp;
    }

    private Composite createBuildPathTabContent(Composite parent) {
        int columns = 3;
        ScrolledPageContent pageContent = new ScrolledPageContent(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = columns;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        Composite composite = pageContent.getBody();
        composite.setLayout((Layout)layout);
        String label = Messages.BuilderConfigurationBlock_GeneralSection_Label;
        ExpandableComposite excomposite = this.createStyleSection(composite, label, columns);
        Composite othersComposite = new Composite((Composite)excomposite, 0);
        excomposite.setClient((Control)othersComposite);
        othersComposite.setLayout((Layout)new GridLayout(columns, false));
        this.createGeneralSectionItems(othersComposite);
        Set<OutputConfiguration> outputConfigurations = this.configurationProvider.getOutputConfigurations(this.getProject());
        for (OutputConfiguration outputConfiguration : outputConfigurations) {
            label = outputConfiguration.getDescription();
            excomposite = this.createStyleSection(composite, label, columns);
            othersComposite = new Composite((Composite)excomposite, 0);
            excomposite.setClient((Control)othersComposite);
            othersComposite.setLayout((Layout)new GridLayout(columns, false));
            this.createOutputSectionItems(othersComposite, outputConfiguration);
        }
        this.registerKey(this.getIsProjectSpecificPropertyKey(this.getPropertyPrefix()));
        IDialogSettings section = Activator.getDefault().getDialogSettings().getSection(SETTINGS_SECTION_NAME);
        this.restoreSectionExpansionStates(section);
        return pageContent;
    }

    protected void createGeneralSectionItems(Composite composite) {
        this.addCheckBox(composite, Messages.BuilderPreferencePage_GenerateAuto, "autobuilding", BOOLEAN_VALUES, 0);
    }

    protected void createOutputSectionItems(Composite composite, OutputConfiguration outputConfiguration) {
        Text defaultDirectoryField = this.addTextField(composite, Messages.OutputConfigurationPage_Directory, BuilderPreferenceAccess.getKey(outputConfiguration, "directory"), 0, 0);
        this.addCheckBox(composite, Messages.OutputConfigurationPage_CreateDirectory, BuilderPreferenceAccess.getKey(outputConfiguration, "createDirectory"), BOOLEAN_VALUES, 0);
        this.addCheckBox(composite, Messages.OutputConfigurationPage_OverrideExistingResources, BuilderPreferenceAccess.getKey(outputConfiguration, "override"), BOOLEAN_VALUES, 0);
        this.addCheckBox(composite, Messages.OutputConfigurationPage_CreatesDerivedResources, BuilderPreferenceAccess.getKey(outputConfiguration, "derived"), BOOLEAN_VALUES, 0);
        this.addCheckBox(composite, Messages.OutputConfigurationPage_CleanupDerivedResources, BuilderPreferenceAccess.getKey(outputConfiguration, "cleanupDerived"), BOOLEAN_VALUES, 0);
        this.addCheckBox(composite, Messages.OutputConfigurationPage_CleanDirectory, BuilderPreferenceAccess.getKey(outputConfiguration, "cleanDirectory"), BOOLEAN_VALUES, 0);
        final Button installAsPrimaryButton = this.addCheckBox(composite, Messages.BuilderConfigurationBlock_InstallDslAsPrimarySource, BuilderPreferenceAccess.getKey(outputConfiguration, "installDslAsPrimarySource"), BOOLEAN_VALUES, 0);
        final Button hideLocalButton = this.addCheckBox(composite, Messages.BuilderConfigurationBlock_hideSyntheticLocalVariables, BuilderPreferenceAccess.getKey(outputConfiguration, "hideLocalSyntheticVariables"), BOOLEAN_VALUES, 0);
        hideLocalButton.setEnabled(installAsPrimaryButton.getSelection());
        installAsPrimaryButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                hideLocalButton.setEnabled(installAsPrimaryButton.getSelection());
            }
        });
        GridData hideLocalButtonData = new GridData();
        hideLocalButtonData.horizontalIndent = 32;
        hideLocalButton.setLayoutData((Object)hideLocalButtonData);
        this.addCheckBox(composite, Messages.OutputConfigurationPage_KeepLocalHistory, BuilderPreferenceAccess.getKey(outputConfiguration, "keepLocalHistory"), BOOLEAN_VALUES, 0);
        if (this.getProject() != null && !outputConfiguration.getSourceFolders().isEmpty()) {
            final Button outputPerSourceButton = this.addCheckBox(composite, Messages.OutputConfigurationPage_UseOutputPerSourceFolder, BuilderPreferenceAccess.getKey(outputConfiguration, "userOutputPerSourceFolder"), BOOLEAN_VALUES, 0);
            final Table table = this.createOutputFolderTable(composite, outputConfiguration, defaultDirectoryField);
            table.setVisible(outputPerSourceButton.getSelection());
            outputPerSourceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    table.setVisible(outputPerSourceButton.getSelection());
                }
            });
        }
    }

    private Table createOutputFolderTable(Composite othersComposite, OutputConfiguration outputConfiguration, Text defaultDirectoryField) {
        final Table table = new Table(othersComposite, 67584);
        new TableColumn(table, 0).setText(Messages.OutputConfigurationPage_IgnoreSourceFolder);
        new TableColumn(table, 0).setText(Messages.OutputConfigurationPage_SourceFolder);
        new TableColumn(table, 0).setText(Messages.OutputConfigurationPage_OutputDirectory);
        table.getColumn(0).setWidth(75);
        table.getColumn(1).setWidth(200);
        table.getColumn(2).setWidth(200);
        table.pack();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        for (String source : outputConfiguration.getSourceFolders()) {
            String outputForSourceFolderKey = BuilderPreferenceAccess.getOutputForSourceFolderKey(outputConfiguration, source);
            this.registerKey(outputForSourceFolderKey);
            String ignoreSourceFolderKey = BuilderPreferenceAccess.getIgnoreSourceFolderKey(outputConfiguration, source);
            this.registerKey(ignoreSourceFolderKey);
            String defaultOutputDirectoryKey = BuilderPreferenceAccess.getKey(outputConfiguration, "directory");
            final TableItemData data = new TableItemData(source, outputForSourceFolderKey, ignoreSourceFolderKey, defaultOutputDirectoryKey);
            final TableItem item = new TableItem(table, 0, 0);
            this.tableItems.add(item);
            item.setData((Object)data);
            this.refreshItem(item);
            final TableEditor directoryEditor = new TableEditor(table);
            directoryEditor.grabHorizontal = true;
            table.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (e.item != item) {
                        return;
                    }
                    if (BuilderConfigurationBlock.this.isIgnored(item)) {
                        return;
                    }
                    Control oldDirectoryField = directoryEditor.getEditor();
                    if (oldDirectoryField != null) {
                        oldDirectoryField.dispose();
                    }
                    final Text directoryField = new Text((Composite)table, 0);
                    directoryField.setText(BuilderConfigurationBlock.this.getOutputDirectory(item));
                    directoryField.addModifyListener(new ModifyListener(){

                        public void modifyText(ModifyEvent me) {
                            BuilderConfigurationBlock.this.setValue(data.getOutputDirectoryKey(), directoryField.getText());
                            BuilderConfigurationBlock.this.refreshItem(item);
                        }
                    });
                    directoryField.addFocusListener((FocusListener)new FocusAdapter(){

                        public void focusLost(FocusEvent e) {
                            directoryField.dispose();
                        }
                    });
                    directoryField.selectAll();
                    directoryField.setFocus();
                    directoryEditor.setEditor((Control)directoryField, item, 2);
                }
            });
            TableEditor ignoreEditor = new TableEditor(table);
            ignoreEditor.grabHorizontal = true;
            final Button ignoreField = new Button((Composite)table, 32);
            ignoreEditor.setEditor((Control)ignoreField, item, 0);
            ignoreField.setSelection(this.isIgnored(item));
            ignoreField.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    BuilderConfigurationBlock.this.setValue(data.getIgnoreKey(), String.valueOf(ignoreField.getSelection()));
                    BuilderConfigurationBlock.this.refreshItem(item);
                }
            });
            defaultDirectoryField.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    BuilderConfigurationBlock.this.refreshItem(item);
                }
            });
        }
        return table;
    }

    private void refreshItem(TableItem item) {
        TableItemData data = (TableItemData)item.getData();
        item.setText(1, data.getSourceFolder());
        String outputDirectory = this.getOutputDirectory(item);
        if ("".equals(outputDirectory)) {
            item.setForeground(2, Display.getCurrent().getSystemColor(15));
            item.setText(2, this.getValue(data.getDefaultOutputDirectoryKey()));
        } else {
            item.setForeground(2, null);
            item.setText(2, outputDirectory);
        }
        if (this.isIgnored(item)) {
            item.setForeground(Display.getCurrent().getSystemColor(15));
        } else {
            item.setForeground(null);
        }
    }

    private String getOutputDirectory(TableItem item) {
        TableItemData data = (TableItemData)item.getData();
        return this.getValue(data.getOutputDirectoryKey());
    }

    private boolean isIgnored(TableItem item) {
        TableItemData data = (TableItemData)item.getData();
        return Boolean.parseBoolean(this.getValue(data.getIgnoreKey()));
    }

    protected void validateSettings(String changedKey, String oldValue, String newValue) {
    }

    protected void updateControls() {
        super.updateControls();
        for (TableItem item : this.tableItems) {
            this.refreshItem(item);
        }
    }

    public void dispose() {
        IDialogSettings settings = Activator.getDefault().getDialogSettings().addNewSection(SETTINGS_SECTION_NAME);
        this.storeSectionExpansionStates(settings);
        super.dispose();
    }

    protected String[] getFullBuildDialogStrings(boolean workspaceSettings) {
        String title = Messages.BuilderConfigurationBlock_SettingsChanged_Title;
        String message = workspaceSettings ? Messages.BuilderConfigurationBlock_SettingsChanged_WorkspaceBuild : Messages.BuilderConfigurationBlock_SettingsChanged_ProjectBuild;
        return new String[]{title, message};
    }

    protected Job getBuildJob(IProject project) {
        OptionsConfigurationBlock.BuildJob buildJob = new OptionsConfigurationBlock.BuildJob(Messages.BuilderConfigurationBlock_BuildJob_Title0, project);
        buildJob.setRule(ResourcesPlugin.getWorkspace().getRuleFactory().buildRule());
        buildJob.setUser(true);
        return buildJob;
    }

    public String getPropertyPrefix() {
        return PROPERTY_PREFIX;
    }

    private static class TableItemData {
        private String sourceFolder;
        private String outputDirectoryKey;
        private String ignoreKey;
        private String defaultOutputDirectoryKey;

        public TableItemData(String sourceFolder, String outputDirectoryKey, String ignoreKey, String defaultOutputDirectoryKey) {
            this.sourceFolder = sourceFolder;
            this.outputDirectoryKey = outputDirectoryKey;
            this.ignoreKey = ignoreKey;
            this.defaultOutputDirectoryKey = defaultOutputDirectoryKey;
        }

        public String getSourceFolder() {
            return this.sourceFolder;
        }

        public String getOutputDirectoryKey() {
            return this.outputDirectoryKey;
        }

        public String getIgnoreKey() {
            return this.ignoreKey;
        }

        public String getDefaultOutputDirectoryKey() {
            return this.defaultOutputDirectoryKey;
        }
    }
}

