/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.util;

import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.jdt.launching.environments.IExecutionEnvironmentsManager;

public class JREContainerProvider {
    public static final String PREFERRED_BREE = "JavaSE-1.6";
    private static IVMInstall defaultVMInstall = null;
    private static boolean defaultVMinitialized = false;

    public static IClasspathEntry getDefaultJREContainerEntry() {
        IPath jreContainerPath = JREContainerProvider.getDefaultJREContainerPath();
        return JavaCore.newContainerEntry((IPath)jreContainerPath);
    }

    public static IPath getDefaultJREContainerPath() {
        if (JREContainerProvider.defaultVMInstall() != null) {
            IExecutionEnvironment[] executionEnvironments;
            IExecutionEnvironmentsManager executionEnvironmentsManager = JavaRuntime.getExecutionEnvironmentsManager();
            IExecutionEnvironment[] iExecutionEnvironmentArray = executionEnvironments = executionEnvironmentsManager.getExecutionEnvironments();
            int n = executionEnvironments.length;
            int n2 = 0;
            while (n2 < n) {
                IExecutionEnvironment executionEnvironment = iExecutionEnvironmentArray[n2];
                if (executionEnvironment.isStrictlyCompatible(JREContainerProvider.defaultVMInstall())) {
                    return JavaRuntime.newJREContainerPath((IExecutionEnvironment)executionEnvironment);
                }
                ++n2;
            }
        }
        return JREContainerProvider.newPreferredContainerPath();
    }

    private static IVMInstall defaultVMInstall() {
        if (!defaultVMinitialized) {
            defaultVMInstall = JavaRuntime.getDefaultVMInstall();
            defaultVMinitialized = true;
        }
        return defaultVMInstall;
    }

    protected static IPath newJRE15ContainerPath() {
        return JavaRuntime.newJREContainerPath((String)"org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType", (String)"J2SE-1.5");
    }

    @Deprecated
    protected static IPath newPrefferedContainerPath() {
        return JREContainerProvider.newPreferredContainerPath();
    }

    protected static IPath newPreferredContainerPath() {
        return JavaRuntime.newJREContainerPath((String)"org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType", (String)PREFERRED_BREE);
    }

    public static IClasspathEntry getJREContainerEntry(IJavaProject javaProject) throws JavaModelException {
        IClasspathEntry[] rawClasspath;
        IClasspathEntry defaultJREContainerEntry = JREContainerProvider.getDefaultJREContainerEntry();
        IClasspathEntry[] iClasspathEntryArray = rawClasspath = javaProject.getRawClasspath();
        int n = rawClasspath.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry classpathEntry = iClasspathEntryArray[n2];
            int entryKind = classpathEntry.getEntryKind();
            if (entryKind == 5 && defaultJREContainerEntry.getPath().isPrefixOf(classpathEntry.getPath())) {
                return classpathEntry;
            }
            ++n2;
        }
        return null;
    }

    public static String getDefaultBREE() {
        return JREContainerProvider.getDefaultJREContainerPath().lastSegment();
    }
}

