/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.occurrences;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.actions.AbstractToggleActionContributor;
import org.eclipse.xtext.ui.editor.actions.IActionContributor;
import org.eclipse.xtext.ui.editor.occurrences.Messages;
import org.eclipse.xtext.ui.editor.occurrences.OccurrenceMarker;
import org.eclipse.xtext.ui.internal.XtextPluginImages;

@Singleton
public class MarkOccurrenceActionContributor
extends AbstractToggleActionContributor
implements IActionContributor {
    public static final String EDITOR_MARK_OCCURRENCES = "ui.editor.markOccurrences";
    @Inject
    private Provider<OccurrenceMarker> occurrenceMarkerProvider;
    private Map<XtextEditor, OccurrenceMarker> editor2marker = Maps.newConcurrentMap();

    @Override
    public void contributeActions(XtextEditor editor) {
        this.editor2marker.computeIfAbsent(editor, e -> {
            Action action = this.getAction();
            editor.setAction(action.getId(), (IAction)action);
            IToolBarManager toolBarManager = editor.getEditorSite().getActionBars().getToolBarManager();
            if (toolBarManager.find(action.getId()) == null) {
                ActionContributionItem item = new ActionContributionItem((IAction)action);
                item.setVisible(false);
                toolBarManager.add((IContributionItem)item);
            }
            OccurrenceMarker occurrenceMarker = (OccurrenceMarker)this.occurrenceMarkerProvider.get();
            occurrenceMarker.connect(editor, this.isPropertySet());
            return occurrenceMarker;
        });
    }

    public OccurrenceMarker findOccurrenceMarker(XtextEditor editor) {
        return this.editor2marker.get(editor);
    }

    @Override
    public void editorDisposed(XtextEditor editor) {
        OccurrenceMarker occurrenceMarker = this.editor2marker.remove(editor);
        if (occurrenceMarker != null) {
            occurrenceMarker.disconnect(editor);
        }
    }

    @Override
    public String getPreferenceKey() {
        return EDITOR_MARK_OCCURRENCES;
    }

    @Override
    protected void stateChanged(boolean newState) {
        for (OccurrenceMarker occurrenceMarker : this.editor2marker.values()) {
            occurrenceMarker.setMarkOccurrences(newState);
        }
    }

    @Override
    protected void configureAction(Action action) {
        action.setText(Messages.MarkOccurrenceActionContributor_text);
        action.setDescription(Messages.MarkOccurrenceActionContributor_description);
        action.setToolTipText(Messages.MarkOccurrenceActionContributor_toolTipText);
        action.setImageDescriptor(XtextPluginImages.DESC_MARK_OCCURRENCES);
        action.setDisabledImageDescriptor(XtextPluginImages.DESC_MARK_OCCURRENCES_DISABLED);
        this.addPropertyChangeListener();
    }
}

