/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.validation;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtend.core.xtend.XtendAnnotationType;
import org.eclipse.xtend.core.xtend.XtendField;
import org.eclipse.xtend.core.xtend.XtendMember;
import org.eclipse.xtend.core.xtend.XtendPackage;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.common.types.JvmAnnotationType;
import org.eclipse.xtext.common.types.JvmEnumerationType;
import org.eclipse.xtext.common.types.JvmGenericArrayTypeReference;
import org.eclipse.xtext.common.types.JvmPrimitiveType;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.validation.AbstractDeclarativeValidator;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.ValidationMessageAcceptor;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.annotations.validation.AnnotationValueValidator;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotationsPackage;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationValidation
extends AbstractDeclarativeValidator {
    @Inject
    private AnnotationValueValidator annotationValueValidator;

    protected List<EPackage> getEPackages() {
        ArrayList _newArrayList = CollectionLiterals.newArrayList((Object[])new EPackage[]{XtendPackage.eINSTANCE, XbasePackage.eINSTANCE, XAnnotationsPackage.eINSTANCE});
        return _newArrayList;
    }

    @Check
    public void checkAnnotation(XtendAnnotationType it) {
        EList<XtendMember> _members = it.getMembers();
        Iterable _filter = Iterables.filter(_members, XtendField.class);
        for (XtendField it_1 : _filter) {
            XExpression _initialValue;
            boolean _notEquals;
            boolean _not;
            JvmTypeReference _type = it_1.getType();
            boolean _isValidAnnotationValueType = this.isValidAnnotationValueType(_type);
            boolean bl = _not = !_isValidAnnotationValueType;
            if (_not) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append((Object)"Invalid type ");
                JvmTypeReference _type_1 = it_1.getType();
                String _simpleName = _type_1.getSimpleName();
                _builder.append((Object)_simpleName, "");
                _builder.append((Object)" for the annotation attribute ");
                String _name = it_1.getName();
                _builder.append((Object)_name, "");
                _builder.append((Object)"; only primitive type, String, Class, annotation, enumeration are permitted or 1-dimensional arrays thereof");
                this.error(_builder.toString(), it_1, (EStructuralFeature)XtendPackage.Literals.XTEND_FIELD__TYPE, "org.eclipse.xtend.core.validation.IssueCodes.invalid_annotation_value_type", new String[0]);
            }
            boolean bl2 = _notEquals = !Objects.equal((Object)(_initialValue = it_1.getInitialValue()), null);
            if (!_notEquals) continue;
            XExpression _initialValue_1 = it_1.getInitialValue();
            this.annotationValueValidator.validateAnnotationValue(_initialValue_1, (ValidationMessageAcceptor)this);
        }
    }

    public boolean isValidAnnotationValueType(JvmTypeReference reference) {
        JvmTypeReference toCheck;
        boolean _equals;
        JvmTypeReference _switchResult = null;
        boolean _matched = false;
        if (!_matched && reference instanceof JvmGenericArrayTypeReference) {
            JvmTypeReference _componentType;
            JvmGenericArrayTypeReference _jvmGenericArrayTypeReference = (JvmGenericArrayTypeReference)reference;
            _matched = true;
            _switchResult = _componentType = _jvmGenericArrayTypeReference.getComponentType();
        }
        if (!_matched) {
            _switchResult = reference;
        }
        if (_equals = Objects.equal((Object)(toCheck = _switchResult), null)) {
            return true;
        }
        JvmType _type = toCheck.getType();
        if (_type instanceof JvmPrimitiveType) {
            return true;
        }
        JvmType _type_1 = toCheck.getType();
        if (_type_1 instanceof JvmEnumerationType) {
            return true;
        }
        JvmType _type_2 = toCheck.getType();
        if (_type_2 instanceof JvmAnnotationType) {
            return true;
        }
        boolean _or = false;
        JvmType _type_3 = toCheck.getType();
        String _qualifiedName = _type_3.getQualifiedName();
        boolean _equals_1 = Objects.equal((Object)_qualifiedName, (Object)"java.lang.String");
        if (_equals_1) {
            _or = true;
        } else {
            JvmType _type_4 = toCheck.getType();
            String _qualifiedName_1 = _type_4.getQualifiedName();
            boolean _equals_2 = Objects.equal((Object)_qualifiedName_1, (Object)"java.lang.Class");
            boolean bl = _or = _equals_1 || _equals_2;
        }
        return _or;
    }
}

