/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.scoping;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend.core.scoping.AbstractScope;
import org.eclipse.xtend.core.scoping.CachingTypeScope;
import org.eclipse.xtend.core.scoping.KnownTypesScope;
import org.eclipse.xtend.core.scoping.LegacyKnownTypesScope;
import org.eclipse.xtend.core.scoping.PrimitiveAwareScope;
import org.eclipse.xtend.core.scoping.RecordingTypeScope;
import org.eclipse.xtend.core.scoping.TypeParameterScope;
import org.eclipse.xtend.core.scoping.TypeScopeWithWildcardImports;
import org.eclipse.xtend.core.xtend.XtendFile;
import org.eclipse.xtend.core.xtend.XtendMember;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameterDeclarator;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.common.types.access.IJvmTypeProvider;
import org.eclipse.xtext.common.types.xtext.AbstractTypeScope;
import org.eclipse.xtext.common.types.xtext.AbstractTypeScopeProvider;
import org.eclipse.xtext.linking.impl.ImportedNamesAdapter;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.CompilerPhases;
import org.eclipse.xtext.resource.ISelectable;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.impl.ImportNormalizer;
import org.eclipse.xtext.scoping.impl.SelectableBasedScope;
import org.eclipse.xtext.util.IResourceScopeCache;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.scoping.AbstractNestedTypeAwareImportNormalizer;
import org.eclipse.xtext.xbase.scoping.XImportSectionNamespaceScopeProvider;
import org.eclipse.xtext.xbase.scoping.batch.ConstructorTypeScopeWrapper;
import org.eclipse.xtext.xbase.typesystem.util.IVisibilityHelper;
import org.eclipse.xtext.xtype.XImportDeclaration;
import org.eclipse.xtext.xtype.XImportSection;
import org.eclipse.xtext.xtype.XtypePackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XtendImportedNamespaceScopeProvider
extends XImportSectionNamespaceScopeProvider {
    public static final QualifiedName XTEND_LIB = QualifiedName.create((String[])new String[]{"org", "eclipse", "xtend", "lib"});
    public static final QualifiedName XBASE_LIB = XImportSectionNamespaceScopeProvider.XBASE_LIB;
    public static final QualifiedName JAVA_LANG = XImportSectionNamespaceScopeProvider.JAVA_LANG;
    @Inject
    private AbstractTypeScopeProvider typeScopeProvider;
    @Inject
    private IQualifiedNameConverter qualifiedNameConverter;
    @Inject
    private IResourceScopeCache resourceScopeCache;
    @Inject
    private CompilerPhases compilerPhases;

    public IScope getScope(EObject context, EReference reference) {
        EClass referenceType = reference.getEReferenceType();
        if (TypesPackage.Literals.JVM_TYPE.isSuperTypeOf(referenceType)) {
            if (context instanceof XImportDeclaration) {
                Resource resource = context.eResource();
                IJvmTypeProvider typeProvider = this.typeScopeProvider.getTypeProvider(resource.getResourceSet());
                AbstractTypeScope typeScope = this.typeScopeProvider.createTypeScope(typeProvider, null);
                RecordingTypeScope recordingTypeScope = new RecordingTypeScope(typeScope, this.getImportedNamesSet(resource));
                IScope scope = SelectableBasedScope.createScope((IScope)recordingTypeScope, (ISelectable)this.getAllDescriptions(resource), (EClass)reference.getEReferenceType(), (boolean)false);
                return scope;
            }
            final XtendFile xtendFile = this.getXtendFile(context);
            final Resource resource = xtendFile.eResource();
            AbstractScope result = (AbstractScope)this.resourceScopeCache.get((Object)"type.scope", xtendFile.eResource(), (Provider)new Provider<AbstractScope>(){

                public AbstractScope get() {
                    IJvmTypeProvider typeProvider = XtendImportedNamespaceScopeProvider.this.typeScopeProvider.getTypeProvider(resource.getResourceSet());
                    AbstractTypeScope typeScope = XtendImportedNamespaceScopeProvider.this.typeScopeProvider.createTypeScope(typeProvider, null);
                    RecordingTypeScope recordingTypeScope = new RecordingTypeScope(typeScope, XtendImportedNamespaceScopeProvider.this.getImportedNamesSet(resource));
                    AbstractScope rootTypeScope = XtendImportedNamespaceScopeProvider.this.getRootTypeScope(xtendFile, recordingTypeScope);
                    AbstractScope importScope = XtendImportedNamespaceScopeProvider.this.getImportScope(xtendFile.getImportSection(), rootTypeScope, recordingTypeScope);
                    AbstractScope localTypes = XtendImportedNamespaceScopeProvider.this.getLocalTypeScope(xtendFile.eResource(), xtendFile.getPackage(), importScope);
                    PrimitiveAwareScope primitiveAware = new PrimitiveAwareScope(localTypes, typeScope);
                    CachingTypeScope caching = new CachingTypeScope(primitiveAware);
                    return caching;
                }
            });
            XtendMember syntacticContainer = (XtendMember)EcoreUtil2.getContainerOfType((EObject)context, XtendMember.class);
            if (syntacticContainer != null) {
                result = this.getContainerScope(syntacticContainer, result);
            }
            return result;
        }
        if (TypesPackage.Literals.JVM_CONSTRUCTOR.isSuperTypeOf(referenceType)) {
            IScope typeScope = this.getScope(context, TypesPackage.Literals.JVM_PARAMETERIZED_TYPE_REFERENCE__TYPE);
            ConstructorTypeScopeWrapper result = new ConstructorTypeScopeWrapper(context, IVisibilityHelper.ALL, typeScope, true);
            return result;
        }
        throw new IllegalArgumentException("Unexpected global request for " + reference);
    }

    protected Set<QualifiedName> getImportedNamesSet(Resource resource) {
        ImportedNamesAdapter adapter = this.getImportedNamesAdapter(resource);
        return adapter.getImportedNames();
    }

    protected ImportedNamesAdapter getImportedNamesAdapter(Resource resource) {
        ImportedNamesAdapter adapter = ImportedNamesAdapter.find((Resource)resource);
        if (adapter != null) {
            return adapter;
        }
        ImportedNamesAdapter importedNamesAdapter = new ImportedNamesAdapter();
        resource.eAdapters().add((Object)importedNamesAdapter);
        return importedNamesAdapter;
    }

    protected XtendFile getXtendFile(EObject context) {
        Resource resource = context.eResource();
        XtendFile result = (XtendFile)resource.getContents().get(0);
        return result;
    }

    private AbstractScope getContainerScope(XtendMember syntacticContainer, AbstractScope result) {
        ArrayList typeParameters = null;
        while (syntacticContainer != null) {
            Set elements = this.getAssociations().getJvmElements((EObject)syntacticContainer);
            for (EObject derivedJvmElement : elements) {
                JvmTypeParameterDeclarator parameterDeclarator;
                EList current;
                if (!(derivedJvmElement instanceof JvmTypeParameterDeclarator) || (current = (parameterDeclarator = (JvmTypeParameterDeclarator)derivedJvmElement).getTypeParameters()).isEmpty()) continue;
                if (typeParameters == null) {
                    typeParameters = Lists.newArrayListWithCapacity((int)3);
                }
                typeParameters.add(current);
            }
            EObject container = syntacticContainer.eContainer();
            if (container instanceof XtendMember) {
                syntacticContainer = (XtendMember)container;
                continue;
            }
            if (typeParameters == null) {
                return result;
            }
            return new TypeParameterScope(typeParameters, result);
        }
        return result;
    }

    private AbstractScope getLocalTypeScope(Resource resource, String packageName, AbstractScope parent) {
        EList contents = resource.getContents();
        ArrayList knownTypes = Lists.newArrayListWithExpectedSize((int)(contents.size() - 1));
        for (EObject content : contents) {
            if (!(content instanceof JvmType)) continue;
            if (content instanceof JvmDeclaredType) {
                if (!Strings.equal((String)packageName, (String)((JvmDeclaredType)content).getPackageName())) continue;
                knownTypes.add((JvmType)content);
                continue;
            }
            knownTypes.add((JvmType)content);
        }
        if (knownTypes.isEmpty()) {
            return parent;
        }
        return new KnownTypesScope(knownTypes, parent);
    }

    private AbstractScope getImportScope(XImportSection importSection, AbstractScope parent, RecordingTypeScope typeScope) {
        if (importSection == null) {
            return parent;
        }
        EList importDeclarations = importSection.getImportDeclarations();
        if (importDeclarations.isEmpty()) {
            return parent;
        }
        ArrayList wildcardImports = null;
        ArrayList concreteImports = null;
        ArrayList importedNames = null;
        boolean hasLegacyImport = false;
        for (XImportDeclaration importDeclaration : importDeclarations) {
            if (importDeclaration.isStatic()) continue;
            if (importDeclaration.isWildcard()) {
                if (wildcardImports == null) {
                    wildcardImports = Lists.newArrayListWithCapacity((int)4);
                }
                String importedNamespace = importDeclaration.getImportedNamespace();
                importedNamespace = importedNamespace.substring(0, importedNamespace.length() - 2);
                QualifiedName qualifiedImportedNamespace = this.qualifiedNameConverter.toQualifiedName(importedNamespace);
                wildcardImports.add(AbstractNestedTypeAwareImportNormalizer.createNestedTypeAwareImportNormalizer((QualifiedName)qualifiedImportedNamespace, (boolean)true, (boolean)false));
                continue;
            }
            JvmDeclaredType importedType = null;
            if (this.compilerPhases.isIndexing((Notifier)importSection)) {
                EObject proxy = (EObject)importDeclaration.eGet((EStructuralFeature)XtypePackage.Literals.XIMPORT_DECLARATION__IMPORTED_TYPE, false);
                if (proxy.eIsProxy()) {
                    URI uri = ((InternalEObject)proxy).eProxyURI();
                    importedType = (JvmDeclaredType)importSection.eResource().getResourceSet().getEObject(uri, true);
                }
            } else {
                importedType = importDeclaration.getImportedType();
            }
            if (importedType == null || importedType.eIsProxy()) continue;
            if (concreteImports == null || importedNames == null) {
                concreteImports = Lists.newArrayListWithCapacity((int)10);
                importedNames = Lists.newArrayListWithCapacity((int)10);
            }
            concreteImports.add(importedType);
            if (importedType.eContainer() instanceof JvmDeclaredType) {
                String importSyntax = this.getImportsConfiguration().getLegacyImportSyntax(importDeclaration);
                if (importSyntax != null) {
                    hasLegacyImport = true;
                    importedNames.add(this.getQualifiedNameConverter().toQualifiedName(importSyntax));
                    continue;
                }
                importedNames.add(null);
                continue;
            }
            importedNames.add(null);
        }
        return this.getImportScope(wildcardImports, concreteImports, hasLegacyImport ? importedNames : null, parent, typeScope);
    }

    private AbstractScope getImportScope(List<ImportNormalizer> wildcardImports, List<JvmType> concreteImports, List<QualifiedName> importedNames, AbstractScope parent, RecordingTypeScope typeScope) {
        AbstractScope result = parent;
        if (wildcardImports != null) {
            result = new TypeScopeWithWildcardImports(wildcardImports, typeScope, result);
        }
        if (concreteImports != null) {
            result = importedNames != null ? new LegacyKnownTypesScope(concreteImports, importedNames, result) : new KnownTypesScope(concreteImports, result);
        }
        return result;
    }

    protected AbstractScope getRootTypeScope(XtendFile rootContainer, RecordingTypeScope typeScope) {
        ImportNormalizer[][] implicitImports;
        String packageName = rootContainer.getPackage();
        if (packageName != null && packageName.length() > 0) {
            QualifiedName packageQualifiedName = this.qualifiedNameConverter.toQualifiedName(packageName);
            implicitImports = new ImportNormalizer[][]{{AbstractNestedTypeAwareImportNormalizer.createNestedTypeAwareImportNormalizer((QualifiedName)packageQualifiedName, (boolean)true, (boolean)false)}, {AbstractNestedTypeAwareImportNormalizer.createNestedTypeAwareImportNormalizer((QualifiedName)JAVA_LANG, (boolean)true, (boolean)false), AbstractNestedTypeAwareImportNormalizer.createNestedTypeAwareImportNormalizer((QualifiedName)XBASE_LIB, (boolean)true, (boolean)false), AbstractNestedTypeAwareImportNormalizer.createNestedTypeAwareImportNormalizer((QualifiedName)XTEND_LIB, (boolean)true, (boolean)false)}};
        } else {
            implicitImports = new ImportNormalizer[][]{{AbstractNestedTypeAwareImportNormalizer.createNestedTypeAwareImportNormalizer((QualifiedName)JAVA_LANG, (boolean)true, (boolean)false), AbstractNestedTypeAwareImportNormalizer.createNestedTypeAwareImportNormalizer((QualifiedName)XBASE_LIB, (boolean)true, (boolean)false), AbstractNestedTypeAwareImportNormalizer.createNestedTypeAwareImportNormalizer((QualifiedName)XTEND_LIB, (boolean)true, (boolean)false)}};
        }
        return new TypeScopeWithWildcardImports(implicitImports, typeScope);
    }
}

