/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.formatting;

import com.google.inject.Inject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.formatting.IWhitespaceInformationProvider;
import org.eclipse.xtext.preferences.IPreferenceValues;
import org.eclipse.xtext.preferences.IPreferenceValuesProvider;
import org.eclipse.xtext.preferences.PreferenceKey;
import org.eclipse.xtext.xbase.formatting.BasicFormatterPreferenceKeys;
import org.eclipse.xtext.xbase.formatting.IFormattingPreferenceValuesProvider;

public class FormatterPreferenceValuesProvider
implements IFormattingPreferenceValuesProvider {
    @Inject
    private IWhitespaceInformationProvider whitespaceInfo;
    @Inject
    private IPreferenceValuesProvider valuesProvider;

    public IPreferenceValues getPreferenceValues(Resource resource) {
        final IPreferenceValues preferenceValues = this.internalGetRawPreferenceValues(resource);
        final String indent = this.whitespaceInfo.getIndentationInformation(resource.getURI()).getIndentString();
        final String lineSep = this.whitespaceInfo.getLineSeparatorInformation(resource.getURI()).getLineSeparator();
        return new IPreferenceValues(){

            public String getPreference(PreferenceKey key) {
                if (key == BasicFormatterPreferenceKeys.indentation) {
                    return indent;
                }
                if (key == BasicFormatterPreferenceKeys.lineSeparator) {
                    return lineSep;
                }
                return preferenceValues.getPreference(key);
            }
        };
    }

    protected IPreferenceValues internalGetRawPreferenceValues(Resource resource) {
        return this.valuesProvider.getPreferenceValues(resource);
    }
}

