/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.hierarchy;

import java.util.Objects;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.DeferredTreeContentManager;
import org.eclipse.xtext.ide.editor.hierarchy.IHierarchyNode;
import org.eclipse.xtext.ide.editor.hierarchy.IHierarchyRoot;

public class HierarchyTreeContentProvider
implements ITreeContentProvider {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private final ViewPart viewPart;
    private DeferredTreeContentManager deferredTreeContentManager;

    public HierarchyTreeContentProvider(ViewPart viewPart) {
        this.viewPart = viewPart;
    }

    public Object[] getChildren(Object parentElement) {
        Object[] children = this.deferredTreeContentManager.getChildren(parentElement);
        return children != null ? children : EMPTY_ARRAY;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof IHierarchyRoot) {
            return ((IHierarchyRoot)inputElement).getRoots().stream().filter(Objects::nonNull).toArray();
        }
        return EMPTY_ARRAY;
    }

    public Object getParent(Object element) {
        if (element instanceof IHierarchyNode) {
            return ((IHierarchyNode)element).getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.deferredTreeContentManager.mayHaveChildren(element);
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (viewer instanceof AbstractTreeViewer) {
            this.deferredTreeContentManager = new DeferredTreeContentManager((AbstractTreeViewer)viewer, this.viewPart.getSite());
        }
    }
}

