/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.macro.declaration;

import com.google.common.base.Preconditions;
import java.util.List;
import org.eclipse.xtend.core.macro.ConditionUtils;
import org.eclipse.xtend.core.macro.declaration.ExpressionImpl;
import org.eclipse.xtend.core.macro.declaration.JvmMemberDeclarationImpl;
import org.eclipse.xtend.lib.macro.declaration.CompilationStrategy;
import org.eclipse.xtend.lib.macro.declaration.MutableParameterDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableTypeParameterDeclaration;
import org.eclipse.xtend.lib.macro.declaration.ParameterDeclaration;
import org.eclipse.xtend.lib.macro.declaration.TypeParameterDeclaration;
import org.eclipse.xtend.lib.macro.declaration.TypeReference;
import org.eclipse.xtend.lib.macro.expression.Expression;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmUpperBound;
import org.eclipse.xtext.common.types.TypesFactory;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public abstract class JvmExecutableDeclarationImpl<T extends JvmExecutable>
extends JvmMemberDeclarationImpl<T> {
    public Iterable<? extends TypeParameterDeclaration> getTypeParameters() {
        Functions.Function1 _function = it -> this.getCompilationUnit().toTypeParameterDeclaration((JvmTypeParameter)it);
        return ListExtensions.map((List)((JvmExecutable)this.getDelegate()).getTypeParameters(), (Functions.Function1)_function);
    }

    public boolean isVarArgs() {
        return ((JvmExecutable)this.getDelegate()).isVarArgs();
    }

    public Iterable<? extends ParameterDeclaration> getParameters() {
        Functions.Function1 _function = it -> this.getCompilationUnit().toParameterDeclaration((JvmFormalParameter)it);
        return ListExtensions.map((List)((JvmExecutable)this.getDelegate()).getParameters(), (Functions.Function1)_function);
    }

    public List<TypeReference> getExceptions() {
        Functions.Function1 _function = it -> this.getCompilationUnit().toTypeReference((JvmTypeReference)it);
        return ListExtensions.map((List)((JvmExecutable)this.getDelegate()).getExceptions(), (Functions.Function1)_function);
    }

    public Expression getBody() {
        Expression _xblockexpression = null;
        XExpression expression = this.getCompilationUnit().getJvmTypesBuilder().getExpression((JvmMember)this.getDelegate());
        _xblockexpression = this.getCompilationUnit().toExpression(expression);
        return _xblockexpression;
    }

    public void setBody(Expression body) {
        this.checkMutable();
        if (body == null) {
            this.getCompilationUnit().getJvmTypesBuilder().removeExistingBody((JvmMember)this.getDelegate());
        } else {
            this.getCompilationUnit().getJvmTypesBuilder().setBody((JvmExecutable)this.getDelegate(), (XExpression)((ExpressionImpl)body).getDelegate());
        }
    }

    public void setExceptions(TypeReference ... exceptions) {
        this.checkMutable();
        ConditionUtils.checkIterable((Iterable)Conversions.doWrapArray((Object)exceptions), "exceptions");
        ConditionUtils.checkInferredTypeReferences("exception type", exceptions);
        ((JvmExecutable)this.getDelegate()).getExceptions().clear();
        TypeReference[] typeReferenceArray = exceptions;
        int n = exceptions.length;
        int n2 = 0;
        while (n2 < n) {
            TypeReference exceptionType = typeReferenceArray[n2];
            if (exceptionType != null) {
                ((JvmExecutable)this.getDelegate()).getExceptions().add((Object)this.getCompilationUnit().toJvmTypeReference(exceptionType));
            }
            ++n2;
        }
    }

    public void setVarArgs(boolean isVarArgs) {
        this.checkMutable();
        ((JvmExecutable)this.getDelegate()).setVarArgs(isVarArgs);
    }

    public MutableTypeParameterDeclaration addTypeParameter(String name, TypeReference ... upperBounds) {
        this.checkMutable();
        ConditionUtils.checkJavaIdentifier(name, "name");
        ConditionUtils.checkIterable((Iterable)Conversions.doWrapArray((Object)upperBounds), "upperBounds");
        ConditionUtils.checkInferredTypeReferences("parameter type", upperBounds);
        JvmTypeParameter param = TypesFactory.eINSTANCE.createJvmTypeParameter();
        param.setName(name);
        ((JvmExecutable)this.getDelegate()).getTypeParameters().add((Object)param);
        TypeReference[] typeReferenceArray = upperBounds;
        int n = upperBounds.length;
        int n2 = 0;
        while (n2 < n) {
            TypeReference upper = typeReferenceArray[n2];
            JvmTypeReference typeRef = this.getCompilationUnit().toJvmTypeReference(upper);
            JvmUpperBound jvmUpperBound = TypesFactory.eINSTANCE.createJvmUpperBound();
            jvmUpperBound.setTypeReference(typeRef);
            param.getConstraints().add((Object)jvmUpperBound);
            ++n2;
        }
        TypeParameterDeclaration _typeParameterDeclaration = this.getCompilationUnit().toTypeParameterDeclaration(param);
        return (MutableTypeParameterDeclaration)_typeParameterDeclaration;
    }

    public void setBody(CompilationStrategy compilationStrategy) {
        this.checkMutable();
        Preconditions.checkArgument((compilationStrategy != null ? 1 : 0) != 0, (Object)"compilationStrategy cannot be null");
        this.getCompilationUnit().setCompilationStrategy((JvmExecutable)this.getDelegate(), compilationStrategy);
    }

    public void setBody(StringConcatenationClient compilationTemplate) {
        this.checkMutable();
        Preconditions.checkArgument((compilationTemplate != null ? 1 : 0) != 0, (Object)"compilationTemplate cannot be null");
        this.getCompilationUnit().setCompilationTemplate((JvmExecutable)this.getDelegate(), compilationTemplate);
    }

    public MutableParameterDeclaration addParameter(String name, TypeReference type) {
        return this.addParameter(((JvmExecutable)this.getDelegate()).getParameters().size(), name, type);
    }

    public MutableParameterDeclaration addParameter(int index, String name, TypeReference type) {
        this.checkMutable();
        ConditionUtils.checkJavaIdentifier(name, "name");
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"type cannot be null");
        boolean _isInferred = type.isInferred();
        if (_isInferred) {
            throw new IllegalArgumentException("Cannot use inferred type as parameter type.");
        }
        JvmFormalParameter param = TypesFactory.eINSTANCE.createJvmFormalParameter();
        param.setName(name);
        param.setParameterType(this.getCompilationUnit().toJvmTypeReference(type));
        ((JvmExecutable)this.getDelegate()).getParameters().add(index, (Object)param);
        ParameterDeclaration _parameterDeclaration = this.getCompilationUnit().toParameterDeclaration(param);
        return (MutableParameterDeclaration)_parameterDeclaration;
    }

    @Override
    public void remove() {
        this.getCompilationUnit().getJvmModelAssociator().removeLogicalChildAssociation((JvmIdentifiableElement)this.getDelegate());
        super.remove();
    }
}

