/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.access.impl;

import com.google.inject.Inject;
import org.apache.log4j.Logger;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.access.binary.BinaryClass;
import org.eclipse.xtext.common.types.access.binary.asm.ClassFileBytesAccess;
import org.eclipse.xtext.common.types.access.binary.asm.JvmDeclaredTypeBuilder;
import org.eclipse.xtext.common.types.access.impl.ITypeFactory;
import org.eclipse.xtext.common.types.access.reflect.ReflectURIHelper;
import org.eclipse.xtext.common.types.access.reflect.ReflectionTypeFactory;
import org.eclipse.xtext.util.internal.Stopwatches;
import org.objectweb.asm.Opcodes;

public class DeclaredTypeFactory
implements ITypeFactory<BinaryClass, JvmDeclaredType> {
    private final Stopwatches.StoppedTask createTypeTask = Stopwatches.forTask((String)"AsmTypeFactory.createType");
    private static final Logger logger = Logger.getLogger(DeclaredTypeFactory.class);
    private final ClassLoader classLoader;
    private final ClassFileBytesAccess bytesAccess;
    private static final boolean ASM_AVAILABLE = DeclaredTypeFactory.isAsm8Available();
    private final boolean useASM;

    @Inject
    public DeclaredTypeFactory(ClassFileBytesAccess bytesAccess, ClassLoader loader) {
        this(bytesAccess, loader, ASM_AVAILABLE);
    }

    public DeclaredTypeFactory(ClassFileBytesAccess bytesAccess, ClassLoader loader, boolean useASM) {
        this.bytesAccess = bytesAccess;
        this.classLoader = loader;
        this.useASM = useASM;
    }

    private static boolean isAsm8Available() {
        try {
            if (Opcodes.class.getDeclaredField("ASM9") != null) {
                return true;
            }
        }
        catch (NoClassDefFoundError e) {
            logger.warn((Object)"--- xtext.common.types ---------------------------------------------------");
            logger.warn((Object)"ASM library is not available. Falling back to java.lang.reflect API.");
        }
        catch (NoSuchFieldException e) {
            logger.warn((Object)"--- xtext.common.types ---------------------------------------------------");
            logger.warn((Object)"ASM library is too old. Falling back to java.lang.reflect API.");
        }
        logger.warn((Object)"Please note that no information about compile time constants is available.");
        logger.warn((Object)"It's recommended to use org.objectweb.asm 9.7.0 or better (Maven group id: org.ow2.asm).");
        logger.warn((Object)"--------------------------------------------------------------------------");
        return false;
    }

    @Override
    public JvmDeclaredType createType(BinaryClass binaryClass) {
        if (this.useASM) {
            try {
                this.createTypeTask.start();
                JvmDeclaredType jvmDeclaredType = this.doCreateType(binaryClass);
                return jvmDeclaredType;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                this.createTypeTask.stop();
            }
        }
        try {
            ReflectURIHelper uriHelper = new ReflectURIHelper();
            ReflectionTypeFactory reflectionBased = new ReflectionTypeFactory(uriHelper);
            Class<?> clazz = Class.forName(binaryClass.getName(), false, this.classLoader);
            return reflectionBased.createType(clazz);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    protected JvmDeclaredType doCreateType(BinaryClass binaryClass) {
        JvmDeclaredTypeBuilder builder = new JvmDeclaredTypeBuilder(binaryClass, this.bytesAccess, this.classLoader);
        return builder.buildType();
    }
}

