/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.generator;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provider;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.AbstractMetamodelDeclaration;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.ReferencedMetamodel;
import org.eclipse.xtext.XtextPackage;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsData;
import org.eclipse.xtext.xtext.RuleNames;
import org.eclipse.xtext.xtext.generator.CodeConfig;
import org.eclipse.xtext.xtext.generator.CompositeGeneratorFragment2;
import org.eclipse.xtext.xtext.generator.IXtextGeneratorFragment;
import org.eclipse.xtext.xtext.generator.IXtextGeneratorLanguage;
import org.eclipse.xtext.xtext.generator.ImplicitFragment;
import org.eclipse.xtext.xtext.generator.XtextGeneratorResourceSetInitializer;
import org.eclipse.xtext.xtext.generator.model.GuiceModuleAccess;
import org.eclipse.xtext.xtext.generator.model.StandaloneSetupAccess;
import org.eclipse.xtext.xtext.generator.model.project.IXtextProjectConfig;

public class XtextGeneratorLanguage
extends CompositeGeneratorFragment2
implements IXtextGeneratorLanguage {
    private static final Logger LOG = Logger.getLogger(XtextGeneratorLanguage.class);
    private String grammarUri;
    private String name;
    private Boolean generateXtendStubs;
    private Grammar grammar;
    private RuleNames ruleNames;
    private List<String> fileExtensions;
    private List<String> referencedResources = new ArrayList<String>();
    private ResourceSet resourceSet;
    private Module guiceModule = it -> {};
    private final StandaloneSetupAccess runtimeGenSetup = new StandaloneSetupAccess();
    private final GuiceModuleAccess runtimeGenModule = new GuiceModuleAccess();
    private final GuiceModuleAccess ideGenModule = new GuiceModuleAccess();
    private final GuiceModuleAccess eclipsePluginGenModule = new GuiceModuleAccess();
    private final GuiceModuleAccess webGenModule = new GuiceModuleAccess();
    @Inject
    private Provider<ResourceSet> resourceSetProvider;
    @Inject
    private IXtextProjectConfig projectConfig;
    @Inject
    private CodeConfig codeConfig;
    @Inject
    private XtextGeneratorResourceSetInitializer resourceSetInitializer;

    public void setGrammarUri(String uri) {
        this.grammarUri = uri;
    }

    public String getGrammarUri() {
        if (this.grammarUri != null) {
            return this.grammarUri;
        }
        return new File(this.projectConfig.getRuntime().getSrc().getPath(), String.valueOf(this.name.replace(".", "/")) + ".xtext").toURI().toString();
    }

    public void setName(String name) {
        this.name = name;
    }

    public final String getName() {
        return this.name;
    }

    public void setFileExtensions(String fileExtensions) {
        this.fileExtensions = Arrays.asList(fileExtensions.trim().split("\\s*,\\s*"));
    }

    public void addReferencedResource(String referencedResource) {
        this.referencedResources.add(referencedResource);
    }

    @Override
    public List<String> getFileExtensions() {
        if (this.fileExtensions == null || this.fileExtensions.isEmpty()) {
            this.setFileExtensions(GrammarUtil.getSimpleName((Grammar)this.grammar).toLowerCase());
            LOG.info((Object)("No explicit fileExtensions configured. Using '*." + this.fileExtensions + "'."));
        }
        return this.fileExtensions;
    }

    @Deprecated
    public void setGenerateXtendStubs(Boolean generateXtendStubs) {
        this.generateXtendStubs = generateXtendStubs;
    }

    @Override
    @Deprecated
    public boolean isGenerateXtendStubs() {
        if (this.generateXtendStubs != null) {
            return this.generateXtendStubs;
        }
        return this.codeConfig.isPreferXtendStubs();
    }

    @Override
    public void initialize(Injector injector) {
        this.getFragments().addAll(0, this.getImplicitFragments());
        injector.injectMembers((Object)this);
        if (this.resourceSet == null) {
            this.resourceSet = (ResourceSet)this.resourceSetProvider.get();
        }
        this.resourceSetInitializer.initialize(this.resourceSet, this.referencedResources);
        if (!this.resourceSet.getResources().isEmpty()) {
            this.installIndex();
            int i = 0;
            int size = this.resourceSet.getResources().size();
            while (i < size) {
                Resource res = (Resource)this.resourceSet.getResources().get(i);
                if (res.getContents().isEmpty()) {
                    LOG.error((Object)("Error loading '" + res.getURI() + "'"));
                } else if (!res.getErrors().isEmpty()) {
                    LOG.error((Object)("Error loading '" + res.getURI() + "':\n" + Joiner.on((String)"\n").join((Iterable)res.getErrors())));
                }
                ++i;
            }
            EcoreUtil.resolveAll((ResourceSet)this.resourceSet);
        }
        if (this.getGrammarUri() == null) {
            throw new IllegalStateException("No grammarUri or language name given");
        }
        XtextResource resource = (XtextResource)this.resourceSet.getResource(URI.createURI((String)this.getGrammarUri()), true);
        if (resource.getContents().isEmpty()) {
            throw new IllegalArgumentException("Couldn't load grammar for '" + this.getGrammarUri() + "'.");
        }
        if (!resource.getErrors().isEmpty()) {
            LOG.error((Object)resource.getErrors());
            throw new IllegalStateException("Problem parsing '" + this.getGrammarUri() + "':\n" + Joiner.on((String)"\n").join((Iterable)resource.getErrors()));
        }
        Grammar grammar = (Grammar)resource.getContents().get(0);
        this.validateGrammar(grammar);
        this.initialize(grammar);
        super.initialize(injector);
    }

    protected List<? extends IXtextGeneratorFragment> getImplicitFragments() {
        ArrayList<ImplicitFragment> fragments = new ArrayList<ImplicitFragment>();
        fragments.add(new ImplicitFragment());
        return fragments;
    }

    public void initialize(Grammar grammar) {
        this.grammar = grammar;
        this.ruleNames = RuleNames.getRuleNames((Grammar)grammar, (boolean)true);
    }

    private void installIndex() {
        ResourceDescriptionsData index = new ResourceDescriptionsData(Collections.emptyList());
        ArrayList resources = Lists.newArrayList((Iterable)this.resourceSet.getResources());
        for (Resource resource : resources) {
            this.index(resource, resource.getURI(), index);
        }
        ResourceDescriptionsData.ResourceSetAdapter.installResourceDescriptionsData((ResourceSet)this.resourceSet, (ResourceDescriptionsData)index);
    }

    private void index(Resource resource, URI uri, ResourceDescriptionsData index) {
        IResourceDescription resourceDescription;
        IResourceServiceProvider serviceProvider = IResourceServiceProvider.Registry.INSTANCE.getResourceServiceProvider(uri);
        if (serviceProvider != null && (resourceDescription = serviceProvider.getResourceDescriptionManager().getResourceDescription(resource)) != null) {
            index.addDescription(uri, resourceDescription);
        }
    }

    protected void validateGrammar(final Grammar grammar) {
        this.validateAllImports(grammar);
        EValidator validator = EValidator.Registry.INSTANCE.getEValidator((EPackage)XtextPackage.eINSTANCE);
        if (validator != null) {
            DiagnosticChain chain = new DiagnosticChain(){

                public void add(Diagnostic diagnostic) {
                    if (diagnostic.getSeverity() == 4) {
                        String grammarName = "Validation Error in " + grammar.getName() + ": ";
                        if (diagnostic.getException() == null) {
                            throw new IllegalStateException(String.valueOf(grammarName) + diagnostic.getMessage());
                        }
                        throw new IllegalStateException(String.valueOf(grammarName) + diagnostic.getMessage(), diagnostic.getException());
                    }
                }

                public void addAll(Diagnostic diagnostic) {
                    this.add(diagnostic);
                }

                public void merge(Diagnostic diagnostic) {
                    throw new UnsupportedOperationException();
                }
            };
            validator.validate((EObject)grammar, chain, null);
            TreeIterator iterator = grammar.eAllContents();
            while (iterator.hasNext()) {
                validator.validate((EObject)iterator.next(), chain, new HashMap());
            }
        }
    }

    protected void validateAllImports(Grammar grammar) {
        for (AbstractMetamodelDeclaration amd : GrammarUtil.allMetamodelDeclarations((Grammar)grammar)) {
            if (!(amd instanceof ReferencedMetamodel)) continue;
            this.validateReferencedMetamodel((ReferencedMetamodel)amd);
        }
    }

    protected void validateReferencedMetamodel(ReferencedMetamodel ref) {
        if (ref.getEPackage() != null && !ref.getEPackage().eIsProxy()) {
            return;
        }
        EReference eref = XtextPackage.Literals.ABSTRACT_METAMODEL_DECLARATION__EPACKAGE;
        List nodes = NodeModelUtils.findNodesForFeature((EObject)ref, (EStructuralFeature)eref);
        String refName = null;
        refName = nodes.isEmpty() ? "(unknown)" : NodeModelUtils.getTokenText((INode)((INode)nodes.get(0)));
        String grammarName = GrammarUtil.getGrammar((EObject)ref).getName();
        String msg = "The EPackage " + refName + " in grammar " + grammarName + " could not be found. " + "You might want to register that EPackage in your workflow file.";
        throw new IllegalStateException(msg);
    }

    @Override
    public Grammar getGrammar() {
        return this.grammar;
    }

    public RuleNames getRuleNames() {
        return this.ruleNames;
    }

    public List<String> getReferencedResources() {
        return this.referencedResources;
    }

    @Override
    public ResourceSet getResourceSet() {
        return this.resourceSet;
    }

    public void setResourceSet(ResourceSet resourceSet) {
        this.resourceSet = resourceSet;
    }

    public Module getGuiceModule() {
        return this.guiceModule;
    }

    public void setGuiceModule(Module guiceModule) {
        this.guiceModule = guiceModule;
    }

    @Override
    public StandaloneSetupAccess getRuntimeGenSetup() {
        return this.runtimeGenSetup;
    }

    @Override
    public GuiceModuleAccess getRuntimeGenModule() {
        return this.runtimeGenModule;
    }

    @Override
    public GuiceModuleAccess getIdeGenModule() {
        return this.ideGenModule;
    }

    @Override
    public GuiceModuleAccess getEclipsePluginGenModule() {
        return this.eclipsePluginGenModule;
    }

    @Override
    public GuiceModuleAccess getWebGenModule() {
        return this.webGenModule;
    }
}

