/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.formatting.preferences;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jdt.internal.ui.preferences.PreferencesAccess;
import org.eclipse.jdt.internal.ui.preferences.formatter.IProfileVersioner;
import org.eclipse.jdt.internal.ui.preferences.formatter.ProfileManager;
import org.eclipse.osgi.util.NLS;
import org.eclipse.xtend.ide.formatting.preferences.Messages;
import org.osgi.service.prefs.BackingStoreException;

public abstract class AbstractProfileManager
extends ProfileManager {
    public static final String ID_PREFIX = "_";
    public static final int SELECTION_CHANGED_EVENT = 1;
    public static final int PROFILE_DELETED_EVENT = 2;
    public static final int PROFILE_RENAMED_EVENT = 3;
    public static final int PROFILE_CREATED_EVENT = 4;
    public static final int SETTINGS_CHANGED_EVENT = 5;
    private String fProfileKey;
    private final String fProfileVersionKey;
    private final Map fProfiles;
    private final List fProfilesByName;
    private ProfileManager.Profile fSelected;
    private ProfileManager.KeySet[] fKeySets;
    private final PreferencesAccess fPreferencesAccess;
    private final IProfileVersioner fProfileVersioner;

    public AbstractProfileManager(List profiles, IScopeContext context, PreferencesAccess preferencesAccess, IProfileVersioner profileVersioner, ProfileManager.KeySet[] keySets, String profileKey, String profileVersionKey) {
        block6: {
            String projProfileId;
            ProfileManager.Profile matching;
            Map map;
            block8: {
                ArrayList allKeys;
                block7: {
                    ProfileManager.Profile profile2;
                    super(profiles, context, preferencesAccess, profileVersioner, keySets, profileKey, profileVersionKey);
                    this.fProfileKey = null;
                    this.fKeySets = null;
                    this.fPreferencesAccess = preferencesAccess;
                    this.fProfileVersioner = profileVersioner;
                    this.fKeySets = (ProfileManager.KeySet[])keySets.clone();
                    this.fProfileKey = profileKey;
                    this.fProfileVersionKey = profileVersionKey;
                    this.fProfiles = new HashMap();
                    this.fProfilesByName = new ArrayList();
                    for (ProfileManager.Profile profile2 : profiles) {
                        if (profile2 instanceof ProfileManager.CustomProfile) {
                            ((ProfileManager.CustomProfile)profile2).setManager((ProfileManager)this);
                        }
                        this.fProfiles.put(profile2.getID(), profile2);
                        this.fProfilesByName.add(profile2);
                    }
                    Collections.sort(this.fProfilesByName);
                    String profileId = this.getSelectedProfileId(this.fPreferencesAccess.getInstanceScope());
                    profile2 = (ProfileManager.Profile)this.fProfiles.get(profileId);
                    if (profile2 == null) {
                        profile2 = this.getDefaultProfile();
                    }
                    this.fSelected = profile2;
                    if (context.getName() != "project" || !this.hasProjectSpecificSettings(context) || (map = this.readFromPreferenceStore(context, profile2)) == null) break block6;
                    allKeys = new ArrayList();
                    int i = 0;
                    while (i < this.fKeySets.length) {
                        allKeys.addAll(this.fKeySets[i].getKeys());
                        ++i;
                    }
                    Collections.sort(allKeys);
                    matching = null;
                    projProfileId = context.getNode(this.getNodeId()).get(this.fProfileKey, null);
                    if (projProfileId == null) break block7;
                    ProfileManager.Profile curr = (ProfileManager.Profile)this.fProfiles.get(projProfileId);
                    if (curr == null || !curr.isBuiltInProfile() && !curr.hasEqualSettings(map, allKeys)) break block8;
                    matching = curr;
                    break block8;
                }
                for (ProfileManager.Profile curr : this.fProfilesByName) {
                    if (!curr.hasEqualSettings(map, allKeys)) continue;
                    matching = curr;
                    break;
                }
            }
            if (matching == null) {
                String name = projProfileId != null && !this.fProfiles.containsKey(projProfileId) ? NLS.bind((String)Messages.AbstractProfileManager_unmanaged_profile_with_name, (Object)projProfileId.substring(ID_PREFIX.length())) : Messages.AbstractProfileManager_unmanaged_profile;
                ProfileManager.SharedProfile shared = new ProfileManager.SharedProfile((ProfileManager)this, name, map, this.fProfileVersioner.getCurrentVersion(), this.fProfileVersioner.getProfileKind());
                shared.setManager((ProfileManager)this);
                this.fProfiles.put(shared.getID(), shared);
                this.fProfilesByName.add(shared);
                matching = shared;
            }
            this.fSelected = matching;
        }
    }

    protected String getSelectedProfileId(IScopeContext instanceScope) {
        if (this.fProfileKey != null) {
            String profileId = instanceScope.getNode(this.getNodeId()).get(this.fProfileKey, null);
            if (profileId == null) {
                profileId = new DefaultScope().getNode(this.getNodeId()).get(this.fProfileKey, null);
            }
            return profileId;
        }
        return null;
    }

    protected abstract String getNodeId();

    protected void notifyObservers(int message) {
        this.setChanged();
        this.notifyObservers(message);
    }

    public static boolean hasProjectSpecificSettings(IScopeContext context, ProfileManager.KeySet[] keySets) {
        int i = 0;
        while (i < keySets.length) {
            ProfileManager.KeySet keySet = keySets[i];
            IEclipsePreferences preferences = context.getNode(keySet.getNodeName());
            for (String key : keySet.getKeys()) {
                String val = preferences.get(key, null);
                if (val == null) continue;
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean hasProjectSpecificSettings(IScopeContext context) {
        if (this.fKeySets != null) {
            return AbstractProfileManager.hasProjectSpecificSettings(context, this.fKeySets);
        }
        return false;
    }

    private Map readFromPreferenceStore(IScopeContext context, ProfileManager.Profile workspaceProfile) {
        HashMap<String, String> profileOptions = new HashMap<String, String>();
        IEclipsePreferences uiPrefs = context.getNode(this.getNodeId());
        int version = uiPrefs.getInt(this.fProfileVersionKey, this.fProfileVersioner.getFirstVersion());
        if (version != this.fProfileVersioner.getCurrentVersion()) {
            HashMap allOptions = new HashMap();
            int i = 0;
            while (i < this.fKeySets.length) {
                this.addAll(context.getNode(this.fKeySets[i].getNodeName()), allOptions);
                ++i;
            }
            ProfileManager.CustomProfile profile = new ProfileManager.CustomProfile("tmp", allOptions, version, this.fProfileVersioner.getProfileKind());
            this.fProfileVersioner.update(profile);
            return profile.getSettings();
        }
        boolean hasValues = false;
        int i = 0;
        while (i < this.fKeySets.length) {
            ProfileManager.KeySet keySet = this.fKeySets[i];
            IEclipsePreferences preferences = context.getNode(keySet.getNodeName());
            for (String key : keySet.getKeys()) {
                String val = preferences.get(key, null);
                if (val != null) {
                    hasValues = true;
                } else {
                    val = workspaceProfile.getSettings().get(key);
                }
                profileOptions.put(key, val);
            }
            ++i;
        }
        if (!hasValues) {
            return null;
        }
        AbstractProfileManager.setLatestCompliance(profileOptions);
        return profileOptions;
    }

    private void addAll(IEclipsePreferences uiPrefs, Map allOptions) {
        try {
            String[] keys = uiPrefs.keys();
            int i = 0;
            while (i < keys.length) {
                String key = keys[i];
                String val = uiPrefs.get(key, null);
                if (val != null) {
                    allOptions.put(key, val);
                }
                ++i;
            }
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    private boolean updatePreferences(IEclipsePreferences prefs, List keys, Map profileOptions) {
        boolean hasChanges = false;
        for (String key : keys) {
            String oldVal = prefs.get(key, null);
            String val = (String)profileOptions.get(key);
            if (val == null) {
                if (oldVal == null) continue;
                prefs.remove(key);
                hasChanges = true;
                continue;
            }
            if (val.equals(oldVal)) continue;
            prefs.put(key, val);
            hasChanges = true;
        }
        return hasChanges;
    }

    private void writeToPreferenceStore(ProfileManager.Profile profile, IScopeContext context) {
        Map profileOptions = profile.getSettings();
        int i = 0;
        while (i < this.fKeySets.length) {
            this.updatePreferences(context.getNode(this.fKeySets[i].getNodeName()), this.fKeySets[i].getKeys(), profileOptions);
            ++i;
        }
        IEclipsePreferences uiPrefs = context.getNode(this.getNodeId());
        if (uiPrefs.getInt(this.fProfileVersionKey, 0) != this.fProfileVersioner.getCurrentVersion()) {
            uiPrefs.putInt(this.fProfileVersionKey, this.fProfileVersioner.getCurrentVersion());
        }
        if (context.getName() == "instance") {
            uiPrefs.put(this.fProfileKey, profile.getID());
        } else if (context.getName() == "project" && !profile.isSharedProfile()) {
            uiPrefs.put(this.fProfileKey, profile.getID());
        }
    }

    public List getSortedProfiles() {
        return Collections.unmodifiableList(this.fProfilesByName);
    }

    public String[] getSortedDisplayNames() {
        String[] sortedNames = new String[this.fProfilesByName.size()];
        int i = 0;
        for (ProfileManager.Profile curr : this.fProfilesByName) {
            sortedNames[i++] = curr.getName();
        }
        return sortedNames;
    }

    public ProfileManager.Profile getProfile(String ID) {
        if (this.fProfiles != null) {
            return (ProfileManager.Profile)this.fProfiles.get(ID);
        }
        return null;
    }

    public void commitChanges(IScopeContext scopeContext) {
        if (this.fSelected != null) {
            this.writeToPreferenceStore(this.fSelected, scopeContext);
        }
    }

    public void clearAllSettings(IScopeContext context) {
        int i = 0;
        while (i < this.fKeySets.length) {
            this.updatePreferences(context.getNode(this.fKeySets[i].getNodeName()), this.fKeySets[i].getKeys(), Collections.EMPTY_MAP);
            ++i;
        }
        IEclipsePreferences uiPrefs = context.getNode(this.getNodeId());
        uiPrefs.remove(this.fProfileKey);
    }

    public ProfileManager.Profile getSelected() {
        return this.fSelected;
    }

    public void setSelected(ProfileManager.Profile profile) {
        ProfileManager.Profile newSelected = (ProfileManager.Profile)this.fProfiles.get(profile.getID());
        if (newSelected != null && !newSelected.equals(this.fSelected)) {
            this.fSelected = newSelected;
            this.notifyObservers(1);
        }
    }

    public boolean containsName(String name) {
        for (ProfileManager.Profile curr : this.fProfilesByName) {
            if (!name.equals(curr.getName())) continue;
            return true;
        }
        return false;
    }

    public void addProfile(ProfileManager.CustomProfile profile) {
        profile.setManager((ProfileManager)this);
        ProfileManager.CustomProfile oldProfile = (ProfileManager.CustomProfile)this.fProfiles.get(profile.getID());
        if (oldProfile != null) {
            this.fProfiles.remove(oldProfile.getID());
            this.fProfilesByName.remove(oldProfile);
            oldProfile.setManager(null);
        }
        this.fProfiles.put(profile.getID(), profile);
        this.fProfilesByName.add(profile);
        Collections.sort(this.fProfilesByName);
        this.fSelected = profile;
        this.notifyObservers(4);
    }

    public boolean deleteSelected() {
        if (!(this.fSelected instanceof ProfileManager.CustomProfile)) {
            return false;
        }
        return this.deleteProfile((ProfileManager.CustomProfile)this.fSelected);
    }

    public boolean deleteProfile(ProfileManager.CustomProfile profile) {
        int index = this.fProfilesByName.indexOf(profile);
        this.fProfiles.remove(profile.getID());
        this.fProfilesByName.remove(profile);
        profile.setManager(null);
        if (index >= this.fProfilesByName.size()) {
            --index;
        }
        this.fSelected = (ProfileManager.Profile)this.fProfilesByName.get(index);
        if (!profile.isSharedProfile()) {
            this.updateProfilesWithName(profile.getID(), null, false);
        }
        this.notifyObservers(2);
        return true;
    }

    public void profileRenamed(ProfileManager.CustomProfile profile, String oldID) {
        this.fProfiles.remove(oldID);
        this.fProfiles.put(profile.getID(), profile);
        if (!profile.isSharedProfile()) {
            this.updateProfilesWithName(oldID, (ProfileManager.Profile)profile, false);
        }
        Collections.sort(this.fProfilesByName);
        this.notifyObservers(3);
    }

    public void profileReplaced(ProfileManager.CustomProfile oldProfile, ProfileManager.CustomProfile newProfile) {
        this.fProfiles.remove(oldProfile.getID());
        this.fProfiles.put(newProfile.getID(), newProfile);
        this.fProfilesByName.remove(oldProfile);
        this.fProfilesByName.add(newProfile);
        Collections.sort(this.fProfilesByName);
        if (!oldProfile.isSharedProfile()) {
            this.updateProfilesWithName(oldProfile.getID(), null, false);
        }
        this.setSelected((ProfileManager.Profile)newProfile);
        this.notifyObservers(4);
        this.notifyObservers(1);
    }

    public void profileChanged(ProfileManager.CustomProfile profile) {
        if (!profile.isSharedProfile()) {
            this.updateProfilesWithName(profile.getID(), (ProfileManager.Profile)profile, true);
        }
        this.notifyObservers(5);
    }

    protected void updateProfilesWithName(String oldName, ProfileManager.Profile newProfile, boolean applySettings) {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            IScopeContext projectScope = this.fPreferencesAccess.getProjectScope(projects[i]);
            IEclipsePreferences node = projectScope.getNode(this.getNodeId());
            String profileId = node.get(this.fProfileKey, null);
            if (oldName.equals(profileId)) {
                if (newProfile == null) {
                    node.remove(this.fProfileKey);
                } else if (applySettings) {
                    this.writeToPreferenceStore(newProfile, projectScope);
                } else {
                    node.put(this.fProfileKey, newProfile.getID());
                }
            }
            ++i;
        }
        IScopeContext instanceScope = this.fPreferencesAccess.getInstanceScope();
        IEclipsePreferences uiPrefs = instanceScope.getNode(this.getNodeId());
        if (newProfile != null && oldName.equals(uiPrefs.get(this.fProfileKey, null))) {
            this.writeToPreferenceStore(newProfile, instanceScope);
        }
    }

    private static void setLatestCompliance(Map map) {
    }

    public abstract ProfileManager.Profile getDefaultProfile();

    public IProfileVersioner getProfileVersioner() {
        return this.fProfileVersioner;
    }
}

