/*
 * Decompiled with CFR 0.152.
 */
package org.atl.engine.injectors.ebnf;

import java.util.Iterator;
import java.util.Set;
import org.atl.engine.injectors.ebnf.EBNFInjector2;
import org.atl.engine.injectors.ebnf.ModelHandler;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMBoolean;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMCollection;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMEnumLiteral;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMInteger;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModelElement;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMOclAny;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMReal;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMSequence;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMString;

public class ASMModelHandler
implements ModelHandler {
    private EBNFInjector2 injector;

    public ASMModelHandler(EBNFInjector2 injector) {
        this.injector = injector;
    }

    public void actualSet(Object ame_, String propertyName, Object value) {
        ASMModelElement ame = (ASMModelElement)ame_;
        if (this.injector.isEmbedded && ((ASMString)ame.getType().get(null, "name")).getSymbol().equals("EmbeddedSyntaxSimpleElement")) {
            String type = "";
            type = value instanceof ASMInteger ? "Integer" : (value instanceof ASMReal ? "Double" : (value instanceof ASMBoolean ? "Boolean" : (value instanceof ASMString ? "String" : "Complex")));
            ASMModelElement prop = this.injector.extent.newModelElement("EmbeddedSyntax" + type + "Property");
            prop.set(null, "name", (ASMOclAny)new ASMString(propertyName));
            prop.set(null, "value", (ASMOclAny)value);
            ame.set(null, "properties", (ASMOclAny)prop);
        } else {
            ame.set(null, propertyName, (ASMOclAny)value);
        }
    }

    public Object get(Object ame_, String propertyName) {
        ASMOclAny ret = null;
        ASMModelElement ame = (ASMModelElement)ame_;
        if (this.injector.isEmbedded && ((ASMString)ame.getType().get(null, "name")).getSymbol().equals("EmbeddedSyntaxSimpleElement")) {
            Iterator i = ((ASMCollection)ame.get(null, "properties")).iterator();
            while (i.hasNext()) {
                ASMModelElement prop = (ASMModelElement)i.next();
                if (!propertyName.equals(((ASMString)prop.get(null, "name")).getSymbol())) continue;
                ret = (ASMOclAny)((ASMCollection)prop.get(null, "value")).iterator().next();
            }
        } else {
            ret = ame.get(null, propertyName);
        }
        return ret;
    }

    public Object createElement(String typeName) {
        ASMModelElement ret = null;
        if (this.injector.isEmbedded && !typeName.equals("EmbeddedSyntaxTokenElement")) {
            ret = this.injector.extent.newModelElement("EmbeddedSyntaxSimpleElement");
            ret.set(null, "type", (ASMOclAny)new ASMString(typeName));
        } else {
            ret = this.injector.extent.newModelElement(typeName);
        }
        return ret;
    }

    public Set getElementsByType(String typeName) {
        ASMModelElement valueType = this.injector.extent.getMetamodel().findModelElement(typeName);
        return this.injector.extent.getElementsByType(valueType);
    }

    public void set(Object ame, String prop, Object value) {
        if (!this.injector.buildModel) {
            return;
        }
        if (value instanceof ASMModelElement) {
            this.actualSet(ame, prop, (ASMModelElement)value);
        } else if (value instanceof ASMEnumLiteral) {
            this.actualSet(ame, prop, (ASMEnumLiteral)value);
        } else if (value instanceof ASMSequence) {
            this.actualSet(ame, prop, (ASMSequence)value);
        } else if (value instanceof Integer) {
            this.actualSet(ame, prop, new ASMInteger(((Integer)value).intValue()));
        } else if (value instanceof Double) {
            this.actualSet(ame, prop, new ASMReal(((Double)value).doubleValue()));
        } else if (value instanceof Boolean) {
            this.actualSet(ame, prop, new ASMBoolean(((Boolean)value).booleanValue()));
        } else if (value instanceof String) {
            this.actualSet(ame, prop, new ASMString((String)value));
        } else if (value != null) {
            this.injector.reportProblem("Error", "unsupported type " + value.getClass(), "?");
        }
    }

    public String getString(Object ame, String propName) {
        return ((ASMString)this.get(ame, propName)).getSymbol();
    }
}

