/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.internal.helper;

import java.io.LineNumberReader;
import java.io.StringReader;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.OCL;
import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.expressions.Variable;
import org.eclipse.ocl.helper.OCLHelper;
import org.eclipse.ocl.internal.OCLPlugin;
import org.eclipse.ocl.internal.helper.OCLHelperImpl;
import org.eclipse.ocl.lpg.ProblemHandler;
import org.eclipse.ocl.options.ParsingOptions;
import org.eclipse.ocl.parser.OCLAnalyzer;
import org.eclipse.ocl.parser.ValidationVisitor;
import org.eclipse.ocl.util.OCLUtil;
import org.eclipse.ocl.util.ObjectUtil;
import org.eclipse.ocl.utilities.ASTNode;
import org.eclipse.ocl.utilities.ExpressionInOCL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HelperUtil {
    static final int NONE = -1;
    static final String OCL_COMMENT = "--";
    static final String PATH_DELIMETER = "(=> ";
    static final String PACKAGE = "package";
    static final String COLON = ":";
    static final String DOUBLE_COLON = "::";
    static final String DOT = ".";
    static final String ARROW = "->";
    static final String CARET = "^";
    static final String DOUBLE_CARET = "^^";
    static final String EMPTY = "";
    static final String HTTP = "http://";

    private HelperUtil() {
    }

    public static <PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> OCLHelper<C, O, P, CT> createOCLHelper(OCL<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> ocl) {
        return new OCLHelperImpl<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E>(ocl);
    }

    static void throwException(RuntimeException exception, Class<?> clazz, String methodName) {
        OCLPlugin.throwing(clazz, methodName, exception);
        throw exception;
    }

    static void catchException(Exception exception, Class<?> clazz, String methodName) {
        OCLPlugin.catching(clazz, methodName, exception);
    }

    static String getLogicalLine(String txt) throws Exception {
        LineNumberReader reader = new LineNumberReader(new StringReader(txt.trim()));
        String logicalLine = EMPTY;
        int embeddedCommnetIndex = -1;
        String line = reader.readLine();
        while (line != null) {
            if (!(line = line.trim()).startsWith(OCL_COMMENT)) {
                embeddedCommnetIndex = line.indexOf(OCL_COMMENT);
                if (embeddedCommnetIndex != -1) {
                    line = line.substring(0, embeddedCommnetIndex);
                    line = line.trim();
                }
                logicalLine = String.valueOf(logicalLine) + line + ' ';
            }
            line = reader.readLine();
        }
        return logicalLine;
    }

    static <PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> OCLExpression<C> parseQuery(OCLHelperImpl<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> helper, String expression, boolean validate, boolean trace) throws ParserException {
        Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env = helper.getEnvironment();
        OCLAnalyzer<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> analyzer = HelperUtil.createAnalyzer(env, "inv:", expression, trace);
        CT constraint = analyzer.parseInvOrDefCS();
        HelperUtil.checkForErrors(helper);
        ExpressionInOCL spec = env.getUMLReflection().getSpecification(constraint);
        OCLExpression<C> result = spec.getBodyExpression();
        env.getUMLReflection().setSpecification(constraint, null);
        spec.setBodyExpression(null);
        if (validate) {
            HelperUtil.validate(env, result);
        }
        HelperUtil.finishAnalyzing(helper);
        HelperUtil.persist(env, spec.getContextVariable());
        HelperUtil.persist(env, result);
        ObjectUtil.dispose(constraint);
        return result;
    }

    static <PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> CT parseInvariant(OCLHelperImpl<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> helper, String expression, boolean validate, boolean trace) throws ParserException {
        Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env = helper.getEnvironment();
        OCLAnalyzer<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> analyzer = HelperUtil.createAnalyzer(env, "inv:", expression, trace);
        CT result = analyzer.parseInvOrDefCS();
        HelperUtil.checkForErrors(helper);
        if (validate) {
            HelperUtil.validate(env, result);
        }
        HelperUtil.finishAnalyzing(helper);
        HelperUtil.persist(helper, result);
        return result;
    }

    static <PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> CT parsePrecondition(OCLHelperImpl<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> helper, String expression, boolean validate, boolean trace) throws ParserException {
        Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env = helper.getEnvironment();
        OCLAnalyzer<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> analyzer = HelperUtil.createAnalyzer(env, "pre:", expression, trace);
        CT result = analyzer.parsePrePostOrBodyDeclCS();
        HelperUtil.checkForErrors(helper);
        if (validate) {
            HelperUtil.validate(env, result);
        }
        HelperUtil.finishAnalyzing(helper);
        HelperUtil.persist(helper, result);
        return result;
    }

    static <PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> CT parsePostcondition(OCLHelperImpl<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> helper, String expression, boolean validate, boolean trace) throws ParserException {
        Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env = helper.getEnvironment();
        OCLAnalyzer<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> analyzer = HelperUtil.createAnalyzer(env, "post:", expression, trace);
        CT result = analyzer.parsePrePostOrBodyDeclCS();
        HelperUtil.checkForErrors(helper);
        if (validate) {
            HelperUtil.validate(env, result);
        }
        HelperUtil.finishAnalyzing(helper);
        HelperUtil.persist(helper, result);
        return result;
    }

    static <PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> CT parseBodyCondition(OCLHelperImpl<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> helper, String expression, boolean validate, boolean trace) throws ParserException {
        Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env = helper.getEnvironment();
        OCLAnalyzer<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> analyzer = HelperUtil.createAnalyzer(env, "body:", expression, trace);
        CT result = analyzer.parsePrePostOrBodyDeclCS();
        HelperUtil.checkForErrors(helper);
        if (validate) {
            HelperUtil.validate(env, result);
        }
        HelperUtil.finishAnalyzing(helper);
        HelperUtil.persist(helper, result);
        return result;
    }

    static <PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> CT parseInitialValueExpression(OCLHelperImpl<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> helper, String expression, boolean validate, boolean trace) throws ParserException {
        Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env = helper.getEnvironment();
        OCLAnalyzer<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> analyzer = HelperUtil.createAnalyzer(env, "init:", expression, trace);
        CT result = analyzer.parseInitOrDerValueCS();
        HelperUtil.checkForErrors(helper);
        if (validate) {
            HelperUtil.validate(env, result);
        }
        HelperUtil.finishAnalyzing(helper);
        HelperUtil.persist(helper, result);
        return result;
    }

    static <PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> CT parseDerivedValueExpression(OCLHelperImpl<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> helper, String expression, boolean validate, boolean trace) throws ParserException {
        Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env = helper.getEnvironment();
        OCLAnalyzer<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> analyzer = HelperUtil.createAnalyzer(env, "derive:", expression, trace);
        CT result = analyzer.parseInitOrDerValueCS();
        HelperUtil.checkForErrors(helper);
        if (validate) {
            HelperUtil.validate(env, result);
        }
        HelperUtil.finishAnalyzing(helper);
        HelperUtil.persist(helper, result);
        return result;
    }

    static <PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> CT parseDefExpression(OCLHelperImpl<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> helper, String defExpression, boolean validate, boolean trace) throws ParserException {
        Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env = helper.getEnvironment();
        OCLAnalyzer<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> analyzer = HelperUtil.createAnalyzer(env, "def:", defExpression, trace);
        analyzer.getEnvironment().setOption(ParsingOptions.DEFINITION_CONSTRAINS_FEATURE, true);
        CT result = analyzer.parseInvOrDefCS();
        HelperUtil.checkForErrors(helper);
        if (validate) {
            HelperUtil.validate(env, result);
        }
        HelperUtil.finishAnalyzing(helper);
        HelperUtil.persist(helper, result);
        return result;
    }

    private static <PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> OCLAnalyzer<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> createAnalyzer(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, String prefix, String text, boolean trace) {
        OCLAnalyzer<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> result = new OCLAnalyzer<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E>(env, String.valueOf(prefix) + '\n' + text);
        ProblemHandler ph = OCLUtil.getAdapter(env, ProblemHandler.class);
        if (ph != null) {
            ph.setErrorReportLineOffset(-1);
            ph.beginParse();
        }
        result.setCharacterOffset(-(prefix.length() + 1));
        result.setTraceFlag(trace);
        return result;
    }

    private static <PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> void finishAnalyzing(OCLHelperImpl<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> helper) throws ParserException {
        ProblemHandler ph = OCLUtil.getAdapter(helper.getEnvironment(), ProblemHandler.class);
        if (ph != null) {
            ph.endParse();
        }
        HelperUtil.checkForErrors(helper);
    }

    private static <PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> void validate(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, OCLExpression<C> expression) throws ParserException {
        expression.accept(ValidationVisitor.getInstance(env));
    }

    private static <PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> void validate(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, CT constraint) throws ParserException {
        ValidationVisitor.getInstance(env).visitConstraint(constraint);
    }

    private static <PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> void persist(OCLHelperImpl<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> helper, CT constraint) {
        EObject constraintEObject = (EObject)constraint;
        if (constraintEObject.eResource() == null) {
            helper.getEnvironment().getTypeResolver().getResource().getContents().add((Object)constraintEObject);
        }
        helper.getOCL().getConstraints().add(constraint);
    }

    private static <PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> void persist(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, ASTNode astNode) {
        if (astNode.eResource() == null) {
            env.getTypeResolver().getResource().getContents().add((Object)astNode);
        }
    }

    public static <PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> Object getConstraintContext(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, Object element, OCLExpression<C> expr) {
        Object application;
        Object contextClassifier;
        ExpressionInOCL specification;
        Variable contextVariable;
        Object result = element;
        if (expr.eContainer() instanceof ExpressionInOCL && (contextVariable = (specification = (ExpressionInOCL)expr.eContainer()).getContextVariable()) != null && (contextClassifier = contextVariable.getType()) != null && env.getUMLReflection().isStereotype(contextClassifier) && (application = env.getUMLReflection().getStereotypeApplication(element, contextClassifier)) != null) {
            result = application;
        }
        return result;
    }

    private static <PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> void checkForErrors(OCLHelperImpl<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> helper) throws ParserException {
        try {
            helper.setProblems(OCLUtil.checkForErrors(helper.getEnvironment()));
        }
        catch (ParserException e) {
            helper.setProblems(e.getDiagnostic());
            throw e;
        }
    }
}

