/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eodm.owl.transformer;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.eodm.exceptions.UnsupportedViewTypeException;
import org.eclipse.eodm.owl.owlbase.EnumeratedClass;
import org.eclipse.eodm.owl.owlbase.OWLClass;
import org.eclipse.eodm.owl.owlbase.OWLDataRange;
import org.eclipse.eodm.owl.owlbase.OWLGraph;
import org.eclipse.eodm.owl.owlbase.OWLObjectProperty;
import org.eclipse.eodm.owl.owlbase.Property;
import org.eclipse.eodm.owl.reasoner.OWLReasonerException;
import org.eclipse.eodm.owl.reasoner.structural.OWLStructuralSubsumptionReasoner;
import org.eclipse.eodm.owl.resource.parser.impl.OWLDocumentImpl;
import org.eclipse.eodm.owl.resource.parser.impl.OWLOntologyGraph;
import org.eclipse.eodm.owl.resource.parser.impl.OWLParserImpl;
import org.eclipse.eodm.owl.transformer.EODMOWLTransformerException;
import org.eclipse.eodm.rdf.rdfbase.PlainLiteral;
import org.eclipse.eodm.rdf.rdfbase.RDFSLiteral;
import org.eclipse.eodm.rdf.rdfbase.RDFSResource;
import org.eclipse.eodm.rdf.rdfbase.URIReference;
import org.eclipse.eodm.rdf.rdfs.RDFSClass;
import org.eclipse.eodm.rdf.rdfs.RDFSDatatype;

public class OWL2Ecore {
    private static String OWL_THING = "http://www.w3.org/2002/07/owl#Thing";
    private static String XSD_BOOLEAN = "http://www.w3.org/2001/XMLSchema#boolean";
    private static String XSD_FLOAT = "http://www.w3.org/2001/XMLSchema#float";
    private static String XSD_BYTE = "http://www.w3.org/2001/XMLSchema#byte";
    private static String XSD_INT = "http://www.w3.org/2001/XMLSchema#int";
    private static String XSD_LONG = "http://www.w3.org/2001/XMLSchema#long";
    private static String XSD_DOUBLE = "http://www.w3.org/2001/XMLSchema#double";
    private static String XSD_SHORT = "http://www.w3.org/2001/XMLSchema#short";
    private static String XSD_STRING = "http://www.w3.org/2001/XMLSchema#string";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public static void owl2ecore(String owlfilePath, String ecoreFilePath, Map options) throws EODMOWLTransformerException {
        EPackage ep = OWL2Ecore.owl2ecore(owlfilePath, options);
        try {
            OWL2Ecore.saveEcore(ep, ecoreFilePath);
        }
        catch (IOException e) {
            throw new EODMOWLTransformerException("Fail to save ecore file:" + e.getMessage());
        }
    }

    public static EPackage owl2ecore(String owlFilePath, Map options) throws EODMOWLTransformerException {
        OWLGraph graph = null;
        try {
            graph = OWL2Ecore.loadOWLGraph(owlFilePath);
        }
        catch (IOException e) {
            throw new EODMOWLTransformerException("Fail to load owl file:" + e.getMessage());
        }
        return OWL2Ecore.owl2ecore(graph, options);
    }

    public static EPackage owl2ecore(OWLGraph graph, Map options) throws EODMOWLTransformerException {
        OWLStructuralSubsumptionReasoner reasoner = new OWLStructuralSubsumptionReasoner();
        try {
            reasoner.initialize(graph);
        }
        catch (OWLReasonerException e) {
            throw new EODMOWLTransformerException("Fail to inintialize OWL Reasoner: " + e.getMessage());
        }
        EPackage epackage = EcoreFactory.eINSTANCE.createEPackage();
        URIReference graphUri = graph.getGraphName();
        if (graphUri != null) {
            graphUri.getNamespace();
            epackage.setName(graphUri.getUri().getName());
        }
        HashMap owl2ecoreMap = new HashMap();
        try {
            ArrayList classList = graph.getTypeResources("http://www.w3.org/2000/01/rdf-schema#Class");
            Iterator ri = classList.iterator();
            while (ri.hasNext()) {
                EClassifier eclass;
                RDFSClass rclass = (RDFSClass)ri.next();
                if (!OWL2Ecore.isNamedObject((RDFSResource)rclass) || rclass.getURI().equals(OWL_THING) && rclass.getSubClass().isEmpty() || (eclass = OWL2Ecore.owl2eclassifier((RDFSResource)rclass, owl2ecoreMap)) == null) continue;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.eodm.owl.owlbase.OWLClass");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (rclass.canAsType((Class)clazz)) {
                    Class<?> clazz2 = class$0;
                    if (clazz2 == null) {
                        try {
                            clazz2 = Class.forName("org.eclipse.eodm.owl.owlbase.OWLClass");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    OWLClass oclass = (OWLClass)rclass.asType((Class)clazz2);
                    Iterator itSuper = reasoner.getAncestorClasses(oclass).iterator();
                    while (itSuper.hasNext()) {
                        OWLClass superClass = (OWLClass)itSuper.next();
                        if (superClass == oclass) continue;
                        EClass eSuperClass = (EClass)OWL2Ecore.owl2eclassifier((RDFSResource)superClass, owl2ecoreMap);
                        if (eSuperClass.getESuperTypes().contains((Object)eclass)) {
                            eSuperClass.getESuperTypes().remove((Object)eclass);
                            EAnnotation annotation1 = EcoreFactory.eINSTANCE.createEAnnotation();
                            annotation1.setSource("The " + eclass.getName() + " class is equivalent with " + eSuperClass.getName() + ".");
                            eclass.getEAnnotations().add((Object)annotation1);
                            EAnnotation annotation2 = EcoreFactory.eINSTANCE.createEAnnotation();
                            annotation2.setSource("The " + eSuperClass.getName() + " class is equivalent with " + eclass.getName() + ".");
                            eSuperClass.getEAnnotations().add((Object)annotation2);
                            continue;
                        }
                        ((EClass)eclass).getESuperTypes().add((Object)eSuperClass);
                    }
                    Iterator itP = oclass.getPropertyForDomain().iterator();
                    while (itP.hasNext()) {
                        RDFSResource rDFSResource = (RDFSResource)itP.next();
                        Class<?> clazz3 = class$1;
                        if (clazz3 == null) {
                            try {
                                clazz3 = Class.forName("org.eclipse.eodm.owl.owlbase.Property");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        Property p = (Property)rDFSResource.asType((Class)clazz3);
                        EStructuralFeature ep = OWL2Ecore.prop2EStructuralFeature(p, owl2ecoreMap);
                        if (p instanceof OWLObjectProperty) {
                            EList lst = ((OWLObjectProperty)p).getOWLinverseOf();
                            Iterator itInv = lst.iterator();
                            while (itInv.hasNext()) {
                                OWLObjectProperty pinv = (OWLObjectProperty)itInv.next();
                                if (pinv == null || pinv.getRDFSdomain().isEmpty()) continue;
                                EReference epinv = (EReference)OWL2Ecore.prop2EStructuralFeature((Property)pinv, owl2ecoreMap);
                                epinv.setEOpposite((EReference)ep);
                                ((EReference)ep).setEOpposite(epinv);
                            }
                        }
                        ((EClass)eclass).getEStructuralFeatures().add((Object)ep);
                        EList rlst = p.getRDFSrange();
                        if (rlst.isEmpty()) continue;
                        EClassifier erange = OWL2Ecore.owl2eclassifier((RDFSResource)p.getRDFSrange().get(0), owl2ecoreMap);
                        ep.setEType(erange);
                    }
                }
                epackage.getEClassifiers().add((Object)eclass);
            }
        }
        catch (UnsupportedViewTypeException e) {
            throw new EODMOWLTransformerException("Cannot load resources from graph: " + e.getMessage());
        }
        return epackage;
    }

    private static EStructuralFeature prop2EStructuralFeature(Property p, Map owl2ecoreMap) throws UnsupportedViewTypeException {
        EStructuralFeature ep = (EStructuralFeature)owl2ecoreMap.get(p);
        if (ep == null) {
            if (p instanceof OWLObjectProperty) {
                EAnnotation ea;
                OWLClass range;
                OWLClass oWLClass;
                ep = EcoreFactory.eINSTANCE.createEReference();
                if (p.getRDFSrange().isEmpty()) {
                    oWLClass = null;
                } else {
                    RDFSResource rDFSResource = (RDFSResource)p.getRDFSrange().get(0);
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.eclipse.eodm.owl.owlbase.OWLClass");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    oWLClass = range = (OWLClass)rDFSResource.asType((Class)clazz);
                }
                if (range != null) {
                    EClass erange = (EClass)owl2ecoreMap.get(range);
                    ep.setEType((EClassifier)erange);
                }
                if (((OWLObjectProperty)p).isIsTransitive()) {
                    ea = EcoreFactory.eINSTANCE.createEAnnotation();
                    ea.setSource("The property is Transitive.");
                    ep.getEAnnotations().add((Object)ea);
                }
                if (((OWLObjectProperty)p).isIsSymmetric()) {
                    ea = EcoreFactory.eINSTANCE.createEAnnotation();
                    ea.setSource("The property is Functional.");
                    ep.getEAnnotations().add((Object)ea);
                }
                if (((OWLObjectProperty)p).isIsInverseFunctional()) {
                    ea = EcoreFactory.eINSTANCE.createEAnnotation();
                    ea.setSource("The property is Inverse Functional.");
                    ep.getEAnnotations().add((Object)ea);
                }
            } else {
                ep = EcoreFactory.eINSTANCE.createEAttribute();
            }
            ep.setName(OWL2Ecore.getName((RDFSResource)p));
            ep.getEAnnotations().addAll((Collection)OWL2Ecore.createEAnnotation((RDFSResource)p));
            Iterator itSuper = p.getRDFSsubPropertyOf().iterator();
            while (itSuper.hasNext()) {
                Property superP;
                RDFSResource rDFSResource = (RDFSResource)itSuper.next();
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.eodm.owl.owlbase.Property");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((superP = (Property)rDFSResource.asType((Class)clazz)) == null) continue;
                EAnnotation ea = EcoreFactory.eINSTANCE.createEAnnotation();
                ea.setSource("The property is subPropertyOf " + OWL2Ecore.getName((RDFSResource)superP) + ".");
                ep.getEAnnotations().add((Object)ea);
            }
            if (p.isIsFunctional()) {
                EAnnotation ea = EcoreFactory.eINSTANCE.createEAnnotation();
                ea.setSource("The property is Functional.");
                ep.getEAnnotations().add((Object)ea);
            }
            owl2ecoreMap.put(p, ep);
        }
        return ep;
    }

    private static boolean isNamedObject(RDFSResource c) {
        String nid = c.getNodeID();
        return nid == null || nid.length() == 0;
    }

    private static EClassifier owl2eclassifier(RDFSResource oclass, Map owc2ecMap) {
        EClassifier eclass = (EClassifier)owc2ecMap.get(oclass);
        if (eclass == null) {
            if (oclass instanceof OWLDataRange || oclass instanceof EnumeratedClass) {
                eclass = OWL2Ecore.oneof2EEnum((RDFSClass)oclass, owc2ecMap);
            } else if (oclass instanceof RDFSDatatype) {
                RDFSDatatype dt = (RDFSDatatype)oclass;
                String dtURI = dt.getURI();
                if (dtURI != null) {
                    if (dtURI.equals(XSD_BOOLEAN)) {
                        eclass = EcorePackage.eINSTANCE.getEBoolean();
                    } else if (dtURI.equals(XSD_FLOAT)) {
                        eclass = EcorePackage.eINSTANCE.getEFloat();
                    } else if (dtURI.equals(XSD_INT)) {
                        eclass = EcorePackage.eINSTANCE.getEInt();
                    } else if (dtURI.equals(XSD_BYTE)) {
                        eclass = EcorePackage.eINSTANCE.getEByte();
                    } else if (dtURI.equals(XSD_LONG)) {
                        eclass = EcorePackage.eINSTANCE.getELong();
                    } else if (dtURI.equals(XSD_DOUBLE)) {
                        eclass = EcorePackage.eINSTANCE.getEDouble();
                    } else if (dtURI.equals(XSD_SHORT)) {
                        eclass = EcorePackage.eINSTANCE.getEShort();
                    } else if (dtURI.equals(XSD_STRING) || dtURI.equals("http://www.w3.org/2000/01/rdf-schema#Literal") || dtURI.equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral")) {
                        eclass = EcorePackage.eINSTANCE.getEString();
                    } else {
                        eclass = EcoreFactory.eINSTANCE.createEDataType();
                        eclass.setName(OWL2Ecore.getName((RDFSResource)dt));
                        eclass.getEAnnotations().addAll((Collection)OWL2Ecore.createEAnnotation((RDFSResource)dt));
                    }
                }
            } else {
                eclass = EcoreFactory.eINSTANCE.createEClass();
                eclass.setName(OWL2Ecore.getName(oclass));
                eclass.getEAnnotations().addAll((Collection)OWL2Ecore.createEAnnotation(oclass));
            }
            if (eclass != null) {
                owc2ecMap.put(oclass, eclass);
            }
        }
        return eclass;
    }

    private static String getName(RDFSResource r) {
        URIReference uriRef;
        String name = null;
        name = !r.getUriRef().isEmpty() ? ((uriRef = (URIReference)r.getUriRef().get(0)).getFragmentIdentifier() == null ? uriRef.getUri().getName() : uriRef.getFragmentIdentifier().getName()) : r.getURI();
        return name;
    }

    private static List createEAnnotation(RDFSResource rs) {
        EAnnotation annotation;
        ArrayList<EAnnotation> lst = new ArrayList<EAnnotation>();
        Iterator it = rs.getRDFScomment().iterator();
        while (it.hasNext()) {
            annotation = EcoreFactory.eINSTANCE.createEAnnotation();
            annotation.setSource("comment - " + ((PlainLiteral)it.next()).getLexicalForm());
            lst.add(annotation);
        }
        it = rs.getRDFSisDefinedBy().iterator();
        while (it.hasNext()) {
            annotation = EcoreFactory.eINSTANCE.createEAnnotation();
            annotation.setSource("isDefinedBy - " + ((RDFSResource)it.next()).getURI());
            lst.add(annotation);
        }
        it = rs.getRDFSlabel().iterator();
        while (it.hasNext()) {
            annotation = EcoreFactory.eINSTANCE.createEAnnotation();
            annotation.setSource("label - " + ((PlainLiteral)it.next()).getLexicalForm());
            lst.add(annotation);
        }
        if (rs instanceof OWLClass) {
            OWLClass c = (OWLClass)rs;
            Iterator it2 = c.getOWLdisjointWith().iterator();
            while (it2.hasNext()) {
                OWLClass owlc = (OWLClass)it2.next();
                if (owlc == null) continue;
                EAnnotation annotation2 = EcoreFactory.eINSTANCE.createEAnnotation();
                annotation2.setSource("The " + c.getURI() + " class is disjoint with " + owlc.getURI() + ".");
                lst.add(annotation2);
            }
        }
        return lst;
    }

    private static EEnum oneof2EEnum(RDFSClass enumclass, Map owl2eclassifer) {
        EEnum eenum = (EEnum)owl2eclassifer.get(enumclass);
        if (eenum == null) {
            EList memberList = null;
            memberList = enumclass instanceof OWLDataRange ? ((OWLDataRange)enumclass).getOWLDataRangeOneOf() : ((EnumeratedClass)enumclass).getOWLoneOf();
            if (!memberList.isEmpty()) {
                eenum = EcoreFactory.eINSTANCE.createEEnum();
                eenum.setName(OWL2Ecore.getName((RDFSResource)enumclass));
                eenum.getEAnnotations().addAll((Collection)OWL2Ecore.createEAnnotation((RDFSResource)enumclass));
                int intValue = 0;
                Iterator it = memberList.iterator();
                while (it.hasNext()) {
                    RDFSResource r = (RDFSResource)it.next();
                    String enumeration = r instanceof RDFSLiteral ? ((RDFSLiteral)r).getLexicalForm() : r.getURI();
                    EEnumLiteral eliteral = EcoreFactory.eINSTANCE.createEEnumLiteral();
                    eliteral.getEAnnotations().addAll((Collection)OWL2Ecore.createEAnnotation(r));
                    eliteral.setName(enumeration);
                    eliteral.setValue(intValue);
                    eenum.getELiterals().add((Object)eliteral);
                    ++intValue;
                }
            }
        }
        return eenum;
    }

    static OWLGraph loadOWLGraph(String owlFile) throws IOException {
        OWLParserImpl parser = new OWLParserImpl();
        OWLDocumentImpl document = new OWLDocumentImpl(owlFile, null, true);
        parser.addOWLDocument(document);
        OWLOntologyGraph[] ontoList = parser.parseOWLDocument(document);
        return ontoList[0].getgraph();
    }

    static void saveEcore(EPackage epackage, String outputEcoreFile) throws IOException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new EcoreResourceFactoryImpl());
        Resource resource = resourceSet.createResource(URI.createFileURI((String)new File(outputEcoreFile).getAbsolutePath()));
        resource.getContents().add((Object)epackage);
        resource.save(Collections.EMPTY_MAP);
    }
}

