/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.common.internal.draw2d.handles;

import java.awt.Point;
import java.awt.geom.AffineTransform;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.uml2.diagram.common.internal.draw2d.handles.Position2Direction;
import org.eclipse.uml2.diagram.common.internal.draw2d.handles.U2TResizeHandle;

public class ResizeCornerHandle
extends U2TResizeHandle {
    private int myDirection;
    private Point[] myCornerPoints = new Point[6];
    private int[] myCornerPolygon = new int[this.myCornerPoints.length * 2];
    private Rectangle mySquare;
    private static final int CORNER_SIZE = 10;

    public ResizeCornerHandle(GraphicalEditPart owner, int direction) {
        super(owner, direction, 0);
        this.myDirection = direction;
        int cornerThickness = 3;
        int cornerBreadth = 9;
        this.myCornerPoints[0] = new Point(0, 0);
        this.myCornerPoints[1] = new Point(cornerBreadth, 0);
        this.myCornerPoints[2] = new Point(cornerBreadth, cornerThickness);
        this.myCornerPoints[3] = new Point(cornerThickness, cornerThickness);
        this.myCornerPoints[4] = new Point(cornerThickness, cornerBreadth);
        this.myCornerPoints[5] = new Point(0, cornerBreadth);
        int defSize = 5;
        this.mySquare = new Rectangle(0, 0, defSize, defSize);
    }

    protected void init() {
        this.setPreferredSize(10, 10);
    }

    public void paintFigure(Graphics g) {
        Rectangle r = new Rectangle(this.getBounds());
        AffineTransform transform = new AffineTransform();
        if (this.myDirection == 9) {
            transform.translate(r.x, r.y);
        } else if (this.myDirection == 17) {
            transform.translate(r.x + r.width - 1, r.y);
            transform.rotate(Math.toRadians(90.0));
        } else if (this.myDirection == 20) {
            transform.translate(r.x + r.width - 1, r.y + r.height - 1);
            transform.rotate(Math.toRadians(180.0));
        } else if (this.myDirection == 12) {
            transform.translate(r.x, r.y + r.height - 1);
            transform.rotate(Math.toRadians(270.0));
        }
        if (this.hasUserBounds()) {
            this.paintBoldCorner(g, transform);
        } else {
            this.paintSquare(g);
        }
    }

    private void paintBoldCorner(Graphics g, AffineTransform transform) {
        ResizeCornerHandle.transformToPolygonPoints(transform, this.myCornerPoints, this.myCornerPolygon);
        g.setBackgroundColor(this.getFillColor());
        g.fillPolygon(this.myCornerPolygon);
        g.setForegroundColor(this.getBorderColor());
        g.drawPolygon(this.myCornerPolygon);
    }

    private void paintSquare(Graphics g) {
        Rectangle b = this.getBounds();
        g.setBackgroundColor(this.getFillColor());
        this.mySquare.setLocation(b.x + b.width / 2 - 3 + Position2Direction.getShiftCoeffX(this.myDirection) * 2, b.y + b.height / 2 - 3 + Position2Direction.getShiftCoeffY(this.myDirection) * 2);
        g.fillRectangle(this.mySquare);
        g.setForegroundColor(this.getBorderColor());
        g.drawRectangle(this.mySquare);
    }

    private static void transformToPolygonPoints(AffineTransform transform, Point[] source, int[] target) {
        Point targetPoint = new Point();
        int i = 0;
        while (i < source.length) {
            Point point = source[i];
            transform.transform(point, targetPoint);
            target[i * 2 + 0] = targetPoint.x;
            target[i * 2 + 1] = targetPoint.y;
            ++i;
        }
    }
}

