/**
 * <copyright> 
 * 
 * Copyright (c) 2004-2005 IBM Corporation and others. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License - v 1.0 
 * which accompanies this distribution, and is available at 
 * http://opensource.org/licenses/eclipse-1.0.txt 
 * 
 * Contributors: 
 *   IBM - Initial API and implementation 
 * 
 * </copyright> 
 * 
 * $Id: PropertyElement.java,v 1.2 2007/03/18 08:39:03 lzhang Exp $
 */
package org.eclipse.eodm.rdf.resource.parser.xml;

import org.eclipse.eodm.rdf.resource.parser.element.RDFResourceElement;
import org.eclipse.eodm.rdf.resource.parser.element.URIReference;

/**
 * Property element. Please refer to
 * http://www.w3.org/TR/rdf-syntax-grammar/#section-Syntax-node-property-elements.
 */
public class PropertyElement extends Element {
    private URIReference uriReference;

    private String dataType;

    private String parseType;

    private URIReference reificationURI;

    private boolean isCollectionContext = false;

    private boolean isEmpty = true;

    private RDFResourceElement lastLIResource;

    /**
     * Construct a property element by URIReference.
     * 
     * @param uriReference
     *            the uri reference
     */
    public PropertyElement(URIReference uriReference) {
        this.uriReference = uriReference;
    }

    /**
     * Get the uri reference
     * 
     * @return the uri reference
     */
    public URIReference getUriReference() {
        return uriReference;
    }

    /**
     * Set the uri reference
     * 
     * @param uriReference
     *            the uri reference
     */
    public void setUriReference(URIReference uriReference) {
        this.uriReference = uriReference;
    }

    /**
     * Get the data type
     * 
     * @return the data type
     */
    public String getDataType() {
        return dataType;
    }

    /**
     * Set the data type
     * 
     * @param dataType
     *            the data type
     */
    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    /**
     * Get the reification uri
     * 
     * @return the reification uri
     */
    public URIReference getReificationURI() {
        return reificationURI;
    }

    /**
     * Set the reification uri
     * 
     * @param reificationURI
     *            the reification uri
     */
    public void setReificationURI(URIReference reificationURI) {
        this.reificationURI = reificationURI;
    }

    /**
     * Check whether the property element is in collection context. eg.
     * parseType = "Collection".
     * 
     * @return true if the property element is in collection context
     */
    public boolean isCollectionContext() {
        return isCollectionContext;
    }

    /**
     * Set the property to be in collection context or not.
     * 
     * @param collectionContext
     *            Check whether the property element is in collection context
     */
    public void setCollectionContext(boolean collectionContext) {
        isCollectionContext = collectionContext;
    }

    /**
     * Get the last rdf:li resource.
     * 
     * @return the last rdf:li resource
     */
    public RDFResourceElement getLastLIResource() {
        return lastLIResource;
    }

    /**
     * Set the last rdf:li resource.
     * 
     * @param lastLIResource
     *            the last rdf:li resource
     */
    public void setLastLIResource(RDFResourceElement lastLIResource) {
        this.lastLIResource = lastLIResource;
    }

    public String toString() {
        return "PropertyElement{" + "uriReference=" + uriReference + "}";
    }

    /**
     * Check whether the property is empty or not.
     * 
     * @return
     */
    public boolean isEmpty() {
        return isEmpty;
    }

    /**
     * Set a flag to show whether the property is empty or not.
     * 
     * @param flag
     */
    public void setEmpty(boolean flag) {
        isEmpty = flag;
    }

    /**
     * Get the parsetype of the property
     * 
     * @return the parsetype
     */
    public String getParseType() {
        return parseType;
    }

    /**
     * Set the parsetype of the property
     * 
     * @param string
     *            the parsetype
     */
    public void setParseType(String string) {
        parseType = string;
    }
}