/**
 /**
 * <copyright> 
 * 
 * Copyright (c) 2004-2005 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License - v 1.0 
 * which accompanies this distribution, and is available at 
 * http://opensource.org/licenses/eclipse-1.0.txt 
 * 
 * Contributors: 
 *   IBM - Initial API and implementation 
 * 
 * </copyright> 
 *
 * $Id: OWLTaxonomyReasoner.java,v 1.1 2007/03/18 09:07:08 lzhang Exp $
 */
package org.eclipse.eodm.owl.reasoner;

import java.util.List;

import org.eclipse.eodm.owl.owlbase.OWLClass;
import org.eclipse.eodm.owl.owlbase.OWLGraph;
import org.eclipse.eodm.owl.owlbase.OWLOntology;
import org.eclipse.eodm.owl.owlbase.Property;


/**
 * OWLTaxonomyReasoner A OWL reasoner interface that provides tbox reasoning
 * over OWL Classes, including subsumption of classes and properties
 */
public interface OWLTaxonomyReasoner {

    /**
     * Initilize Reasoner with OWLOntology
     * 
     * @param ontology
     *            given ontology
     */
    public void initialize(OWLOntology ontology) throws OWLReasonerException;

    
    /**
     * Initilize Reasoner with OWLGraph
     * 
     * @param ontology
     *            given ontology
     */
    public void initialize(OWLGraph graph) throws OWLReasonerException;
    
    
    /**
     * Get all entailed sub classes of a OWLClass
     * 
     * @param c
     *            the OWLClass to be queried
     * @return all entailed sub classes of the given OWLClass
     */
    List getDescendantClasses(OWLClass c);

    /**
     * Get all entailed super classes of a OWLClass
     * 
     * @param c
     *            the OWLClass to be queried
     * @return all entailed super classes of the given OWLClass c
     */
    List getAncestorClasses(OWLClass c);

    /**
     * Get all entailed sub properties of a Property
     * 
     * @param property
     *            the Property to be queried
     * @return all entailed sub properties of the given property
     */
    List getDescendantProperties(Property property);

    /**
     * Get all entailed super properties of a Property
     * 
     * @param property
     *            the Property to be queried
     * @return all entailed sub properties of the given property
     */
    List getAncestorProperties(Property property);

    /**
     * Test whether two OWLClass have subClassOf relationship
     * 
     * @param c1
     *            OWLClass
     * @param c2
     *            OWLClass
     * @return true if c1 is subclass of c2
     */
    boolean isSubClassOf(OWLClass c1, OWLClass c2);

    /**
     * Test whether two OWLClass have superClassOf relationship
     * 
     * @param c1
     *            OWLClass
     * @param c2
     *            OWLClass
     * @return true if c1 is super class of c2
     */
    boolean isSuperClassOf(OWLClass c1, OWLClass c2);

    /**
     * Test whether two Property have subPropertyOf relationship
     * 
     * @param p1
     *            Property
     * @param p2
     *            Property
     * @return true if p1 is subPropertyOf of p2
     */
    boolean isSubPropertyOf(Property p1, Property p2);

    /**
     * Test whether two Property have superPropertyOf relationship
     * 
     * @param p1
     *            Property
     * @param p2
     *            Property
     * @return true if p1 is superPropertyOf of p2
     */
    boolean isSuperPropertyOf(Property p1, Property p2);

}
