/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.sequence.edit.policies;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.DeferredLayoutCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.CanonicalConnectionEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewRequest;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.uml2.diagram.common.editpolicies.UpdateDescriptionRequest;
import org.eclipse.uml2.diagram.common.genapi.IUpdaterLinkDescriptor;
import org.eclipse.uml2.diagram.common.genapi.IUpdaterNodeDescriptor;
import org.eclipse.uml2.diagram.sequence.part.UMLDiagramUpdater;
import org.eclipse.uml2.diagram.sequence.part.UMLVisualIDRegistry;
import org.eclipse.uml2.uml.UMLPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageCanonicalEditPolicy
extends CanonicalConnectionEditPolicy {
    Set myFeaturesToSynchronize;

    protected List getSemanticChildrenList() {
        View viewObject = (View)this.getHost().getModel();
        LinkedList<EObject> result = new LinkedList<EObject>();
        Iterator it = UMLDiagramUpdater.getPackage_1000SemanticChildren(viewObject).iterator();
        while (it.hasNext()) {
            result.add(((IUpdaterNodeDescriptor)it.next()).getModelElement());
        }
        return result;
    }

    protected boolean shouldDeleteView(View view) {
        return true;
    }

    protected boolean isOrphaned(Collection semanticChildren, View view) {
        int visualID = UMLVisualIDRegistry.getVisualID(view);
        switch (visualID) {
            case 3001: 
            case 3002: 
            case 3003: 
            case 3004: 
            case 3005: 
            case 3006: 
            case 3007: 
            case 3008: 
            case 3009: 
            case 3010: 
            case 3011: 
            case 3012: 
            case 3013: 
            case 3014: {
                return true;
            }
            case 2001: {
                if (semanticChildren.contains(view.getElement())) break;
                return true;
            }
        }
        return false;
    }

    protected String getDefaultFactoryHint() {
        return null;
    }

    protected Set getFeaturesToSynchronize() {
        if (this.myFeaturesToSynchronize == null) {
            this.myFeaturesToSynchronize = new HashSet();
            this.myFeaturesToSynchronize.add(UMLPackage.eINSTANCE.getPackage_PackagedElement());
        }
        return this.myFeaturesToSynchronize;
    }

    protected List getSemanticConnectionsList() {
        return Collections.EMPTY_LIST;
    }

    protected EObject getSourceElement(EObject relationship) {
        return null;
    }

    protected EObject getTargetElement(EObject relationship) {
        return null;
    }

    protected boolean shouldIncludeConnection(Edge connector, Collection children) {
        return false;
    }

    protected void refreshSemantic() {
        LinkedList createdViews = new LinkedList();
        createdViews.addAll(this.refreshSemanticChildren());
        LinkedList createdConnectionViews = new LinkedList();
        createdConnectionViews.addAll(this.refreshSemanticConnections());
        createdConnectionViews.addAll(this.refreshConnections());
        if (createdViews.size() > 1) {
            DeferredLayoutCommand layoutCmd = new DeferredLayoutCommand(this.host().getEditingDomain(), createdViews, this.host());
            this.executeCommand((Command)new ICommandProxy((ICommand)layoutCmd));
        }
        createdViews.addAll(createdConnectionViews);
        this.makeViewsImmutable(createdViews);
    }

    private Diagram getDiagram() {
        return ((View)this.getHost().getModel()).getDiagram();
    }

    private Collection refreshConnections() {
        Domain2Notation domain2NotationMap = new Domain2Notation();
        Collection linkDescriptors = this.collectAllLinks((View)this.getDiagram(), domain2NotationMap);
        LinkedList existingLinks = new LinkedList(this.getDiagram().getEdges());
        Iterator linksIterator = existingLinks.iterator();
        while (linksIterator.hasNext()) {
            Edge nextDiagramLink = (Edge)linksIterator.next();
            int diagramLinkVisualID = UMLVisualIDRegistry.getVisualID((View)nextDiagramLink);
            if (diagramLinkVisualID == -1) {
                if (nextDiagramLink.getSource() == null || nextDiagramLink.getTarget() == null) continue;
                linksIterator.remove();
                continue;
            }
            if (this.isNotationOnlyEdge(nextDiagramLink)) {
                linksIterator.remove();
                continue;
            }
            EObject diagramLinkObject = nextDiagramLink.getElement();
            EObject diagramLinkSrc = nextDiagramLink.getSource().getElement();
            EObject diagramLinkDst = nextDiagramLink.getTarget().getElement();
            boolean existingLinkRemoved = false;
            Iterator LinkDescriptorsIterator = linkDescriptors.iterator();
            while (LinkDescriptorsIterator.hasNext()) {
                IUpdaterLinkDescriptor nextLinkDescriptor = (IUpdaterLinkDescriptor)LinkDescriptorsIterator.next();
                if (diagramLinkObject != nextLinkDescriptor.getModelElement() || diagramLinkSrc != nextLinkDescriptor.getSource() || diagramLinkDst != nextLinkDescriptor.getDestination() || diagramLinkVisualID != nextLinkDescriptor.getVisualID()) continue;
                if (!existingLinkRemoved) {
                    linksIterator.remove();
                    existingLinkRemoved = true;
                }
                LinkDescriptorsIterator.remove();
            }
        }
        this.deleteViews(existingLinks.iterator());
        return this.createConnections(linkDescriptors, domain2NotationMap);
    }

    private Collection collectAllLinks(View view, Domain2Notation domain2NotationMap) {
        if (UMLVisualIDRegistry.isShortcutDescendant(view)) {
            return this.collectLinksOutgoingFromShortcut(view, domain2NotationMap);
        }
        LinkedList result = new LinkedList();
        switch (UMLVisualIDRegistry.getVisualID(view)) {
            case 1000: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getPackage_1000ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 2001: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getInteraction_2001ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3005: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getGate_3005ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3007: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getInteractionUse_3007ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3008: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getCombinedFragment_3008ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3009: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getInteractionOperand_3009ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3001: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getLifeline_3001ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3002: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getActionExecutionSpecification_3002ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3003: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getStateInvariant_3003ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3004: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getBehaviorExecutionSpecification_3004ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3006: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getInteractionUse_3006ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3010: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getCombinedFragment_3010ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3011: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getInteractionOperand_3011ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3012: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getActionExecutionSpecification_3012ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3013: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getStateInvariant_3013ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3014: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getBehaviorExecutionSpecification_3014ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 4001: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getMessage_4001ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
            }
        }
        Iterator children = view.getChildren().iterator();
        while (children.hasNext()) {
            result.addAll(this.collectAllLinks((View)children.next(), domain2NotationMap));
        }
        Iterator edges = view.getSourceEdges().iterator();
        while (edges.hasNext()) {
            result.addAll(this.collectAllLinks((View)edges.next(), domain2NotationMap));
        }
        return result;
    }

    private Collection createConnections(Collection linkDescriptors, Domain2Notation domain2NotationMap) {
        LinkedList<IAdaptable> adapters = new LinkedList<IAdaptable>();
        for (IUpdaterLinkDescriptor nextLinkDescriptor : linkDescriptors) {
            EditPart sourceEditPart = this.getSourceEditPart(nextLinkDescriptor, domain2NotationMap);
            EditPart targetEditPart = this.getTargetEditPart(nextLinkDescriptor, domain2NotationMap);
            if (sourceEditPart == null || targetEditPart == null) continue;
            CreateConnectionViewRequest.ConnectionViewDescriptor descriptor = new CreateConnectionViewRequest.ConnectionViewDescriptor(nextLinkDescriptor.getSemanticAdapter(), UMLVisualIDRegistry.getType(nextLinkDescriptor.getVisualID()), -1, false, ((IGraphicalEditPart)this.getHost()).getDiagramPreferencesHint());
            CreateConnectionViewRequest ccr = new CreateConnectionViewRequest(descriptor);
            ccr.setType((Object)"connection start");
            ccr.setSourceEditPart(sourceEditPart);
            sourceEditPart.getCommand((Request)ccr);
            ccr.setTargetEditPart(targetEditPart);
            ccr.setType((Object)"connection end");
            Command cmd = targetEditPart.getCommand((Request)ccr);
            if (cmd == null || !cmd.canExecute()) continue;
            this.executeCommand(cmd);
            IAdaptable viewAdapter = (IAdaptable)ccr.getNewObject();
            if (viewAdapter == null) continue;
            adapters.add(viewAdapter);
        }
        return adapters;
    }

    private EditPart getEditPart(EObject domainModelElement, Domain2Notation domain2NotationMap) {
        View view = domain2NotationMap.get(domainModelElement);
        if (view != null) {
            return (EditPart)this.getHost().getViewer().getEditPartRegistry().get(view);
        }
        return null;
    }

    private EditPart getSourceEditPart(IUpdaterLinkDescriptor descriptor, Domain2Notation domain2NotationMap) {
        return this.getEditPart(descriptor.getSource(), domain2NotationMap);
    }

    private EditPart getTargetEditPart(IUpdaterLinkDescriptor descriptor, Domain2Notation domain2NotationMap) {
        return this.getEditPart(descriptor.getDestination(), domain2NotationMap);
    }

    protected final EditPart getHintedEditPart(EObject domainModelElement, Domain2Notation domain2NotationMap, int hintVisualId) {
        View view = domain2NotationMap.getHinted(domainModelElement, UMLVisualIDRegistry.getType(hintVisualId));
        if (view != null) {
            return (EditPart)this.getHost().getViewer().getEditPartRegistry().get(view);
        }
        return null;
    }

    private boolean isNotationOnlyEdge(Edge edge) {
        switch (UMLVisualIDRegistry.getVisualID(edge.getType())) {
            case 4002: 
            case 4003: {
                return true;
            }
        }
        return false;
    }

    private Collection<IUpdaterLinkDescriptor> collectLinksOutgoingFromShortcut(View view, Domain2Notation domain2NotationMap) {
        EditPart ep = (EditPart)this.getHost().getViewer().getEditPartRegistry().get(view);
        if (!(ep instanceof IGraphicalEditPart)) {
            return Collections.emptyList();
        }
        IGraphicalEditPart editPart = (IGraphicalEditPart)ep;
        UpdateDescriptionRequest request = new UpdateDescriptionRequest();
        editPart.getCommand((Request)request);
        HashSet<IUpdaterLinkDescriptor> linksToFromShortcuts = new HashSet<IUpdaterLinkDescriptor>();
        for (UpdateDescriptionRequest.Descriptor next : request.getDescriptions()) {
            linksToFromShortcuts.addAll(next.getContainedLinks());
            linksToFromShortcuts.addAll(next.getOutgoingLinks());
            if (next.getSemanticElement() == null) continue;
            domain2NotationMap.put(next.getSemanticElement(), next.getProvider().getNotationView());
        }
        return linksToFromShortcuts;
    }

    protected String getFactoryHint(IAdaptable elementAdapter) {
        EObject domainModelElment = (EObject)elementAdapter.getAdapter(EObject.class);
        View containerView = ((IGraphicalEditPart)this.getHost()).getNotationView();
        int hint = UMLVisualIDRegistry.getNodeVisualID(containerView, domainModelElment);
        return hint != -1 ? UMLVisualIDRegistry.getType(hint) : super.getFactoryHint(elementAdapter);
    }

    private static class Domain2Notation {
        private final HashMap myMap = new HashMap();

        private Domain2Notation() {
        }

        public boolean containsDomainElement(EObject domainElement) {
            return this.myMap.containsKey(domainElement);
        }

        public boolean containsKey(EObject domainElement) {
            return this.containsDomainElement(domainElement);
        }

        public void put(EObject domainElement, View view) {
            Object viewOrList = this.myMap.get(domainElement);
            if (viewOrList instanceof View) {
                this.myMap.remove(domainElement);
                LinkedList<View> list = new LinkedList<View>();
                list.add((View)viewOrList);
                this.myMap.put(domainElement, list);
                list.add(view);
            } else if (viewOrList instanceof List) {
                ((List)viewOrList).add(view);
            } else {
                this.myMap.put(domainElement, view);
            }
        }

        public View get(EObject domainEObject) {
            Object viewOrList = this.myMap.get(domainEObject);
            if (viewOrList instanceof View) {
                return (View)viewOrList;
            }
            if (viewOrList instanceof List) {
                for (Object next : (List)viewOrList) {
                    View nextView = (View)next;
                    if (nextView.getEAnnotation("Shortcut") != null) continue;
                    return nextView;
                }
                return (View)((List)viewOrList).get(0);
            }
            return null;
        }

        public View getHinted(EObject domainEObject, String hint) {
            if (hint == null) {
                return this.get(domainEObject);
            }
            Object viewOrList = this.myMap.get(domainEObject);
            if (viewOrList instanceof View) {
                return (View)viewOrList;
            }
            if (viewOrList instanceof List) {
                for (Object next : (List)viewOrList) {
                    View nextView = (View)next;
                    if (!hint.equals(nextView.getType())) continue;
                    return nextView;
                }
                return (View)((List)viewOrList).get(0);
            }
            return null;
        }
    }
}

