/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.deploy.edit.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.commands.CreateElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.uml2.diagram.deploy.edit.policies.UMLBaseItemSemanticEditPolicy;
import org.eclipse.uml2.uml.DeployedArtifact;
import org.eclipse.uml2.uml.Deployment;
import org.eclipse.uml2.uml.DeploymentTarget;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UMLPackage;

public class DeploymentCreateCommand
extends CreateElementCommand {
    private final EObject source;
    private final EObject target;
    private DeploymentTarget container;

    public DeploymentCreateCommand(CreateRelationshipRequest request, EObject source, EObject target) {
        super((CreateElementRequest)request);
        this.source = source;
        this.target = target;
        if (request.getContainmentFeature() == null) {
            this.setContainmentFeature(UMLPackage.eINSTANCE.getDeploymentTarget_Deployment());
        }
        EObject element = source;
        while (element != null) {
            if (element instanceof DeploymentTarget) {
                this.container = (DeploymentTarget)element;
                super.setElementToEdit((EObject)this.container);
                break;
            }
            element = element.eContainer();
        }
    }

    public boolean canExecute() {
        if (this.source == null && this.target == null) {
            return false;
        }
        if (this.source != null && !(this.source instanceof DeploymentTarget)) {
            return false;
        }
        if (this.target != null && !(this.target instanceof DeployedArtifact)) {
            return false;
        }
        if (this.getSource() == null) {
            return true;
        }
        if (this.getContainer() == null) {
            return false;
        }
        return UMLBaseItemSemanticEditPolicy.LinkConstraints.canCreateDeployment_4001(this.getContainer(), this.getSource(), this.getTarget());
    }

    protected EObject doDefaultElementCreation() {
        Deployment newElement = UMLFactory.eINSTANCE.createDeployment();
        this.getContainer().getDeployments().add((Object)newElement);
        newElement.setLocation(this.getSource());
        newElement.getDeployedArtifacts().add((Object)this.getTarget());
        return newElement;
    }

    protected EClass getEClassToEdit() {
        return UMLPackage.eINSTANCE.getDeploymentTarget();
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.canExecute()) {
            throw new ExecutionException("Invalid arguments in create link command");
        }
        return super.doExecuteWithResult(monitor, info);
    }

    protected ConfigureRequest createConfigureRequest() {
        ConfigureRequest request = super.createConfigureRequest();
        request.setParameter("CreateRelationshipRequest.source", (Object)this.getSource());
        request.setParameter("CreateRelationshipRequest.target", (Object)this.getTarget());
        return request;
    }

    protected void setElementToEdit(EObject element) {
        throw new UnsupportedOperationException();
    }

    protected DeploymentTarget getSource() {
        return (DeploymentTarget)this.source;
    }

    protected DeployedArtifact getTarget() {
        return (DeployedArtifact)this.target;
    }

    public DeploymentTarget getContainer() {
        return this.container;
    }
}

