/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.internal;

import com.google.common.collect.Iterables;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.papyrus.infra.core.Activator;
import org.eclipse.papyrus.infra.core.resource.ModelMultiException;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.sashwindows.di.service.IPageManager;
import org.eclipse.papyrus.infra.core.services.ExtensionServicesRegistry;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServiceMultiException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.emf.api.IModelSetService;
import org.eclipse.papyrus.infra.emf.commands.CreateModelInModelSetCommand;
import org.eclipse.papyrus.infra.emf.resource.ICrossReferenceIndex;
import org.eclipse.papyrus.infra.emf.resource.ShardResourceLocator;

public class ModelSetService
implements IModelSetService {
    @Override
    public ModelSet getModelSet(ServicesRegistry servicesRegistry) {
        try {
            return (ModelSet)servicesRegistry.getService(ModelSet.class);
        }
        catch (ServiceException e) {
            Activator.log.error("The model set has been loaded in the services registry", (Throwable)e);
            return null;
        }
    }

    @Override
    public ModelSet createModelSet(IProject project) {
        ModelSet modelSet = null;
        if (project != null) {
            ExtensionServicesRegistry registry = null;
            try {
                registry = new ExtensionServicesRegistry("org.eclipse.papyrus.infra.core");
            }
            catch (ServiceException serviceException) {
                // empty catch block
            }
            if (registry != null) {
                try {
                    registry.startServicesByClassKeys(new Class[]{ModelSet.class});
                }
                catch (ServiceException serviceException) {
                    // empty catch block
                }
                try {
                    modelSet = (ModelSet)registry.getService(ModelSet.class);
                }
                catch (ServiceException serviceException) {
                    // empty catch block
                }
                if (modelSet != null) {
                    CommandStack stack = modelSet.getTransactionalEditingDomain().getCommandStack();
                    URI diURI = URI.createPlatformResourceURI((String)project.getName(), (boolean)false);
                    diURI = diURI.appendSegment(project.getName());
                    diURI = diURI.appendFileExtension("di");
                    CreateModelInModelSetCommand command = new CreateModelInModelSetCommand(modelSet, diURI);
                    if (stack != null && command.canExecute()) {
                        stack.execute((Command)command);
                    }
                    try {
                        registry.startRegistry();
                    }
                    catch (ServiceMultiException serviceMultiException) {
                        // empty catch block
                    }
                    try {
                        registry.getService(IPageManager.class);
                    }
                    catch (ServiceException serviceException) {
                        // empty catch block
                    }
                }
            }
        }
        return modelSet;
    }

    @Override
    public ModelSet loadModelSet(URI uri, ServicesRegistry registry) {
        ModelSet modelSet = null;
        if (registry != null) {
            try {
                registry.startServicesByClassKeys(new Class[]{ModelSet.class});
            }
            catch (ServiceException ex) {
                Activator.log.error("Impossible to launch the service ModelSet", (Throwable)ex);
            }
            try {
                modelSet = (ModelSet)registry.getService(ModelSet.class);
            }
            catch (ServiceException e1) {
                Activator.log.error("Impossible to get the service ModelSet", (Throwable)e1);
            }
            if (modelSet.isShardingSupported()) {
                new ShardResourceLocator((ResourceSetImpl)modelSet);
                uri = ModelSetService.resolveSharedRoot(ICrossReferenceIndex.getInstance((ResourceSet)modelSet), uri);
            }
            try {
                modelSet.loadModels(uri);
            }
            catch (ModelMultiException e) {
                Activator.log.error("Problem during the loading of models inside the ModelSet", (Throwable)e);
            }
        }
        return modelSet;
    }

    private static URI resolveSharedRoot(ICrossReferenceIndex index, URI resourceURI) {
        URI result;
        try {
            Set<URI> roots = index.getRoots(resourceURI, ICrossReferenceIndex.getAlternate(index, null));
            result = (URI)Iterables.getFirst(roots, (Object)resourceURI);
        }
        catch (CoreException e) {
            Activator.log.log(e.getStatus());
            result = resourceURI;
        }
        return result;
    }
}

