/****************************************************************************
 * Copyright (c) 2008, 2017 Atos Origin, CEA, ALL4TEC and others.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *		Thibault Landre (Atos Origin) - Initial API and implementation
 *		Mickaël ADAM (ALL4TEC) mickael.adam@all4tec.net - Bug 510587: the palette must not be generated by using GMF gen
 *		Etienne Allogo (ARTAL) - etienne.allogo@artal.fr - Bug 569174 : Remove reference to xpand/qvto
 *****************************************************************************/
package org.eclipse.papyrus.codegen;

import org.eclipse.papyrus.gmf.codegen.gmfgen.GenEditorGenerator;
import org.eclipse.papyrus.gmf.codegen.util.Generator;
import org.eclipse.papyrus.gmf.internal.codegen.popup.actions.ExecuteTemplatesOperation;

/**
 * The Papyrus execute templates operation
 *
 * @see org.eclipse.papyrus.gmf.internal.codegen.popup.actions.ExecuteTemplatesOperation
 * @author tlandre
 */
public class PapyrusExecuteTemplatesOperation extends ExecuteTemplatesOperation {

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected Generator createGenerator() {
		GenEditorGenerator genModel = getGenModel();
		return new PapyrusGenerator(genModel, new PapyrusCodegenEmitters(!genModel.isDynamicTemplates(), genModel.getTemplateDirectory()));
	}

}
