/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.validation.architecture.internal.checkers;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.toolsmiths.validation.common.checkers.IPluginChecker;
import org.eclipse.papyrus.toolsmiths.validation.common.utils.MarkersService;
import org.eclipse.papyrus.toolsmiths.validation.common.utils.ProjectManagementService;

public class ArchitectureExternalDependenciesChecker
implements IPluginChecker {
    private final IProject project;
    private final IFile architectureFile;
    private final Resource resource;

    public ArchitectureExternalDependenciesChecker(IProject project, IFile architectureFile, Resource resource) {
        this.project = project;
        this.architectureFile = architectureFile;
        this.resource = resource;
    }

    public void check(IProgressMonitor monitor) {
        if (monitor != null) {
            monitor.subTask("Validate dependencies for architecture '" + this.architectureFile.getName() + "'.");
        }
        Collection<URI> externalReferencesPaths = this.getExternalReferencesPaths(this.project, this.architectureFile, this.resource);
        HashSet<String> requiredPlugins = new HashSet<String>();
        externalReferencesPaths.stream().forEach(externalReferencePath -> {
            boolean bl = requiredPlugins.add(this.getPluginNameFromURI((URI)externalReferencePath));
        });
        HashSet existingRequiredPlugins = new HashSet();
        ProjectManagementService.getPluginDependencies((IProject)this.project).stream().forEach(dependency -> {
            boolean bl = existingRequiredPlugins.add(dependency.getName());
        });
        requiredPlugins.removeIf(requiredPlugin -> existingRequiredPlugins.contains(requiredPlugin));
        if (!requiredPlugins.isEmpty()) {
            IFile manifestFile = ProjectManagementService.getManifestFile((IContainer)this.project);
            requiredPlugins.stream().forEach(requiredPlugin -> MarkersService.createMarker((IResource)manifestFile, (String)"org.eclipse.papyrus.toolsmiths.validation.architecture.diagnostic", (String)("The plug-in '" + requiredPlugin + "' must be defined as required plug-in (for architecture file '" + this.architectureFile.getName() + "')."), (int)1));
        }
        if (monitor != null) {
            monitor.worked(1);
        }
    }

    private Collection<URI> getExternalReferencesPaths(IProject project, IFile architectureFile, Resource resource) {
        HashSet<URI> externalReferencesPaths = new HashSet<URI>();
        EcoreUtil.resolveAll((Resource)resource);
        for (Resource currentResource : resource.getResourceSet().getResources()) {
            URI resourceURI;
            if (this.isCurrentProjectReference(project, currentResource) || (resourceURI = currentResource.getURI()) == null || !resourceURI.toString().startsWith("platform:/") && !resourceURI.toString().startsWith("../")) continue;
            externalReferencesPaths.add(resourceURI);
        }
        return externalReferencesPaths;
    }

    private boolean isCurrentProjectReference(IProject project, Resource resource) {
        String resourceURI = resource.getURI().toString();
        return resourceURI.startsWith("platform:/plugin/" + project.getName() + "/") || resourceURI.startsWith("platform:/resource/" + project.getName() + "/");
    }

    private String getPluginNameFromURI(URI uri) {
        int takenSegment;
        String pluginName = null;
        int n = takenSegment = uri.hasAuthority() ? 0 : 1;
        if (uri.segmentCount() > takenSegment) {
            pluginName = uri.segment(takenSegment);
        }
        return pluginName;
    }
}

