/*****************************************************************************
 * Copyright (c) 2025 CEA LIST and others.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *   Vincent Lorenzo (CEA LIST) vincent.lorenzo@cea.fr - Initial API and implementation
 *
 *****************************************************************************/

package org.eclipse.papyrus.uml.ui.editors;

import org.eclipse.papyrus.infra.widgets.editors.richtext.GenericRichTextEditorConfiguration;
import org.eclipse.papyrus.infra.widgets.editors.richtext.SpellCheckToolbarButton;

/**
 * This class creates a the configuration to use for the RichTextEditor
 * This class replaces {@link org.eclipse.papyrus.uml.ui.editors.UMLToolbarConfiguration}
 *
 */
public class UMLRichTextEditorConfiguration extends GenericRichTextEditorConfiguration {

	/**
	 * Constructor.
	 *
	 */
	public UMLRichTextEditorConfiguration() {
		super();
	}

	/**
	 * @see org.eclipse.papyrus.infra.widgets.editors.richtext.GenericToolbarConfiguration#addSpellCheckToolbarButton()
	 *
	 */
	@Override
	protected void addSpellCheckToolbarButton() {
		SpellCheckToolbarButton action = new UMLSpellCheckToolbarButton();
		addToolbarButton(action);
	}

	/**
	 * @see org.eclipse.papyrus.infra.widgets.editors.richtext.GenericToolbarConfiguration#registerDefaultButton()
	 *
	 */
	@Override
	protected void registerDefaultButton() {
		super.registerDefaultButton();
		InsertReferenceToolbarButton insertAction = new InsertReferenceToolbarButton();
		addToolbarButton(insertAction);
	}
}
