/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.css.configuration.handler;

import java.util.List;
import java.util.Map;
import org.eclipse.e4.ui.css.core.css2.CSS2ColorHelper;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.draw2d.ui.graphics.ColorRegistry;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.papyrus.infra.gmfdiag.css.configuration.helper.DiagramTypeHelper;
import org.eclipse.papyrus.infra.gmfdiag.css.converters.ColorToGMFConverter;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.AttributeSelector;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.ColorTok;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.CssTok;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.IdentifierTok;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.IntegerTok;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.NumberTok;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.StringTok;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.SymbolTok;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.UrlTok;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.css_declaration;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.css_property;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.simple_selector;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.util.CSSSwitch;
import org.eclipse.papyrus.infra.widgets.Activator;
import org.eclipse.papyrus.infra.widgets.editors.AbstractEditor;
import org.eclipse.papyrus.infra.widgets.editors.BooleanCheckbox;
import org.eclipse.papyrus.infra.widgets.editors.EnumRadio;
import org.eclipse.papyrus.infra.widgets.editors.ICommitListener;
import org.eclipse.papyrus.infra.widgets.editors.StringEditor;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.StaticContentProvider;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.w3c.dom.css.RGBColor;

public abstract class AbstractStyleDialog
extends TrayDialog {
    protected final Map<AttributeSelector, Boolean> conditions;
    protected final Map<css_declaration, Boolean> declarations;
    protected final String selectorName;
    protected boolean useSelectorName = true;
    protected boolean diagramRestriction = false;
    protected String cssClass;
    protected View contextView;
    protected CLabel errorLabel;
    protected StringEditor selectorPreview;
    protected CTabFolder tabFolder;
    protected Composite conditionsContainer;
    protected Composite declarationsContainer;

    public AbstractStyleDialog(Shell shell, Map<AttributeSelector, Boolean> conditions, Map<css_declaration, Boolean> declarations, String selectorName, View context) {
        super(shell);
        this.conditions = conditions;
        this.declarations = declarations;
        this.selectorName = selectorName;
        this.contextView = context;
    }

    public void create() {
        super.create();
        Composite parent = this.getDialogArea();
        this.selectorPreview = new StringEditor(parent, 0);
        this.selectorPreview.setReadOnly(true);
        this.selectorPreview.setLabel("Selector preview:");
        this.selectorPreview.setLayoutData((Object)new GridData(4, 1, true, false));
        GridLayout layout = (GridLayout)this.selectorPreview.getLayout();
        layout.marginWidth = 0;
        this.tabFolder = new CTabFolder(parent, 2048);
        this.tabFolder.setLayoutData((Object)new GridData(4, 4, true, true));
        CTabItem conditionsTab = new CTabItem(this.tabFolder, 0);
        CTabItem declarationsTab = new CTabItem(this.tabFolder, 0);
        conditionsTab.setText("Conditions");
        declarationsTab.setText("Properties");
        this.conditionsContainer = new Composite((Composite)this.tabFolder, 0);
        this.conditionsContainer.setLayoutData((Object)new GridData(1, 1, true, true));
        this.conditionsContainer.setBackground(parent.getDisplay().getSystemColor(1));
        this.conditionsContainer.setBackgroundMode(1);
        conditionsTab.setControl((Control)this.conditionsContainer);
        this.declarationsContainer = new Composite((Composite)this.tabFolder, 0);
        this.declarationsContainer.setLayoutData((Object)new GridData(1, 1, true, true));
        this.declarationsContainer.setBackground(parent.getDisplay().getSystemColor(1));
        this.declarationsContainer.setBackgroundMode(1);
        declarationsTab.setControl((Control)this.declarationsContainer);
        this.createConditions(this.conditionsContainer);
        this.createDeclarations(this.declarationsContainer);
        this.updateSelectorLabel();
        this.updateButtons();
        this.tabFolder.setSelection(conditionsTab);
        this.getShell().pack();
    }

    protected void updateButtons() {
        this.setError(null);
        this.getButton(0).setEnabled(this.isValid());
        this.getDialogArea().layout();
    }

    protected boolean isValid() {
        boolean result = true;
        boolean atLeastOneDeclaration = false;
        for (Boolean value : this.declarations.values()) {
            if (!value.booleanValue()) continue;
            atLeastOneDeclaration = true;
            break;
        }
        boolean bl = result = result && atLeastOneDeclaration;
        if (!atLeastOneDeclaration) {
            this.setError("There must be at least one property declaration");
        }
        return result;
    }

    protected void setError(String errorMessage) {
        if (errorMessage == null && this.errorLabel != null) {
            this.errorLabel.dispose();
            this.errorLabel = null;
            return;
        }
        if (errorMessage != null) {
            if (this.errorLabel == null) {
                this.errorLabel = new CLabel(this.getDialogArea(), 64);
                this.errorLabel.setLayoutData((Object)new GridData(4, 1, true, false));
                this.errorLabel.setImage(Activator.getDefault().getImage("icons/error.gif"));
            }
            if (this.errorLabel.getText() != null && !this.errorLabel.getText().trim().equals("")) {
                this.errorLabel.setText(this.errorLabel.getText() + "\n" + errorMessage);
            } else {
                this.errorLabel.setText(errorMessage);
            }
        }
    }

    protected void createConditions(Composite parent) {
        parent.setLayout((Layout)new GridLayout(3, false));
        Label conditionsLabel = new Label(parent, 64);
        conditionsLabel.setText("Select the condition(s) under which the style will be applied.");
        conditionsLabel.setLayoutData((Object)new GridData(4, 1, true, false, 3, 1));
        this.createElementNameSection(parent);
        this.createAttributeSelectorsSection(parent);
        this.createStyleNameSection(parent);
    }

    protected void createElementNameSection(Composite parent) {
        EnumRadio diagramRestrictionWidget = new EnumRadio(parent, 0, "Diagram:");
        diagramRestrictionWidget.setLayoutData((Object)new GridData(4, 1, true, false, 3, 1));
        LabelProvider labelProvider = new LabelProvider(){

            public String getText(Object element) {
                Boolean value = (Boolean)element;
                return value != false ? DiagramTypeHelper.getDiagramType(AbstractStyleDialog.this.contextView.getDiagram()) + " only" : "Any diagram";
            }
        };
        diagramRestrictionWidget.setProviders((IStaticContentProvider)new StaticContentProvider((Object[])new Boolean[]{true, false}), (ILabelProvider)labelProvider);
        diagramRestrictionWidget.setValue((Object)this.diagramRestriction);
        diagramRestrictionWidget.addCommitListener(new ICommitListener(){

            public void commit(AbstractEditor editor) {
                AbstractStyleDialog.this.diagramRestriction = (Boolean)((EnumRadio)editor).getValue();
                AbstractStyleDialog.this.updateSelectorLabel();
            }
        });
        EnumRadio selectorNameWidget = new EnumRadio(parent, 0, "Applies to:");
        selectorNameWidget.setLayoutData((Object)new GridData(4, 1, true, false, 3, 1));
        labelProvider = new LabelProvider(){

            public String getText(Object element) {
                Boolean value = (Boolean)element;
                return value != false ? AbstractStyleDialog.this.selectorName + " only" : "Any kind of element";
            }
        };
        selectorNameWidget.setProviders((IStaticContentProvider)new StaticContentProvider((Object[])new Boolean[]{true, false}), (ILabelProvider)labelProvider);
        selectorNameWidget.setValue((Object)this.useSelectorName);
        selectorNameWidget.addCommitListener(new ICommitListener(){

            public void commit(AbstractEditor editor) {
                AbstractStyleDialog.this.useSelectorName = (Boolean)((EnumRadio)editor).getValue();
                AbstractStyleDialog.this.updateSelectorLabel();
            }
        });
    }

    protected void createAttributeSelectorsSection(Composite parent) {
        if (this.conditions.isEmpty()) {
            return;
        }
        Label detailLabel = new Label(parent, 0);
        detailLabel.setText("If the following properties are matched:");
        detailLabel.setLayoutData((Object)new GridData(4, 1, true, false, 3, 1));
        for (final AttributeSelector currentCondition : this.conditions.keySet()) {
            Object attributeLabel = currentCondition.getName();
            if (currentCondition.getValue() != null) {
                attributeLabel = (String)attributeLabel + " " + currentCondition.getOp() + " " + currentCondition.getValue();
            }
            BooleanCheckbox checkbox = new BooleanCheckbox(parent, 0, (String)attributeLabel);
            checkbox.setValue(this.conditions.get(currentCondition));
            checkbox.addCommitListener(new ICommitListener(){

                public void commit(AbstractEditor editor) {
                    AbstractStyleDialog.this.conditions.put(currentCondition, ((BooleanCheckbox)editor).getValue());
                    AbstractStyleDialog.this.updateSelectorLabel();
                }
            });
        }
    }

    protected void createStyleNameSection(Composite parent) {
        Label styleNameLabel = new Label(parent, 64);
        String label = "If a name is used for this style, it will have to be applied manually:";
        styleNameLabel.setText(label);
        styleNameLabel.setLayoutData((Object)new GridData(4, 1, true, false, 3, 1));
        StringEditor styleNameEditor = new StringEditor(parent, 0, "Style name:");
        styleNameEditor.setLayoutData((Object)new GridData(4, 1, true, false, 3, 1));
        styleNameEditor.setValue((Object)this.cssClass);
        styleNameEditor.addCommitListener(new ICommitListener(){

            public void commit(AbstractEditor editor) {
                AbstractStyleDialog.this.cssClass = (String)((StringEditor)editor).getValue();
                AbstractStyleDialog.this.updateSelectorLabel();
            }
        });
    }

    protected void createDeclarations(Composite parent) {
        parent.setLayout((Layout)new GridLayout(3, false));
        Label declarationsLabel = new Label(parent, 64);
        declarationsLabel.setText("Select the properties you want to set. Unchecked properties will keep their default value\n (Which might be inherited from another style).");
        declarationsLabel.setLayoutData((Object)new GridData(4, 1, true, false, 3, 1));
        for (css_declaration declaration : this.declarations.keySet()) {
            Composite propertyComposite = new Composite(parent, 0);
            GridLayout compositeLayout = new GridLayout(2, false);
            compositeLayout.marginWidth = 0;
            compositeLayout.marginHeight = 0;
            propertyComposite.setLayout((Layout)compositeLayout);
            propertyComposite.setLayoutData((Object)new GridData(4, 4, false, false));
            String label = declaration.getProperty().getName() + ": " + this.getLabel((List<CssTok>)declaration.getValueTokens());
            final BooleanCheckbox checkbox = new BooleanCheckbox(propertyComposite, 0);
            checkbox.setLayoutData((Object)new GridData(4, 4, false, false));
            Label labelWidget = new Label(propertyComposite, 0);
            labelWidget.setText(label);
            MouseAdapter listener = new MouseAdapter(){

                public void mouseUp(MouseEvent e) {
                    checkbox.setValue(Boolean.valueOf(checkbox.getValue() == false));
                }
            };
            propertyComposite.addMouseListener((MouseListener)listener);
            labelWidget.addMouseListener((MouseListener)listener);
            Color[] colors = this.getColors((List<CssTok>)declaration.getValueTokens());
            propertyComposite.setBackground(colors[0]);
            labelWidget.setForeground(colors[1]);
            final css_declaration currentDeclaration = declaration;
            checkbox.setValue(this.declarations.get(currentDeclaration));
            checkbox.addCommitListener(new ICommitListener(){

                public void commit(AbstractEditor editor) {
                    boolean value = ((BooleanCheckbox)editor).getValue();
                    AbstractStyleDialog.this.declarations.put(currentDeclaration, value);
                    AbstractStyleDialog.this.updateButtons();
                }
            });
            checkbox.setValue(this.declarations.get(declaration));
        }
    }

    protected Color[] getColors(List<CssTok> expression) {
        for (CssTok subterm : expression) {
            if (!(subterm instanceof ColorTok)) continue;
            return this.getColors((ColorTok)subterm);
        }
        return new Color[]{Display.getDefault().getSystemColor(1), Display.getDefault().getSystemColor(2)};
    }

    protected Color[] getColors(ColorTok hexColor) {
        Color color;
        Color[] colors = new Color[]{Display.getDefault().getSystemColor(1), Display.getDefault().getSystemColor(2)};
        colors[0] = color = this.getColor(hexColor);
        if (this.getLightness(color) < 130) {
            colors[1] = Display.getDefault().getSystemColor(1);
        }
        return colors;
    }

    private int getLightness(Color color) {
        int M = Math.max(color.getGreen(), Math.max(color.getRed(), color.getBlue()));
        int m = Math.min(color.getGreen(), Math.min(color.getRed(), color.getBlue()));
        int L = (M + m) / 2;
        return L;
    }

    protected Color getColor(ColorTok color) {
        RGBColor rgbColor = CSS2ColorHelper.getRGBColor((String)color.getValue());
        int intColor = ColorToGMFConverter.getIntColor((RGBColor)rgbColor);
        return ColorRegistry.getInstance().getColor(Integer.valueOf(intColor));
    }

    public String getCSSClass() {
        if (this.cssClass != null) {
            return this.cssClass.trim().equals("") ? null : this.cssClass.trim();
        }
        return null;
    }

    protected String getLabel(List<CssTok> expression) {
        if (expression == null || expression.isEmpty()) {
            return "";
        }
        Object label = "";
        for (CssTok token : expression) {
            label = token instanceof SymbolTok ? (String)label + ((SymbolTok)token).getSymbol() : (String)label + " " + this.getLabel(token);
        }
        return ((String)label).trim().replaceAll("[ ]+", " ");
    }

    protected String getLabel(CssTok term) {
        return (String)new CSSSwitch<String>(){

            public String caseColorTok(ColorTok token) {
                return token.getValue();
            }

            public String caseIdentifierTok(IdentifierTok token) {
                return token.getName();
            }

            public String caseStringTok(StringTok token) {
                return token.getValue();
            }

            public String caseNumberTok(NumberTok token) {
                return Double.toString(token.getVal());
            }

            public String caseIntegerTok(IntegerTok token) {
                return Integer.toString(token.getVal());
            }

            public String caseUrlTok(UrlTok token) {
                Object label = "url('";
                label = (String)label + token.getUrl().getUrl();
                label = (String)label + "')";
                return label;
            }
        }.doSwitch((EObject)term);
    }

    protected void updateSelectorLabel() {
        Object selectorText = "";
        if (this.diagramRestriction) {
            selectorText = (String)selectorText + DiagramTypeHelper.getDiagramType(this.contextView.getDiagram()) + " ";
        }
        selectorText = (String)selectorText + (this.useSelectorName ? this.selectorName : "*");
        for (Map.Entry<AttributeSelector, Boolean> selectorEntry : this.conditions.entrySet()) {
            if (!selectorEntry.getValue().booleanValue()) continue;
            AttributeSelector condition = selectorEntry.getKey();
            selectorText = (String)selectorText + "[" + condition.getName() + condition.getOp() + condition.getValue() + "]";
        }
        if (this.cssClass != null && !"".equals(this.cssClass)) {
            selectorText = (String)selectorText + "." + this.cssClass;
        }
        this.selectorPreview.setValue(selectorText);
        this.getDialogArea().layout();
    }

    protected boolean isResizable() {
        return true;
    }

    public Composite getDialogArea() {
        return (Composite)super.getDialogArea();
    }

    public boolean useSelectorName() {
        return this.useSelectorName;
    }

    public boolean getDiagramRestriction() {
        return this.diagramRestriction;
    }

    protected final boolean equals(css_property p1, css_property p2) {
        return p1.getName().equals(p2.getName());
    }

    protected final String getElementName(simple_selector simpleSelector) {
        if (simpleSelector.getElement() != null) {
            return simpleSelector.getElement().getName();
        }
        return "*";
    }
}

