/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotml.deployment;

import java.util.Iterator;
import java.util.Stack;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.papyrus.RobotML.DeploymentPlan;
import org.eclipse.papyrus.robotml.deployment.StUtils;
import org.eclipse.uml2.common.util.UML2Util;
import org.eclipse.uml2.uml.AggregationKind;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.InstanceValue;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Slot;
import org.eclipse.uml2.uml.StructuralFeature;
import org.eclipse.uml2.uml.ValueSpecification;

public class DepUtils {
    public static InstanceSpecification getNamedSubInstance(InstanceSpecification owningInstance, String name) {
        Element cdp = owningInstance.getOwner();
        String candidateName = String.valueOf(owningInstance.getName()) + "." + name;
        if (cdp instanceof Package) {
            for (PackageableElement instance : ((Package)cdp).getPackagedElements()) {
                if (!(instance instanceof InstanceSpecification)) continue;
                InstanceSpecification candidate = (InstanceSpecification)instance;
                if (candidateName == null || !candidateName.equals(candidate.getName())) continue;
                return candidate;
            }
        }
        return null;
    }

    public static InstanceSpecification getMainInstance(Package cdp) {
        DeploymentPlan dp = StUtils.getApplication((Element)cdp, DeploymentPlan.class);
        return dp.getMainInstance();
    }

    public static void setMainInstance(Package cdp, InstanceSpecification mainInstance) {
        StUtils.apply((Element)cdp, DeploymentPlan.class);
        DeploymentPlan dp = StUtils.getApplication((Element)cdp, DeploymentPlan.class);
        dp.setMainInstance(mainInstance);
    }

    public static Class getImplementation(InstanceSpecification instance) {
        Classifier cl = DepUtils.getClassifier(instance);
        if (cl instanceof Class) {
            return (Class)cl;
        }
        return null;
    }

    public static Classifier getClassifier(InstanceSpecification instance) {
        Iterator classifierIt = instance.getClassifiers().iterator();
        if (classifierIt.hasNext()) {
            return (Classifier)classifierIt.next();
        }
        return null;
    }

    public static InstanceSpecification getInstanceForClassifier(Package cdp, Classifier cl) {
        for (PackageableElement pe : cdp.getPackagedElements()) {
            InstanceSpecification is;
            if (!(pe instanceof InstanceSpecification) || DepUtils.getClassifier(is = (InstanceSpecification)pe) != cl) continue;
            return is;
        }
        return null;
    }

    public static EList<Classifier> getContainedImplementations(InstanceSpecification is) {
        Iterator instances = DepUtils.getContainedInstances(is).iterator();
        UniqueEList list = new UniqueEList();
        while (instances.hasNext()) {
            Classifier implementation = DepUtils.getClassifier((InstanceSpecification)instances.next());
            list.add((Object)implementation);
        }
        return list;
    }

    public static Slot getSlot(InstanceSpecification is, Property property) {
        for (Slot slot : is.getSlots()) {
            if (slot.getDefiningFeature() != property) continue;
            return slot;
        }
        return null;
    }

    public static InstanceSpecification getInstance(Slot slot) {
        for (ValueSpecification value : slot.getValues()) {
            if (!(value instanceof InstanceValue)) continue;
            return ((InstanceValue)value).getInstance();
        }
        return null;
    }

    public static EList<InstanceSpecification> getContainedInstances(InstanceSpecification is) {
        BasicEList contained = new BasicEList();
        for (Slot slot : is.getSlots()) {
            InstanceSpecification instance = DepUtils.getInstance(slot);
            if (instance == null) continue;
            contained.add((Object)instance);
        }
        return contained;
    }

    public static EList<Slot> getReferencingSlots(InstanceSpecification is) {
        BasicEList list = new BasicEList();
        for (EStructuralFeature.Setting setting : UML2Util.getNonNavigableInverseReferences((EObject)is)) {
            ValueSpecification vs;
            Element owner;
            EObject eObj = setting.getEObject();
            if (!(eObj instanceof ValueSpecification) || !((owner = (vs = (ValueSpecification)eObj).getOwner()) instanceof Slot)) continue;
            list.add((Object)((Slot)owner));
        }
        return list;
    }

    public static Slot getParentSlot(InstanceSpecification is) {
        for (Slot slot : DepUtils.getReferencingSlots(is)) {
            if (!(slot.getDefiningFeature() instanceof Property) || ((Property)slot.getDefiningFeature()).getAggregation() != AggregationKind.COMPOSITE_LITERAL) continue;
            return slot;
        }
        return null;
    }

    public static InstanceSpecification getParentIS(InstanceSpecification is) {
        Slot parentSlot = DepUtils.getParentSlot(is);
        if (parentSlot != null) {
            return parentSlot.getOwningInstance();
        }
        return null;
    }

    public static Stack<Slot> getAccessPath(InstanceSpecification is) {
        Stack<Slot> path = new Stack<Slot>();
        while (is != null) {
            Slot parentSlot = DepUtils.getParentSlot(is);
            if (parentSlot == null) break;
            path.insertElementAt(parentSlot, 0);
            is = parentSlot.getOwningInstance();
        }
        return path;
    }

    public static boolean isShared(Slot slot) {
        StructuralFeature df = slot.getDefiningFeature();
        if (df instanceof Property) {
            return ((Property)df).getAggregation() == AggregationKind.SHARED_LITERAL;
        }
        return false;
    }
}

