/*******************************************************************************
 * Copyright (c) 2016 CEA LIST
 *
 * All rights reserved. This program and the accompanying materials are
 * made available under the terms of the Eclipse Public License 2.0 which
 * accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *   Ansgar Radermacher - Initial API and implementation
 *******************************************************************************/

package org.eclipse.papyrus.designer.languages.idl.codegen.preferences;

import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.papyrus.designer.languages.idl.codegen.Activator;


public class IDLCodeGenPreferenceInitializer extends AbstractPreferenceInitializer {
	
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer#initializeDefaultPreferences()
	 */
	public void initializeDefaultPreferences() {
		IPreferenceStore store = Activator.getDefault().getPreferenceStore();
		store.setDefault(IDLCodeGenConstants.P_IDL_SUFFIX, "idl"); //$NON-NLS-1$

		// Default value for P_IDL_COMMENT_HEADER
		String NL = System.getProperties().getProperty("line.separator"); //$NON-NLS-1$
		String defaultValue =
			"// --------------------------------------------------------" + NL + //$NON-NLS-1$
			"// Code generated by Papyrus IDL" + NL + //$NON-NLS-1$
			"// --------------------------------------------------------" + NL + //$NON-NLS-1$
			NL;
		store.setDefault(IDLCodeGenConstants.P_IDL_COMMENT_HEADER, defaultValue);
	}

}
