/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.impactanalyzer.benchmark.preparation.model;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.ocl.examples.impactanalyzer.benchmark.preparation.model.IncrementalResourceShrinker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShrinkedResourceProvider {
    private final Resource fullSizeResource;
    private final ArrayList<Resource> shrinkedResourceList = new ArrayList();
    private boolean resourcesWereShrinked = false;

    public boolean resourcesWereShrinked() {
        return this.resourcesWereShrinked;
    }

    public ShrinkedResourceProvider(Resource sourceResource) {
        this.fullSizeResource = sourceResource;
    }

    public ArrayList<Resource> getAllResourcesFromLargeToSmall() {
        ArrayList<Resource> result = new ArrayList<Resource>();
        result.add(this.fullSizeResource);
        result.addAll(this.shrinkedResourceList);
        return result;
    }

    public void runShrinkingProcess() {
        System.out.println("\t\tResource Shrinking Process started...");
        IncrementalResourceShrinker resourceShrinker = new IncrementalResourceShrinker();
        this.shrinkedResourceList.addAll(resourceShrinker.shrinkIncrementally(this.fullSizeResource));
        this.resourcesWereShrinked = true;
        System.out.println("\t\tResource Shrinking Process finished with " + this.shrinkedResourceList.size() + " resources");
    }

    public void persistShrinkedResource() {
        try {
            String resourcePath = "fixtures/models/" + this.fullSizeResource.getURI().lastSegment();
            System.out.println(resourcePath);
            File f = new File("/tmp/" + resourcePath);
            f.getParentFile().mkdirs();
            f.createNewFile();
            FileOutputStream fos = new FileOutputStream(f);
            this.fullSizeResource.save((OutputStream)fos, null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void loadPersistetShrinkedResources() {
        throw new RuntimeException("Not implemented at the moment");
    }
}

