/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.java;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum PrefixExpressionKind implements Enumerator
{
    INCREMENT(1, "INCREMENT", "++"),
    DECREMENT(2, "DECREMENT", "--"),
    PLUS(3, "PLUS", "+"),
    MINUS(4, "MINUS", "-"),
    COMPLEMENT(5, "COMPLEMENT", "~"),
    NOT(6, "NOT", "!");

    public static final int INCREMENT_VALUE = 1;
    public static final int DECREMENT_VALUE = 2;
    public static final int PLUS_VALUE = 3;
    public static final int MINUS_VALUE = 4;
    public static final int COMPLEMENT_VALUE = 5;
    public static final int NOT_VALUE = 6;
    private static final PrefixExpressionKind[] VALUES_ARRAY;
    public static final List<PrefixExpressionKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new PrefixExpressionKind[]{INCREMENT, DECREMENT, PLUS, MINUS, COMPLEMENT, NOT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static PrefixExpressionKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PrefixExpressionKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PrefixExpressionKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PrefixExpressionKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PrefixExpressionKind get(int value) {
        switch (value) {
            case 1: {
                return INCREMENT;
            }
            case 2: {
                return DECREMENT;
            }
            case 3: {
                return PLUS;
            }
            case 4: {
                return MINUS;
            }
            case 5: {
                return COMPLEMENT;
            }
            case 6: {
                return NOT;
            }
        }
        return null;
    }

    private PrefixExpressionKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

