/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.prefuse.examples.radialgraphview;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JPanel;
import org.eclipse.gmt.modisco.infra.prefuse.examples.radialgraphview.RadialGraphView;
import prefuse.Visualization;
import prefuse.controls.Control;
import prefuse.controls.ControlAdapter;
import prefuse.data.Graph;
import prefuse.data.Table;
import prefuse.data.io.GraphMLReader;
import prefuse.data.query.SearchQueryBinding;
import prefuse.data.search.SearchTupleSet;
import prefuse.data.tuple.TupleSet;
import prefuse.util.FontLib;
import prefuse.util.ui.JFastLabel;
import prefuse.util.ui.JSearchPanel;
import prefuse.util.ui.UILib;
import prefuse.visual.VisualItem;

public class RadialGraphViewUtils {
    public static JPanel demo(String datafile, String label) {
        Graph g = null;
        try {
            g = new GraphMLReader().readGraph(datafile);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        return RadialGraphViewUtils.demo(g, label);
    }

    public static JPanel demo(Graph g, final String label) {
        RadialGraphView gview = new RadialGraphView(g, label);
        Visualization vis = gview.getVisualization();
        SearchQueryBinding sq = new SearchQueryBinding((TupleSet)((Table)vis.getGroup("tree.nodes")), label, (SearchTupleSet)vis.getGroup(Visualization.SEARCH_ITEMS));
        JSearchPanel search = sq.createSearchPanel();
        search.setShowResultCount(true);
        search.setBorder(BorderFactory.createEmptyBorder(5, 5, 4, 0));
        search.setFont(FontLib.getFont((String)"Tahoma", (int)0, (int)11));
        final JFastLabel title = new JFastLabel("                 ");
        title.setPreferredSize(new Dimension(350, 20));
        title.setVerticalAlignment(3);
        title.setBorder(BorderFactory.createEmptyBorder(3, 0, 0, 0));
        title.setFont(FontLib.getFont((String)"Tahoma", (int)0, (int)16));
        gview.addControlListener((Control)new ControlAdapter(){

            public void itemEntered(VisualItem item, MouseEvent e) {
                if (item.canGetString(label)) {
                    title.setText(item.getString(label));
                }
            }

            public void itemExited(VisualItem item, MouseEvent e) {
                title.setText(null);
            }
        });
        Box box = new Box(0);
        box.add(Box.createHorizontalStrut(10));
        box.add((Component)title);
        box.add(Box.createHorizontalGlue());
        box.add((Component)search);
        box.add(Box.createHorizontalStrut(3));
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)((Object)gview), "Center");
        panel.add((Component)box, "South");
        Color BACKGROUND = Color.WHITE;
        Color FOREGROUND = Color.DARK_GRAY;
        UILib.setColor((Component)panel, (Color)BACKGROUND, (Color)FOREGROUND);
        return panel;
    }
}

